/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.bdctrl.BdCtrlStrtgyUtils;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BdCtrlStrategyShowControlPlugin
extends AbstractFormPlugin {
    private static final String PRO_CREATEORG = "createOrg";
    private static final String PRO_ORG = "org";
    private static final String PRO_ID = "id";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setControlVisibleAndEnable();
    }

    private void setControlVisibleAndEnable() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (StringUtils.isBlank((CharSequence)parentPageId)) {
            return;
        }
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(parentPageId);
        boolean isPersonModify = this.getPersonModify();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status != OperationStatus.ADDNEW || isPersonModify) {
            boolean notEquals;
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue(PRO_CREATEORG);
            DynamicObject org = (DynamicObject)this.getModel().getValue(PRO_ORG);
            if (org == null || createOrg == null) {
                return;
            }
            String useOrg = pageCache.get(PRO_CREATEORG);
            if (useOrg == null || useOrg.length() == 0) {
                return;
            }
            String billFormId = this.getModel().getDataEntityType().getName();
            String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)billFormId);
            long useOrgId = Long.parseLong(useOrg);
            Object mstId = this.getModel().getValue(masterIdPropName);
            Long masterId = 0L;
            if (mstId instanceof Long) {
                masterId = (Long)mstId;
            } else if (mstId instanceof DynamicObject) {
                masterId = (Long)((DynamicObject)mstId).getPkValue();
            }
            Object id = this.getModel().getValue(PRO_ID);
            boolean bl = notEquals = id != null && mstId != null && !id.equals(masterId);
            if (notEquals || useOrgId != createOrg.getLong(PRO_ID)) {
                DynamicObject originalData = BusinessDataServiceHelper.loadSingleFromCache((Object)masterId, (String)billFormId);
                if (originalData != null && originalData.getDynamicObject(PRO_CREATEORG) != null) {
                    org = originalData.getDynamicObject(PRO_CREATEORG);
                }
                BdCtrlStrtgyUtils.setVisibleByBdCtrlStrtgy(billFormId, org.getLong(PRO_ID), this.getView(), status);
            }
            this.getModel().setDataChanged(false);
        }
    }

    private boolean getPersonModify() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            return false;
        }
        Object obj = customParams.get("isPersonalizedModify");
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String isPersonalizeData;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && (operate.getType().equals("addnew") || operate.getType().equals("save")) && "1".equals(isPersonalizeData = operate.getOption().getVariableValue("ispersonalizedata", "0"))) {
            this.setControlVisibleAndEnable();
        }
    }
}

