/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BdDefCtrlStrtgyTreeListPlugin
extends AbstractListPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener {
    private static final String SUBSYSTEMTREE = "subsystemtree";
    private static final String ID_SPLIT = "_split_";
    private static final String BD_BDDEFCTRLSTRTGY = "bd_bddefctrlstrtgy";
    private static final String BILLLISTAP = "billlistap";
    private static final String REFLESH = "reflesh";
    public static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void initialize() {
        TreeView systeTtree = (TreeView)this.getControl(SUBSYSTEMTREE);
        systeTtree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        systeTtree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addListRowDoubleClickListener((ListRowClickListener)this);
        billList.addHyperClickListener(args -> {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, REFLESH);
            this.showBaseForm(BD_BDDEFCTRLSTRTGY, null, closeCallBack, ShowType.Modal, String.valueOf(billList.getFocusRowPkId()));
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.initTree();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "btn_add": {
                TreeView tree = (TreeView)this.getControl(SUBSYSTEMTREE);
                String nodeId = tree.getTreeState().getFocusNodeId();
                if (StringUtils.isBlank((String)nodeId)) break;
                String leavl = nodeId.split(ID_SPLIT)[0];
                if (!"2".equals(leavl)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7cfb\u7edf\u5e94\u7528", (String)"BdDefCtrlStrtgyTreeListPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    return;
                }
                String sysId = nodeId.split(ID_SPLIT)[1];
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, REFLESH);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("systemId", sysId);
                this.showBaseForm(BD_BDDEFCTRLSTRTGY, params, closeCallBack, ShowType.Modal, null);
                break;
            }
            case "btn_delete": {
                ListSelectedRowCollection selRows = billList.getSelectedRows();
                if (selRows == null || selRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e!", (String)"BdDefCtrlStrtgyTreeListPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"BdDefCtrlStrtgyTreeListPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
                break;
            }
            case "btn_reflesh": {
                billList = (BillList)this.getView().getControl(BILLLISTAP);
                billList.refresh();
                break;
            }
        }
    }

    private void initTree() {
        TreeView tree = (TreeView)this.getView().getControl(SUBSYSTEMTREE);
        tree.deleteAllNodes();
        List<Map<String, String>> bizCloudNodeList = this.getBizCloud();
        this.loadTreeRootData(bizCloudNodeList);
    }

    private List<Map<String, String>> getBizCloud() {
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, al.fname ");
        sql.append(" from t_meta_bizcloud a ");
        sql.append(" inner join t_meta_bizcloud_l al ");
        sql.append(" on a.fid = al.fid ");
        sql.append(String.format(" where al.flocaleid = '%s' ", Locale.getDefault().toString()));
        sql.append(" and exists ( ");
        sql.append(" \tselect 1 from t_meta_entitydesign e ");
        sql.append(" \tleft join t_meta_bizunitrelform b ");
        sql.append(" \ton e.fid = b.fformid ");
        sql.append(" \tleft join t_meta_bizapp c ");
        sql.append(" \ton b.fbizappid = c.fid  ");
        sql.append(" \twhere e.fmodeltype IN ('BaseFormModel', 'BillFormModel') ");
        sql.append(" \tand  c.fbizcloudid = a.fid ");
        sql.append(" \tand  c.fdeploystatus =2");
        sql.append(" \tand  e.fistemplate = 0 ");
        sql.append(" ) ");
        List bizCloudList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<List<Map<String, String>>>(){

            public List<Map<String, String>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
                while (rs.next()) {
                    HashMap<String, String> bizCloudMap = new HashMap<String, String>();
                    bizCloudMap.put("id", "1_split_" + rs.getString(1));
                    bizCloudMap.put("name", rs.getString(2));
                    result.add(bizCloudMap);
                }
                return result;
            }
        });
        return bizCloudList;
    }

    private void loadTreeRootData(List<Map<String, String>> treeData) {
        TreeView tree = (TreeView)this.getView().getControl(SUBSYSTEMTREE);
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"BdDefCtrlStrtgyTreeListPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        root.setId("0");
        root.setIsOpened(true);
        for (Map<String, String> subsystemData : treeData) {
            TreeNode subsystemTreeNode = new TreeNode();
            String id = subsystemData.get("id");
            String name = subsystemData.get("name");
            subsystemTreeNode.setParentid("");
            subsystemTreeNode.setId(id);
            subsystemTreeNode.setText(name);
            subsystemTreeNode.addChildren(new ArrayList());
            subsystemTreeNode.setData((Object)1);
            root.addChild(subsystemTreeNode);
        }
        tree.addNode(root);
        tree.focusNode(root);
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        TreeView treeView = (TreeView)treeNodeEvent.getSource();
        String parentId = String.valueOf(treeNodeEvent.getNodeId());
        int level = Integer.parseInt(parentId.split(ID_SPLIT)[0]);
        String parentTrueId = parentId.split(ID_SPLIT)[1];
        QFilter[] qfArr = new QFilter[1];
        DynamicObject[] dots = null;
        if (level == 1) {
            List<String> ids = this.findBizappExistsEntity(parentTrueId);
            qfArr[0] = new QFilter("id", "in", ids);
            dots = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,name", (QFilter[])qfArr);
        }
        if (dots != null) {
            for (void var11_11 : dots) {
                TreeNode childrenDataTree = new TreeNode();
                childrenDataTree.setParentid(String.valueOf(parentId));
                ILocaleString name = null;
                if (level == 1) {
                    childrenDataTree.setId("2_split_" + (String)var11_11.get("id"));
                    name = (ILocaleString)var11_11.get("name");
                    childrenDataTree.setText((String)name.get((Object)Locale.getDefault().toString()));
                }
                if (childrenDataTree == null) continue;
                treeView.addNode(childrenDataTree);
            }
        }
    }

    private List<String> findBizappExistsEntity(String bizCloudId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT A.FID ");
        sql.append(" FROM T_META_BIZAPP A");
        sql.append(" WHERE A.FBIZCLOUDID = ?");
        sql.append(" AND A.FDEPLOYSTATUS =2 ");
        sql.append(" AND EXISTS (  ");
        sql.append(" \tSELECT 1 FROM T_META_ENTITYDESIGN E");
        sql.append(" \tLEFT JOIN T_META_BIZUNITRELFORM B  ");
        sql.append(" \tON E.FID = B.FFORMID  ");
        sql.append(" \tWHERE  B.FBIZAPPID = A.FID ");
        sql.append(" \tAND E.FMODELTYPE IN ('BaseFormModel', 'BillFormModel')");
        sql.append(" )");
        Object[] filters = new String[]{bizCloudId};
        List formIdList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> result = new ArrayList<String>(16);
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
                result.remove("ZCD0/KV4F1A");
                return result;
            }
        });
        return formIdList;
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        QFilter f1 = null;
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        String id = String.valueOf(treeNodeEvent.getNodeId());
        if ("0".equals(id)) {
            this.afterTreeNodeClick(billList, null);
            return;
        }
        int level = Integer.parseInt(id.split(ID_SPLIT)[0]);
        String trueId = id.split(ID_SPLIT)[1];
        if (level == 1) {
            String sql = "select fid from t_meta_bizapp where fbizcloudid = ? and FDEPLOYSTATUS =2";
            Object[] filters = new String[]{trueId};
            List formIdList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])filters, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    ArrayList<String> result = new ArrayList<String>(16);
                    while (rs.next()) {
                        result.add(rs.getString("fid"));
                    }
                    return result;
                }
            });
            f1 = new QFilter("appsystem", "in", (Object)formIdList);
            billList.setFilter(f1);
        } else if (level == 2) {
            f1 = new QFilter("appsystem", "in", (Object)trueId).and(new QFilter("appsystem.deploystatus", "=", (Object)"2"));
            billList.setFilter(f1);
        }
        this.afterTreeNodeClick(billList, f1);
    }

    private void afterTreeNodeClick(BillList billList, QFilter filter) {
        this.getPageCache().put("curbasedataid", filter == null ? "" : filter.toSerializedString());
        FilterParameter fParameter = new FilterParameter();
        fParameter.setFilter(filter);
        billList.setQueryFilterParameter(fParameter);
        billList.clearSelection();
        billList.setPageIndex(0);
        billList.refresh();
    }

    private void showBaseForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, String pkId) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (pkId != null && pkId.trim().length() > 0) {
            param.setPkId((Object)pkId);
            param.setStatus(OperationStatus.EDIT);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (REFLESH.equals(e.getActionId())) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            billList.refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals("delete_comfirm") && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ListSelectedRowCollection selRows = billList.getSelectedRows();
            Object[] idArr = new Object[selRows.size()];
            int index = 0;
            for (ListSelectedRow row : selRows) {
                idArr[index] = (Long)row.getPrimaryKeyValue();
                ++index;
            }
            DynamicObjectCollection col = QueryServiceHelper.query((String)BD_BDDEFCTRLSTRTGY, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idArr), new QFilter("issystem", "=", (Object)false)});
            IDataEntityType dt = BusinessDataServiceHelper.newDynamicObject((String)BD_BDDEFCTRLSTRTGY).getDataEntityType();
            if (col.size() == idArr.length) {
                BusinessDataServiceHelper.delete((IDataEntityType)dt, (Object[])idArr);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"BdDefCtrlStrtgyTreeListPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            } else {
                Object[] idDelArr = new Object[col.size()];
                index = 0;
                for (DynamicObject row : col) {
                    idDelArr[index] = row.get("id");
                    ++index;
                }
                if (col.size() > 0) {
                    BusinessDataServiceHelper.delete((IDataEntityType)dt, (Object[])idDelArr);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"BdDefCtrlStrtgyTreeListPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u80fd\u5220\u9664", (String)"BdDefCtrlStrtgyTreeListPlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                }
            }
            billList.refresh();
        }
    }
}

