/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.pojo.CancelAssignProgressInfo;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.basedata.CancelAssignResult;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.bdctrl.helper.PermissionValidatorHelper;
import kd.bos.list.BillList;
import kd.bos.list.ListCache;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.threads.ThreadPool;

public class BdOrgF7ViewListFormPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(BdOrgF7ViewListFormPlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String PARAM_USE_ORG_ID = "useOrgId";
    private static final String PARAM_BD_ENTITY = "entityNumber";
    private static final String PARAM_CANCEL_DATA = "cancel_data";
    private static final String CACHE_KEY_PROGRESS = "cache_progress";
    private static final String CACHE_KEY_CANCEL_RS = "cache_cancel_rs";
    private static final String BOS_BD_FORM_PLUGIN = "bos-bd-formplugin";
    private static final int PRO_MIN_TOTAL_SIZE = 100000;
    private static final int PRO_MIN_ORG_SIZE = 100;
    private static final int BATCH_MAX_TOTAL_SIZE = 10000000;
    private static final String CALL_BACK_CANCEL_ASSIGN_NAME = "call_back_cancel_assign";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        if (!CollectionUtils.isEmpty((Collection)columns)) {
            columns.forEach(e -> e.setHyperlink(false));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (null != filterContainer) {
            String title = ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d", (String)"BdOrgF7ViewListFormPlugin_3", (String)BOS_BD_FORM_PLUGIN, (Object[])new Object[0]);
            ListCache listCache = new ListCache(this.getPageCache(), "filtercontainerap");
            listCache.setFilterContainerTitle(new LocaleString(title));
            filterContainer.setTitle(new LocaleString(title));
            this.getView().updateView("filtercontainerap");
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty("filtercontainerap", "tips", null);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (!(source instanceof Button)) {
            return;
        }
        Button btnOk = (Button)source;
        if (BTN_OK.equals(btnOk.getKey())) {
            String opName;
            long createOrg;
            boolean hasFuncPerm;
            Map paramsMap = this.getView().getFormShowParameter().getCustomParams();
            String appId = this.getView().getFormShowParameter().getAppId();
            String entityNumber = (String)paramsMap.get(PARAM_BD_ENTITY);
            Object param = paramsMap.get(PARAM_CANCEL_DATA);
            List dataIds = Collections.emptyList();
            if (null != param) {
                dataIds = SerializationUtils.fromJsonStringToList((String)param.toString(), Long.class);
            }
            if (!(hasFuncPerm = PermissionValidatorHelper.checkFuncPerm("DIM_ORG", createOrg = Long.parseLong(paramsMap.get(PARAM_USE_ORG_ID).toString()), appId, entityNumber, "80513209000000ac", opName = ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d", (String)"BdOrgF7ViewListFormPlugin_3", (String)BOS_BD_FORM_PLUGIN, (Object[])new Object[0]), this.getView()))) {
                evt.setCancel(true);
                return;
            }
            Map<String, Object> map = PermissionValidatorHelper.checkDataRule(appId, entityNumber, "80513209000000ac", (Long)createOrg, opName, dataIds);
            List messages = (List)map.get("messages");
            if (!messages.isEmpty()) {
                FormShowParameter parameter = PermissionValidatorHelper.buildFormShowParameter(messages);
                this.getView().showForm(parameter);
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (!(source instanceof Button)) {
            return;
        }
        Button btnOk = (Button)source;
        if (!BTN_OK.equals(btnOk.getKey())) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d6\u6d88\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"BdOrgF7ViewListFormPlugin_0", (String)BOS_BD_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.executeCancelAssign(selectedRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientCallBack(ClientCallBackEvent e) {
        if (!CALL_BACK_CANCEL_ASSIGN_NAME.equals(e.getName())) {
            return;
        }
        DLock lock = DLock.createReentrant((String)this.getView().getPageId());
        lock.lock();
        try {
            IPageCache pageCache = this.getPageCache();
            String cache = pageCache.getBigObject(CACHE_KEY_PROGRESS);
            if (StringUtils.isBlank((CharSequence)cache)) {
                this.getView().addClientCallBack(CALL_BACK_CANCEL_ASSIGN_NAME, Integer.valueOf(500));
                return;
            }
            CancelAssignProgressInfo progressInfo = (CancelAssignProgressInfo)SerializationUtils.fromJsonString((String)cache, CancelAssignProgressInfo.class);
            if (progressInfo.complete()) {
                this.getView().hideLoading();
                String value = pageCache.getBigObject(CACHE_KEY_CANCEL_RS);
                List result = Collections.emptyList();
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    result = SerializationUtils.fromJsonStringToList((String)value, CancelAssignResult.class);
                }
                this.executeCancelAssignResult(result);
                pageCache.removeBigObject(CACHE_KEY_CANCEL_RS);
                pageCache.removeBigObject(CACHE_KEY_PROGRESS);
            } else {
                boolean isIncr = progressInfo.incr();
                this.showProgressLoading(progressInfo.getCurrPercentage());
                this.getView().addClientCallBack(CALL_BACK_CANCEL_ASSIGN_NAME, Integer.valueOf(500));
                if (isIncr) {
                    pageCache.putBigObject(CACHE_KEY_PROGRESS, SerializationUtils.toJsonString((Object)progressInfo));
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void executeCancelAssign(ListSelectedRowCollection orgRows) {
        try {
            boolean isShowProgressLoading;
            ListSelectedRow org;
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Long currentOrgId = Long.valueOf(showParameter.getCustomParam(PARAM_USE_ORG_ID).toString());
            HashSet<Long> orgIds = new HashSet<Long>(orgRows.size());
            for (ListSelectedRow row : orgRows) {
                Long orgId = Long.valueOf(row.getPrimaryKeyValue().toString());
                orgIds.add(orgId);
            }
            Object param = showParameter.getCustomParam(PARAM_CANCEL_DATA);
            if (1 == orgIds.size() && currentOrgId.equals(Long.valueOf((org = orgRows.get(0)).getPrimaryKeyValue().toString()))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u53ef\u4ee5\u53d6\u6d88\u81ea\u5df1\u7684\u8bb0\u5f55\u3002", (String)"BdOrgF7ViewListFormPlugin_2", (String)BOS_BD_FORM_PLUGIN, (Object[])new Object[0]), org.getNumber()));
                return;
            }
            orgIds.remove(currentOrgId);
            List dataIds = new ArrayList(0);
            if (null != param) {
                dataIds = SerializationUtils.fromJsonStringToList((String)param.toString(), Long.class);
            }
            String entity = (String)showParameter.getCustomParam(PARAM_BD_ENTITY);
            boolean bl = isShowProgressLoading = orgIds.size() > 100 || orgIds.size() * dataIds.size() > 100000;
            if (isShowProgressLoading) {
                this.showProgressLoading(0);
                this.getView().addClientCallBack(CALL_BACK_CANCEL_ASSIGN_NAME, Integer.valueOf(500));
                List finalDataIds = dataIds;
                ThreadPool pool = BaseDataThreadPoolUtils.getBdCommonThreadPool();
                pool.submit(() -> this.batchExecuteCancelAssign(orgIds, entity, finalDataIds), RequestContext.get());
            } else {
                BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.INTERFACE_OP);
                List results = BaseDataServiceHelper.cancelAssign((String)entity, new HashSet(dataIds), orgIds);
                this.executeCancelAssignResult(results);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53d6\u6d88\u5206\u914d\u662f\u5931\u8d25", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"BdOrgF7ViewListFormPlugin_1", (String)BOS_BD_FORM_PLUGIN, (Object[])new Object[0]));
        }
    }

    private Boolean batchExecuteCancelAssign(Set<Long> orgIds, String entity, List<Long> dataIds) {
        try {
            int pageSize = 10000000 / orgIds.size();
            if (BaseDataCommonService.isTreeType((String)entity)) {
                this.batchExecuteCancelAssignTreeData(orgIds, entity, dataIds, pageSize);
            } else {
                int size = dataIds.size();
                int totalPage = size % pageSize > 0 ? size / pageSize + 1 : size / pageSize;
                double segment = (double)pageSize / (double)size;
                this.getPageCache().putBigObject(CACHE_KEY_PROGRESS, SerializationUtils.toJsonString((Object)new CancelAssignProgressInfo(segment)));
                for (int pageNo = 1; pageNo <= totalPage; ++pageNo) {
                    int fromIndex = (pageNo - 1) * pageSize;
                    int toIndex = Math.min(pageNo * pageSize, size);
                    HashSet<Long> values = new HashSet<Long>(dataIds.subList(fromIndex, toIndex));
                    BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.INTERFACE_OP);
                    List cancelAssignResults = BaseDataServiceHelper.cancelAssign((String)entity, values, orgIds);
                    this.updateCancelAssignResult(cancelAssignResults);
                    this.updateProgressInfo(toIndex, size, pageNo, segment, totalPage == pageNo);
                }
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("\u53d6\u6d88\u5206\u914d\u5f02\u5e38", (Throwable)e);
            this.executeCancelAssignError();
            this.getView().hideLoading();
            return Boolean.FALSE;
        }
    }

    private void batchExecuteCancelAssignTreeData(Set<Long> orgIds, String entity, List<Long> dataIds, int pageSize) {
        List nodes = new TreeBaseDataCommonService(entity).buildTreeNodesById(dataIds);
        ArrayList<HashSet<Long>> batchDataIds = new ArrayList<HashSet<Long>>(10);
        HashSet<Long> pageDataIds = new HashSet<Long>(16);
        for (TreeNode node : nodes) {
            this.collectCancelDataIds(node, pageDataIds);
            if (pageDataIds.size() < pageSize) continue;
            batchDataIds.add(pageDataIds);
            pageDataIds = new HashSet(16);
        }
        if (!pageDataIds.isEmpty()) {
            batchDataIds.add(pageDataIds);
        }
        int totalPage = batchDataIds.size();
        double segment = 1.0 / (double)totalPage;
        this.getPageCache().putBigObject(CACHE_KEY_PROGRESS, SerializationUtils.toJsonString((Object)new CancelAssignProgressInfo(segment)));
        for (int pageNo = 1; pageNo <= batchDataIds.size(); ++pageNo) {
            Set values = (Set)batchDataIds.get(pageNo - 1);
            BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.INTERFACE_OP);
            List cancelAssignResults = BaseDataServiceHelper.cancelAssign((String)entity, (Set)values, orgIds);
            this.updateCancelAssignResult(cancelAssignResults);
            this.updateProgressInfo(pageNo, totalPage, pageNo, segment, totalPage == pageNo);
        }
    }

    private void collectCancelDataIds(TreeNode node, Collection<Long> values) {
        values.add(Long.valueOf(node.getId()));
        List children = node.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        for (TreeNode childNode : children) {
            if (null == childNode) continue;
            this.collectCancelDataIds(childNode, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgressInfo(int toIndex, int size, int pageNo, double segment, boolean finish) {
        DLock lock = DLock.createReentrant((String)this.getView().getPageId());
        lock.lock();
        try {
            int currPercentage = (int)((double)toIndex / (double)size * 100.0);
            this.showProgressLoading(currPercentage);
            String value = this.getPageCache().getBigObject(CACHE_KEY_PROGRESS);
            CancelAssignProgressInfo progressInfo = StringUtils.isBlank((CharSequence)value) ? new CancelAssignProgressInfo(segment) : (CancelAssignProgressInfo)SerializationUtils.fromJsonString((String)value, CancelAssignProgressInfo.class);
            progressInfo.setPageNo(pageNo);
            progressInfo.setFinish(finish);
            progressInfo.setCurrPercentage(currPercentage);
            this.getPageCache().putBigObject(CACHE_KEY_PROGRESS, SerializationUtils.toJsonString((Object)progressInfo));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCancelAssignError() {
        DLock lock = DLock.createReentrant((String)this.getView().getPageId());
        lock.lock();
        try {
            String value = this.getPageCache().getBigObject(CACHE_KEY_PROGRESS);
            CancelAssignProgressInfo progressInfo = StringUtils.isBlank((CharSequence)value) ? new CancelAssignProgressInfo() : (CancelAssignProgressInfo)SerializationUtils.fromJsonString((String)value, CancelAssignProgressInfo.class);
            progressInfo.setFinish(false);
            this.getPageCache().putBigObject(CACHE_KEY_PROGRESS, SerializationUtils.toJsonString((Object)progressInfo));
            CancelAssignResult rs = new CancelAssignResult();
            rs.setSuccess(false);
            rs.setErrorMsg(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"BdOrgF7ViewListFormPlugin_1", (String)BOS_BD_FORM_PLUGIN, (Object[])new Object[0]));
            ArrayList<CancelAssignResult> error = new ArrayList<CancelAssignResult>(Collections.singletonList(rs));
            this.getPageCache().putBigObject(CACHE_KEY_CANCEL_RS, SerializationUtils.toJsonString(error));
        }
        finally {
            lock.unlock();
        }
    }

    private void updateCancelAssignResult(List<CancelAssignResult> cancelAssignResults) {
        List result;
        if (CollectionUtils.isEmpty(cancelAssignResults)) {
            return;
        }
        cancelAssignResults.removeIf(CancelAssignResult::isSuccess);
        if (cancelAssignResults.isEmpty()) {
            return;
        }
        String value = this.getPageCache().getBigObject(CACHE_KEY_CANCEL_RS);
        if (StringUtils.isBlank((CharSequence)value)) {
            result = cancelAssignResults;
        } else {
            result = SerializationUtils.fromJsonStringToList((String)value, CancelAssignResult.class);
            result.addAll(cancelAssignResults);
        }
        this.getPageCache().putBigObject(CACHE_KEY_CANCEL_RS, SerializationUtils.toJsonString((Object)result));
    }

    private void executeCancelAssignResult(List<CancelAssignResult> results) {
        results.removeIf(CancelAssignResult::isSuccess);
        if (results.isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u6210\u529f\u3002", (String)"BdOrgF7ViewListFormPlugin_4", (String)BOS_BD_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (results.size() == 1) {
            this.getView().showErrorNotification(results.get(0).getErrorMsg());
        } else {
            StringBuilder errorMsgSbd = new StringBuilder();
            results.forEach(result -> errorMsgSbd.append(result.getErrorMsg()).append("\r\n"));
            this.getView().showMessage(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"BdOrgF7ViewListFormPlugin_1", (String)BOS_BD_FORM_PLUGIN, (Object[])new Object[0]), errorMsgSbd.toString(), MessageTypes.Default);
        }
    }

    private void showProgressLoading(int currPercentage) {
        String msg = ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d...", (String)"BdOrgF7ViewListFormPlugin_5", (String)BOS_BD_FORM_PLUGIN, (Object[])new Object[0]);
        this.getView().showProgressLoading(new LocaleString(msg), currPercentage);
    }
}

