/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bd.ctsy.pojo.CtsyRecordSyncStatus;
import kd.bos.bd.ctsy.service.CtsyRetryService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CtsySyncRecordListPlugin
extends AbstractListPlugin {
    private static final String OP_RETRY = "retry";
    private static final String BILLLISTAP = "billlistap";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (OP_RETRY.equals(itemKey)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ListSelectedRowCollection rows = billList.getSelectedRows();
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)rows.getPrimaryKeyValues()), new QFilter("syncstatus", "in", (Object)CtsyRecordSyncStatus.SUCCESS.getStatus())};
            DynamicObject syncRecord = BusinessDataServiceHelper.loadSingleFromCache((String)"ctsy_ctrlstrategy_sync", (String)"syncstatus", (QFilter[])qFilters);
            if (null != syncRecord) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u7684\u8bb0\u5f55\u4e0d\u5141\u8bb8\u518d\u91cd\u8bd5\u3002", (String)"CtsySyncRecordListPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (OP_RETRY.equals(operate.getOperateKey())) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.isEmpty()) {
                return;
            }
            List syncRecordIds = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
            CtsyRetryService ctsyRetryService = new CtsyRetryService();
            ctsyRetryService.retry(syncRecordIds);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e6\u53d1\u6210\u529f\u3002", (String)"CtsySyncRecordListPlugin_1", (String)"bos-bd-formplugin", (Object[])new Object[0]));
        }
    }
}

