/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class DeleteBaseDataTreeValidator
extends AbstractValidator {
    public static final String BASEDATAUSEREGSUFFIX = "UseReg";
    public static final String LONGNUMBER = "longnumber";
    private static final String IS_MULTI_USEORG = "isMultiUseOrg";
    private static final Log log = LogFactory.getLog(DeleteBaseDataTreeValidator.class);

    public void validate() {
        if (this.dataEntities != null && this.dataEntities.length > 0) {
            IDataEntityType type = this.dataEntities[0].getDataEntity().getDataEntityType();
            this.deleteValidate((BasedataEntityType)type);
        }
    }

    public void deleteValidate(BasedataEntityType entityType) {
        String number = entityType.getNumberProperty();
        String entityNumber = entityType.getName();
        HashSet<String> failSet = new HashSet<String>();
        BaseDataCheckRefrence check = new BaseDataCheckRefrence();
        String primaryKey = entityType.getPrimaryKey().getName();
        String useOrgIDStr = null;
        try {
            useOrgIDStr = this.getOption().getVariableValue("createOrg");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Long useOrgID = 0L;
        boolean isMultiUseOrg = this.getOption().containsVariable(IS_MULTI_USEORG);
        if (!isMultiUseOrg) {
            if (StringUtils.isEmpty((CharSequence)useOrgIDStr)) {
                return;
            }
            useOrgID = Long.valueOf(useOrgIDStr);
        }
        String regex = "\\" + TreeBaseDataCommonService.getLongNumberDLM((String)this.getEntityKey());
        this.quickSortInternally(this.dataEntities, regex);
        Object[] dataIdArr = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).map(data -> data.getLong("id")).toArray();
        Map referenceResultMap = check.checkRef(entityType, dataIdArr);
        Map<Long, List<Long>> assignResultMap = this.getAssignMap(dataIdArr);
        String longNumberDLM = BaseDataCommonService.getLongNumberDLM((String)this.entityKey);
        if (".".equals(longNumberDLM)) {
            longNumberDLM = "\\.";
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            Long dataId;
            List<Long> assignResult;
            DynamicObject createorg;
            DynamicObject dynamicObject = this.dataEntities[i].getDataEntity();
            String longNumber = dynamicObject.getString(LONGNUMBER);
            String parentLongNumber = dynamicObject.getString("parent.longnumber");
            boolean enable = dynamicObject.getBoolean("enable");
            boolean flag = false;
            for (String string : failSet) {
                if (string == null) continue;
                List<String> numberSplit = Arrays.asList(longNumber.split(longNumberDLM.toLowerCase()));
                HashSet<String> failedSplit = new HashSet<String>(Arrays.asList(string.split(longNumberDLM)));
                if (StringUtils.isBlank((CharSequence)string) || !failedSplit.containsAll(numberSplit)) continue;
                flag = true;
                break;
            }
            if (flag) {
                failSet.add(longNumber);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5b50\u8282\u70b9\u672a\u80fd\u5220\u9664\u3002", (String)"DeleteBaseDataTreeValidator_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                this.dataEntities[i] = null;
                continue;
            }
            this.addIgnoreRefEntityIds(check);
            if (!enable) {
                failSet.add(longNumber);
                failSet.add(parentLongNumber);
            }
            if ((createorg = dynamicObject.getDynamicObject("createorg")) == null) continue;
            if (!isMultiUseOrg && !useOrgID.equals(createorg.getPkValue())) {
                failSet.add(longNumber);
                failSet.add(parentLongNumber);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DeleteBaseDataTreeValidator_1", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                this.dataEntities[i] = null;
                continue;
            }
            if (!BaseDataBusinessServiceUtils.isEnableVersion((String)entityNumber) && !CollectionUtils.isEmpty(assignResult = assignResultMap.get(dataId = Long.valueOf(dynamicObject.get(primaryKey).toString())))) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u88ab\u5206\u914d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DeleteBaseDataTreeValidator_2", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                continue;
            }
            BaseDataCheckRefrenceResult result = (BaseDataCheckRefrenceResult)referenceResultMap.get(dynamicObject.get(primaryKey));
            if (null == result || result.getRefenceKey() == null) continue;
            failSet.add(longNumber);
            failSet.add(parentLongNumber);
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"%s:\u5b58\u5728\u5f15\u7528\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DeleteBaseDataTreeValidator_3", (String)"bos-bd-formplugin", (Object[])new Object[0]), dynamicObject.get(number)));
            this.dataEntities[i] = null;
        }
    }

    private Map<Long, List<Long>> getAssignMap(Object[] dataIdArr) {
        String baseDataTableName = this.dataEntities[0].getDataEntity().getDataEntityType().getAlias();
        String dataTableUseName = baseDataTableName + BASEDATAUSEREGSUFFIX;
        String dbRouteKey = this.dataEntities[0].getDataEntity().getDataEntityType().getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" SELECT  mu.fuseorgid,mu.fdataid uoid from ", new Object[0]);
        sqlBuilder.append(dataTableUseName, new Object[0]).append(" mu where ", new Object[0]);
        sqlBuilder.appendIn("mu.fdataid", dataIdArr);
        sqlBuilder.append(" and mu.FisAssign = '1' ", new Object[0]);
        return (Map)DB.query((DBRoute)dbRoute, (SqlBuilder)sqlBuilder, rs -> {
            HashMap<Long, List> resultMap = new HashMap<Long, List>(this.dataEntities.length);
            while (rs.next()) {
                Long useOrgId = rs.getLong(1);
                Long dataId = rs.getLong(2);
                resultMap.computeIfAbsent(dataId, k -> new ArrayList(10)).add(useOrgId);
            }
            return resultMap;
        });
    }

    private void quickSortInternally(ExtendedDataEntity[] a, String regex) {
        Arrays.parallelSort(a, (src, pivot) -> {
            DynamicObject dynamicObject = src.getDataEntity();
            int srcLength = dynamicObject.getString(LONGNUMBER).split(regex).length;
            DynamicObject dest = pivot.getDataEntity();
            int destLength = dest.getString(LONGNUMBER).split(regex).length;
            return Integer.compare(destLength, srcLength);
        });
    }

    public int compare(ExtendedDataEntity arg0, ExtendedDataEntity arg1, BasedataEntityType entityType) {
        DynamicObject dynamicObject1 = arg0.getDataEntity();
        DynamicObject dynamicObject2 = arg1.getDataEntity();
        String longNumberDLM = ".";
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (!(property instanceof ParentBasedataProp)) continue;
            longNumberDLM = ((ParentBasedataProp)property).getLongNumberDLM();
        }
        if (dynamicObject1.getString(LONGNUMBER).split("\\" + longNumberDLM).length > dynamicObject2.getString(LONGNUMBER).split("\\" + longNumberDLM).length) {
            return 1;
        }
        return -1;
    }

    private void addIgnoreRefEntityIds(BaseDataCheckRefrence checker) {
        String[] entityIds;
        RefObject opValue = new RefObject();
        if (this.getOption().tryGetVariableValue("ignorerefentityids", opValue) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getIgnoreRefEntityIds().add(entityId);
            }
        }
        opValue = new RefObject();
        if (this.getOption().tryGetVariableValue("checkrefentityids", opValue) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getCheckRefEntityIds().add(entityId);
            }
        }
    }
}

