/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class FilterConditionPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeClickListener,
IConfirmCallBack,
SearchEnterListener {
    private static final Log LOGGER = LogFactory.getLog(FilterConditionPlugin.class);
    private static final String ENTITY_FILTER_CONDITION = "bd_filtercondition";
    private static final String TREE_VIEW = "treeView";
    private static final String ROOT_ID = "-1";
    private static final String NEW_TEMP_ID = "0";
    private static final String FILTER_CONDITION = "filterCondition";
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String ENTITY_ID = "entityId";
    private static final String FILTER_GRID = "filterGrid";
    private static final String BTN_RETURN = "btn_return";
    private static final String BTN_NEW = "btn_addnew";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_DEL = "btn_delete";
    private static final String DELETE_CONFIRM = "filterConditionDeleteConfirm";
    private static final String SEARCH_ID = "preSearchConditionId";
    private static final String SEARCH_TEXT = "preSearchConditionText";
    private static final String BILL_STATUS = "bill_status";
    private static final String CREATOR = "creator";
    private static final String OPERATION_DELETE = "delete";
    private static final String OPERATION_SAVE = "save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchAp");
        search.addEnterListener((SearchEnterListener)this);
        this.addItemClickListeners(new String[]{"toolbarap", BTN_RETURN});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean isRel;
        super.beforeItemClick(evt);
        String itemClick = evt.getItemKey();
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        List selectedNodeIds = treeView.getTreeState().getSelectedNodeId();
        List<String> keyNeedValidateSelected = Arrays.asList(BTN_SAVE, BTN_DEL, BTN_RETURN);
        if (keyNeedValidateSelected.contains(itemClick)) {
            if (CollectionUtils.isEmpty((Collection)selectedNodeIds) || ROOT_ID.equals(selectedNodeIds.get(0))) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"FilterConditionPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!BTN_SAVE.equals(itemClick) && NEW_TEMP_ID.equals(selectedNodeIds.get(0))) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848\u3002", (String)"FilterConditionPlugin_1", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (BTN_DEL.equals(itemClick) && (isRel = this.isFilterConditionRel(Long.valueOf((String)selectedNodeIds.get(0))))) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u65b9\u6848\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"FilterConditionPlugin_2", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (BTN_SAVE.equals(itemClick)) {
            this.beforeSaveItemClick(evt);
        }
    }

    private void beforeSaveItemClick(BeforeItemClickEvent evt) {
        String name = String.valueOf(this.getModel().getValue("name"));
        if (StringUtils.isEmpty((CharSequence)name)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8fc7\u6ee4\u65b9\u6848\u540d\u79f0\u201d\u3002", (String)"FilterConditionPlugin_3", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        FilterCondition filter = this.getFilterControl();
        if (CollectionUtils.isEmpty((Collection)filter.getFilterRow())) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u6761\u4ef6\u3002", (String)"FilterConditionPlugin_4", (String)"bos-bd-formplugin", (Object[])new Object[0]));
        }
        try {
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityId);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, filter);
            filterBuilder.buildFilter();
        }
        catch (KDBizException e) {
            LOGGER.error("\u4fdd\u5b58\u6570\u636e\u65b9\u6848\u5931\u8d25...", (Throwable)e);
            evt.setCancel(true);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u6570\u636e\u65b9\u6848\u5931\u8d25...", (Throwable)e);
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u65b9\u6848\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FilterConditionPlugin_11", (String)"bos-bd-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isFilterConditionRel(Long filterConditionId) {
        String sql = "select fid from t_bd_autoAssign_assignOrg where fFilterCondition = ?;";
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{filterConditionId}, ResultSet::next);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemClick;
        super.itemClick(evt);
        switch (itemClick = evt.getItemKey()) {
            case "btn_return": {
                this.returnFilterConditionToParent();
                break;
            }
            case "btn_addnew": {
                this.newFilterCondition();
                break;
            }
            case "btn_save": {
                this.saveFilterCondition();
                break;
            }
            case "btn_delete": {
                this.beforeDeleteFilterCondition();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (DELETE_CONFIRM.equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            this.deleteFilterCondition();
            this.getModel().setValue("name", (Object)"");
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRID);
            filterGrid.SetValue(new ArrayList(1));
            this.newFilterCondition();
        }
    }

    private void beforeDeleteFilterCondition() {
        String showMsg = ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u8fc7\u6ee4\u65b9\u6848\uff1f", (String)"FilterConditionPlugin_5", (String)"bos-bd-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(showMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_CONFIRM, (IFormPlugin)this));
    }

    private void deleteFilterCondition() {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        List nodeIds = treeView.getTreeState().getSelectedNodeId();
        long filterCondition = Long.parseLong((String)nodeIds.get(0));
        if (filterCondition == 0L) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"FilterConditionPlugin_6", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            this.loadFilterConditionTree();
            return;
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)OPERATION_DELETE, (String)ENTITY_FILTER_CONDITION, (Object[])new Object[]{filterCondition}, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"FilterConditionPlugin_6", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            this.loadFilterConditionTree();
        } else {
            this.getView().showOperationResult(result);
        }
    }

    private void saveFilterCondition() {
        DynamicObject filterConditionObj;
        FilterCondition filter = this.getFilterControl();
        String filterCondition = SerializationUtils.toJsonString((Object)filter);
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        List selectedNodeIds = treeView.getTreeState().getSelectedNodeId();
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        DynamicObject[] filterConditionArr = new DynamicObject[1];
        if (!CollectionUtils.isEmpty((Collection)selectedNodeIds) && !Long.valueOf((String)selectedNodeIds.get(0)).equals(0L)) {
            Long filterConditionId = Long.valueOf((String)selectedNodeIds.get(0));
            String selectProps = this.buildSelectFields(Arrays.asList("id", "name", FILTER_CONDITION, CREATOR, ENTITY_ID));
            filterConditionObj = BusinessDataServiceHelper.loadSingle((String)ENTITY_FILTER_CONDITION, (String)selectProps, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)filterConditionId)});
        } else {
            filterConditionObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_FILTER_CONDITION);
        }
        filterConditionObj.set("name", this.getModel().getValue("name"));
        filterConditionObj.set(FILTER_CONDITION, (Object)filterCondition);
        filterConditionObj.set(CREATOR, (Object)BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user"));
        filterConditionObj.set(ENTITY_ID, (Object)entityId);
        filterConditionArr[0] = filterConditionObj;
        OperationResult result = OperationServiceHelper.executeOperate((String)OPERATION_SAVE, (String)ENTITY_FILTER_CONDITION, (DynamicObject[])filterConditionArr, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"FilterConditionPlugin_7", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            this.loadFilterConditionTree();
            List successPkIds = result.getSuccessPkIds();
            if (!CollectionUtils.isEmpty((Collection)successPkIds)) {
                this.setFilterCondition(Long.valueOf(successPkIds.get(0).toString()));
            }
        } else {
            this.getView().showOperationResult(result);
        }
    }

    private String buildSelectFields(Collection<String> fields) {
        HashSet<String> fieldSet = new HashSet<String>(fields);
        fieldSet.addAll(Arrays.asList("id", "parent", "longnumber"));
        return String.join((CharSequence)String.valueOf(','), fieldSet);
    }

    private void newFilterCondition() {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        TreeNode newNode = new TreeNode(ROOT_ID, NEW_TEMP_ID, ResManager.loadKDString((String)"\u65b0\u5efa\u65b9\u6848", (String)"FilterConditionPlugin_8", (String)"bos-bd-formplugin", (Object[])new Object[0]), false);
        treeView.addNode(newNode);
        treeView.expand(ROOT_ID);
        treeView.focusNode(newNode);
        this.getModel().setValue("name", null);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRID);
        filterGrid.SetValue(new ArrayList(1));
    }

    private void returnFilterConditionToParent() {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
            List nodeIds = treeView.getTreeState().getSelectedNodeId();
            if (CollectionUtils.isEmpty((Collection)nodeIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"FilterConditionPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            Long filterConditionId = Long.valueOf((String)nodeIds.get(0));
            this.getView().getFormShowParameter().setCustomParam(FILTER_CONDITION, (Object)filterConditionId);
            this.getView().returnDataToParent((Object)this.getView().getFormShowParameter());
            this.getView().close();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRID);
        filterGrid.setEntityNumber(entityId);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadFilterConditionTree();
        Long filterConditionKey = this.getView().getFormShowParameter().getCustomParam(FILTER_CONDITION) instanceof Long ? (Long)this.getView().getFormShowParameter().getCustomParam(FILTER_CONDITION) : null;
        DynamicObject filterConditionObj = this.getFilterCondition(filterConditionKey);
        if (null != filterConditionObj) {
            this.getModel().setValue("name", filterConditionObj.get("name"));
        }
    }

    private void loadFilterConditionTree() {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        treeView.deleteAllNodes();
        TreeNode rootNode = new TreeNode("", ROOT_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"FilterConditionPlugin_9", (String)"bos-bd-formplugin", (Object[])new Object[0]), true);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        DynamicObjectCollection filterConditions = QueryServiceHelper.query((String)ENTITY_FILTER_CONDITION, (String)"id,name,filtercondition", (QFilter[])new QFilter[]{new QFilter(ENTITY_ID, "=", (Object)entityId)}, (String)"name");
        for (DynamicObject filterCondition : filterConditions) {
            String name = filterCondition.getString("name");
            TreeNode treeNode = new TreeNode();
            treeNode.setId(String.valueOf(filterCondition.getLong("id")));
            treeNode.setText(name);
            treeNode.setParentid(ROOT_ID);
            rootNode.addChild(treeNode);
        }
        treeView.addNode(rootNode);
        treeView.setRootVisible(true);
        treeView.setMulti(false);
        treeView.expand(ROOT_ID);
        treeView.queryTreeNodeChildren("", rootNode.getId());
        this.getView().sendFormAction(treeView.getView());
    }

    public void afterBindData(EventObject e) {
        Long filterConditionKey;
        super.afterBindData(e);
        Long l = filterConditionKey = this.getView().getFormShowParameter().getCustomParam(FILTER_CONDITION) instanceof Long ? (Long)this.getView().getFormShowParameter().getCustomParam(FILTER_CONDITION) : null;
        if (null == filterConditionKey) {
            this.newFilterCondition();
        }
        this.setFilterCondition(filterConditionKey);
        Object billStatus = this.getView().getFormShowParameter().getCustomParam(BILL_STATUS);
        if (null != billStatus) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_RETURN});
        }
    }

    private void setFilterCondition(Long filterConditionKey) {
        if (Objects.equals(Long.valueOf(ROOT_ID), filterConditionKey)) {
            this.getModel().setValue("name", null);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRID);
            filterGrid.SetValue(new FilterCondition());
            TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
            treeView.focusNode(new TreeNode("", ROOT_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"FilterConditionPlugin_9", (String)"bos-bd-formplugin", (Object[])new Object[0])));
            return;
        }
        DynamicObject filterConditionObj = this.getFilterCondition(filterConditionKey);
        if (null == filterConditionObj) {
            return;
        }
        String filterConditionStr = filterConditionObj.getString(FILTER_CONDITION);
        FilterCondition filterCondition = null;
        if (!StringUtils.isBlank((CharSequence)filterConditionStr)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRID);
            filterGrid.SetValue(filterCondition);
        }
        OrmLocaleValue filterConditionName = (OrmLocaleValue)filterConditionObj.getLocaleString("name");
        this.getModel().setValue("name", (Object)filterConditionName);
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        TreeNode node = new TreeNode(ROOT_ID, filterConditionKey.toString(), String.valueOf(filterConditionName), false);
        treeView.focusNode(node);
    }

    private DynamicObject getFilterCondition(Long filterConditionKey) {
        if (null == filterConditionKey || filterConditionKey.equals(0L)) {
            return null;
        }
        DynamicObject[] arr = BusinessDataServiceHelper.load((Object[])new Object[]{filterConditionKey}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_FILTER_CONDITION));
        if (null == arr || arr.length == 0) {
            return null;
        }
        return arr[0];
    }

    private FilterCondition getFilterControl() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRID);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        return filterGridState.getFilterCondition();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        if (NEW_TEMP_ID.equals(nodeId)) {
            this.getModel().setValue("name", null);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRID);
            filterGrid.SetValue(new ArrayList(1));
            return;
        }
        Long filterCondition = Long.valueOf(nodeId.toString());
        this.setFilterCondition(filterCondition);
    }

    public void search(SearchEnterEvent event) {
        String text = event.getText();
        DynamicObjectCollection filterConditionCol = QueryServiceHelper.query((String)ENTITY_FILTER_CONDITION, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("name", "like", (Object)("%" + text + "%"))});
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        switch (filterConditionCol.size()) {
            case 0: {
                treeView.focusNode(new TreeNode("", ROOT_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"FilterConditionPlugin_9", (String)"bos-bd-formplugin", (Object[])new Object[0])));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"FilterConditionPlugin_10", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                break;
            }
            case 1: {
                treeView.focusNode(new TreeNode(ROOT_ID, ((DynamicObject)filterConditionCol.get(0)).getString("id"), ((DynamicObject)filterConditionCol.get(0)).getString("name")));
                break;
            }
            default: {
                String preSearchConditionId = this.getPageCache().get(this.getPageCache().getPageId() + SEARCH_ID);
                String preSearchConditionText = this.getPageCache().get(this.getPageCache().getPageId() + SEARCH_TEXT);
                int index = 0;
                if (StringUtils.isNotEmpty((CharSequence)preSearchConditionText) && preSearchConditionText.equals(text)) {
                    for (int i = 0; i < filterConditionCol.size(); ++i) {
                        DynamicObject filterCondition = (DynamicObject)filterConditionCol.get(i);
                        String filterConditionId = filterCondition.getString("id");
                        if (!preSearchConditionId.equals(filterConditionId) || i >= filterConditionCol.size() - 1) continue;
                        index = i + 1;
                    }
                }
                String filterConditionId = ((DynamicObject)filterConditionCol.get(index)).getString("id");
                String filterConditionName = ((DynamicObject)filterConditionCol.get(index)).getString("name");
                treeView.focusNode(new TreeNode(ROOT_ID, filterConditionId, filterConditionName));
                treeView.treeNodeClick(ROOT_ID, filterConditionId);
                this.getPageCache().put(this.getPageCache().getPageId() + SEARCH_ID, filterConditionId);
                this.getPageCache().put(this.getPageCache().getPageId() + SEARCH_TEXT, text);
            }
        }
    }
}

