/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.service.AssignQueryService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.query.impl.CountQuery;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class LowerDataQueryPlugin
extends AbstractListPlugin
implements SearchEnterListener {
    public static final String BASEDATAUSEREGSUFFIX = "UseReg";
    public static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    public static final String ENTITYNUMBER = "entityNumber";
    public static final String USEORGID = "useOrgId";
    private static final String KEY_SEARCH_FIELD = "search_filed";
    private Set<Long> orgIds = null;

    public void initialize() {
        BillList billList = (BillList)this.getControl("billlistap");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityNumber = (String)parameter.getCustomParam(ENTITYNUMBER);
        billList.setBillFormId(entityNumber);
        billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new LowerDataQueryProvider(entityNumber)));
        billList.addCreateListColumnsListener(beforeCreateListColumnsArgs -> {
            if (BaseDataCommonService.isOtherMasterIdType((String)entityNumber)) {
                beforeCreateListColumnsArgs.getListColumn("name").setVisible(0);
                beforeCreateListColumnsArgs.getListColumn("number").setVisible(0);
            } else {
                beforeCreateListColumnsArgs.getListColumn("masterid.name").setVisible(0);
                beforeCreateListColumnsArgs.getListColumn("masterid.number").setVisible(0);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object org = parameter.getCustomParam(USEORGID);
        String entity = (String)parameter.getCustomParam(ENTITYNUMBER);
        if (StringUtils.isBlank((Object)org)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u7c7b\u578b\u5f02\u5e38", (String)"LowerDataQueryPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new LowerDataQueryProvider(entity)));
        QFilter commonFilter = this.getCommonFilter(entity);
        billList.getFilterParameter().getQFilters().add(commonFilter);
        billList.clearSelection();
    }

    private Set<Long> getOrgIds() {
        if (this.orgIds == null) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Object org = parameter.getCustomParam(USEORGID);
            String entity = (String)parameter.getCustomParam(ENTITYNUMBER);
            this.orgIds = this.getAllCuSubordinateOrgIds(Long.valueOf(org.toString()), entity);
        }
        return this.orgIds;
    }

    public void registerListener(EventObject e) {
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new LowerDataQueryProvider(entity)));
    }

    public void search(SearchEnterEvent event) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
        Set<Long> subordinateOrgIds = this.getOrgIds();
        if (CollectionUtils.isEmpty(subordinateOrgIds)) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setBillFormId(entityNumber);
        QFilter commonFilter = this.getCommonFilter(entityNumber);
        List searchFields = event.getSearchFields();
        if (null == searchFields || searchFields.isEmpty()) {
            this.getPageCache().remove(KEY_SEARCH_FIELD);
        } else {
            this.getPageCache().put(KEY_SEARCH_FIELD, SerializationUtils.toJsonString((Object)searchFields));
        }
        QFilter orFilter = this.getSearchFilter(entityNumber, event.getSearchFields());
        if (null != orFilter) {
            billList.setFilter(commonFilter.and(orFilter));
        } else {
            billList.setFilter(commonFilter);
        }
        billList.clearSelection();
        billList.refresh();
    }

    private QFilter getCommonFilter(String entity) {
        Set<Long> subordinateOrgIds = this.getOrgIds();
        return BaseDataServiceHelper.getBaseDataFilter((String)entity, new ArrayList<Long>(subordinateOrgIds), (boolean)false);
    }

    private QFilter getSearchFilter(String entityNumber, List<Map<String, Object>> searchFields) {
        if (null == searchFields || searchFields.isEmpty()) {
            return null;
        }
        QFilter orFilter = null;
        boolean isOtherMasterIdType = BaseDataCommonService.isOtherMasterIdType((String)entityNumber);
        for (Map<String, Object> map : searchFields) {
            List filedList = (List)map.get("fieldName");
            List textList = (List)map.get("value");
            String filelistStr = SerializationUtils.toJsonString((Object)filedList);
            String textlistStr = SerializationUtils.toJsonString((Object)textList);
            this.getPageCache().put("filedList", filelistStr);
            this.getPageCache().put("searchfiled", textlistStr);
            for (String filed : filedList) {
                if (isOtherMasterIdType) {
                    if ("number".equals(filed)) {
                        filed = "masterid.number";
                    }
                    if ("name".equals(filed)) {
                        filed = "masterid.name";
                    }
                }
                for (String s : textList) {
                    if (null == orFilter) {
                        orFilter = new QFilter(filed, "like", (Object)("%" + s + "%"));
                    }
                    QFilter filter = new QFilter(filed, "like", (Object)("%" + s + "%"));
                    orFilter = QFilter.or((QFilter)orFilter, (QFilter)filter);
                }
            }
        }
        return orFilter;
    }

    private Set<Long> getAllCuSubordinateOrgIds(Long currentOrgId, String entity) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        if (null == ctrlView) {
            return Collections.emptySet();
        }
        AssignQueryService service = new AssignQueryService(entity);
        Set result = service.getAllCuSubordinateOrgIds((Long)ctrlView.getPkValue(), currentOrgId);
        result.add(currentOrgId);
        return result;
    }

    private QFilter getSearchFilter(String entity) {
        String value = this.getPageCache().get(KEY_SEARCH_FIELD);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        List searchFields = SerializationUtils.fromJsonStringToList((String)value, Map.class);
        return this.getSearchFilter(entity, searchFields);
    }

    private class LowerDataQueryProvider
    extends ListDataProvider {
        private String entity;

        LowerDataQueryProvider(String entity) {
            this.entity = entity;
        }

        public int getRealCount() {
            return this.getCount();
        }

        public void setQueryBuilder(QueryBuilder queryBuilder) {
            queryBuilder.setExceedMaxCount(false);
            super.setQueryBuilder(queryBuilder);
        }

        public int getMaxCount() {
            return this.getCount();
        }

        private int getCount() {
            QueryBuilder queryBuilder = this.getQueryBuilder();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(Arrays.asList(queryBuilder.getFilters()));
            QFilter commonFilter = LowerDataQueryPlugin.this.getCommonFilter(this.entity);
            QFilter orFilter = LowerDataQueryPlugin.this.getSearchFilter(this.entity);
            if (null != orFilter) {
                commonFilter.and(orFilter);
            }
            filters.add(commonFilter);
            queryBuilder.setFilters(filters.toArray(new QFilter[0]));
            return CountQuery.getCount((QueryBuilder)queryBuilder);
        }
    }
}

