/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.Save;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class OrgFilterSchemePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String ENTITY_ORG_FILTER_SCHEME = "bd_org_filterscheme";
    private static final String ENTITY_ORG = "bos_org";
    private static final String TAB = "tabap";
    private static final String BTN_RETURN = "btn_return";
    private static final String BTN_NEW = "btn_addnew";
    private static final String BTN_SAVE = "bar_save";
    private static final String BTN_DELETE = "bar_delete";
    private static final String TREE_VIEW = "treeviewap";
    private static final String FILTER_GRID = "filtergrid";
    private static final String SEARCH_AP = "searchap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PROP_NAME = "name";
    private static final String PROP_ENTITY_ID = "entityid";
    private static final String PROP_SELECTED_ORG = "selectedorg";
    private static final String PROP_FILTER_CONDITION = "filtercondition";
    private static final String PROP_CREATOR_ID = "creator";
    private static final String PROP_MODIFIER_ID = "modifier";
    private static final String PARAM_ORG_VIEW_NUMBER = "orgViewSchemeNumber";
    private static final String PARAM_ORG_FILTER_SCHEME = "orgfilterscheme";
    private static final String PARAM_ASSIGN_ORG_ID = "assignOrgId";
    private static final String PARAM_CTRL_STRATEGY = "ctrlStrtgy";
    private static final String BOS_BD_FORMPLUGIN = "bos-bd-formplugin";
    private static final String CALLBACK_SELECT_ORG = "selectOrg";
    private static final String TOOL_BAR = "tbmain";
    private static final String TAB_SELECT_ORG = "orgselect";
    private static final String OPERATION_ORG_SELECT = "selectorg";
    private static final String OPERATION_ORG_DELETE = "deleteorg";
    private static final String OPERATION_DELETE = "delete";
    private static final String OPERATION_SAVE = "save";
    private static final String TEMP_ORG_F7 = "bos_orgtreelistf7";
    private static final String ROOT_ID = "-1";
    private static final String NEW_SCHEME_ID = "0";
    private static final String CACHE_SEARCH_TEXT = "searchText";
    private static final String CACHE_SEARCH_RESULT = "searchResult";
    private static final String CACHE_LAST_SEARCH_INDEX = "lastSearchIndex";
    private static final String ENTITY_NUMBER = "entityNumber";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TAB, TOOL_BAR});
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadFilterSchemeTree();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String orgFilterScheme = fsp.getCustomParams().getOrDefault(PARAM_ORG_FILTER_SCHEME, ROOT_ID);
        if (ROOT_ID.equals(orgFilterScheme.toString()) || NEW_SCHEME_ID.equals(orgFilterScheme.toString())) {
            this.newFilterScheme();
            this.focusTreeNode(NEW_SCHEME_ID);
        } else {
            this.loadSchemeById(orgFilterScheme.toString());
            this.focusTreeNode(orgFilterScheme.toString());
        }
    }

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRID);
        filterGrid.setEntityNumber(ENTITY_ORG);
    }

    public void afterBindData(EventObject e) {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        this.getModel().setValue(PROP_ENTITY_ID, (Object)entityId);
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue(PROP_NAME);
        if (null == name.getLocaleValue()) {
            String defaultNameStr = name.getDefaultItem();
            name.setLocaleValue(defaultNameStr);
        }
        this.loadFilterCondition();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        this.loadSchemeById(nodeId.toString());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (BTN_RETURN.equals(itemKey) && !fromDatabase) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848\u3002", (String)"OrgFilterSchemePlugin_0", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            evt.setCancel(true);
        } else if (BTN_DELETE.equals(itemKey)) {
            if (!fromDatabase) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b0\u589e\u65b9\u6848\u672a\u4fdd\u5b58\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"OrgFilterSchemePlugin_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String sql = "select fid from t_bd_autoAssign_assignOrg where forgfilterschemeid = ?;";
            Object currentSchemeId = this.getModel().getDataEntity().getPkValue();
            if (((Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{currentSchemeId}, ResultSet::next)).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"OrgFilterSchemePlugin_2", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (BTN_SAVE.equals(itemKey)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRID);
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            DynamicObjectCollection selectedOrgs = this.getModel().getEntryEntity(ENTRYENTITY);
            if (CollectionUtils.isEmpty((Collection)filterCondition.getFilterRow()) && CollectionUtils.isEmpty((Collection)selectedOrgs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u6216\u6dfb\u52a0\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"OrgFilterSchemePlugin_3", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Save) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRID);
            String filterCondition = SerializationUtils.toJsonString((Object)filterGrid.getFilterGridState().getFilterCondition());
            this.getModel().setValue(PROP_FILTER_CONDITION, (Object)filterCondition);
            boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (!fromDatabase) {
                long currUserId = RequestContext.get().getCurrUserId();
                this.getModel().setValue(PROP_CREATOR_ID, (Object)currUserId);
                this.getModel().setValue(PROP_MODIFIER_ID, (Object)currUserId);
                ((Save)args.getSource()).getOption().setVariableValue("org_scheme_new_data", Boolean.TRUE.toString());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (OPERATION_DELETE.equals(operateKey)) {
            this.getView().getFormShowParameter().setCustomParam(PARAM_ORG_FILTER_SCHEME, (Object)NEW_SCHEME_ID);
        } else if (OPERATION_SAVE.equals(operateKey) && args.getOperationResult().isSuccess()) {
            DynamicObject scheme = this.getModel().getDataEntity();
            if (null == scheme) {
                return;
            }
            TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
            ILocaleString name = scheme.getLocaleString(PROP_NAME);
            String nameStr = name.getLocaleValue();
            if (StringUtils.isEmpty((String)nameStr)) {
                nameStr = (String)name.getDefaultItem();
            }
            String schemePk = scheme.getPkValue().toString();
            TreeNode saveNode = new TreeNode(ROOT_ID, schemePk, nameStr);
            String currNodeId = treeView.getTreeState().getFocusNodeId();
            OperateOption option = ((Save)args.getSource()).getOption();
            if (null == currNodeId) {
                if (Boolean.parseBoolean(option.getVariableValue("org_scheme_new_data", Boolean.FALSE.toString()))) {
                    treeView.addNode(saveNode);
                } else {
                    treeView.updateNode(saveNode);
                }
            } else if (NEW_SCHEME_ID.equals(currNodeId)) {
                treeView.deleteNode(currNodeId);
                treeView.addNode(saveNode);
            } else {
                treeView.updateNode(saveNode);
            }
            option.removeVariable("org_scheme_new_data");
            treeView.focusNode(saveNode);
            this.cleanSearchCache(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        String operationKey = evt.getOperationKey();
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        if (TAB_SELECT_ORG.equals(itemKey) && OPERATION_ORG_SELECT.equals(operationKey)) {
            this.showOrgSelectF7(entityId);
        } else if (BTN_RETURN.equals(itemKey)) {
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
            this.getView().close();
        } else if (BTN_NEW.equals(itemKey)) {
            this.newFilterScheme();
        } else if (BTN_DELETE.equals(itemKey)) {
            this.cleanSearchCache(true);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getModel().setDataChanged(false);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        String callBackId = evt.getActionId();
        if (CALLBACK_SELECT_ORG.equals(callBackId) && (returnData = evt.getReturnData()) instanceof ListSelectedRowCollection) {
            List selectOrgIds = ((ListSelectedRowCollection)returnData).stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            for (Object selectOrgId : selectOrgIds) {
                int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue(PROP_SELECTED_ORG, selectOrgId, index);
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        LinkedList searchResult;
        String searchText = evt.getText();
        if (StringUtils.isEmpty((String)searchText)) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        String searchTextCache = this.getPageCache().get(CACHE_SEARCH_TEXT);
        int searchIndex = 0;
        if (!searchText.equals(searchTextCache)) {
            this.cleanSearchCache(false);
            this.getPageCache().put(CACHE_SEARCH_TEXT, searchText);
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
            QFilter filter = new QFilter(PROP_ENTITY_ID, "=", (Object)entityId);
            filter.and(PROP_NAME, "like", (Object)("%" + searchText + "%"));
            DynamicObjectCollection result = QueryServiceHelper.query((String)ENTITY_ORG_FILTER_SCHEME, (String)"id,name", (QFilter[])new QFilter[]{filter});
            if (CollectionUtils.isEmpty((Collection)result)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"OrgFilterSchemePlugin_4", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            searchResult = result.stream().map(v -> v.get("id").toString()).collect(Collectors.toCollection(LinkedList::new));
            this.getPageCache().putBigObject(CACHE_SEARCH_RESULT, SerializationUtils.toJsonString((Object)searchResult));
            this.getPageCache().put(CACHE_LAST_SEARCH_INDEX, NEW_SCHEME_ID);
        } else {
            if (StringUtils.isEmpty((String)this.getPageCache().getBigObject(CACHE_SEARCH_RESULT))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"OrgFilterSchemePlugin_4", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String searchResultCache = this.getPageCache().getBigObject(CACHE_SEARCH_RESULT);
            searchResult = (LinkedList)SerializationUtils.fromJsonString((String)searchResultCache, LinkedList.class);
            if (CollectionUtils.isEmpty((Collection)searchResult)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"OrgFilterSchemePlugin_4", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String lastSearchIndex = this.getPageCache().get(CACHE_LAST_SEARCH_INDEX);
            if (StringUtils.isNotEmpty((String)lastSearchIndex)) {
                searchIndex = Integer.parseInt(lastSearchIndex) + 1;
            }
            if (searchIndex >= searchResult.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5b8c\u6210\u3002", (String)"OrgFilterSchemePlugin_5", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        this.getPageCache().put(CACHE_LAST_SEARCH_INDEX, Integer.toString(searchIndex));
        String resultId = (String)searchResult.get(searchIndex);
        treeView.focusNode(new TreeNode(ROOT_ID, resultId, ""));
        this.loadSchemeById(resultId);
        this.loadFilterCondition();
    }

    private Object[] getSelectedOrgIds() {
        DynamicObjectCollection selectedOrgs = this.getModel().getEntryEntity(ENTRYENTITY);
        if (selectedOrgs.isEmpty()) {
            return new Object[0];
        }
        Object[] result = new Object[selectedOrgs.size()];
        int resultIndex = 0;
        for (DynamicObject selectedOrg : selectedOrgs) {
            result[resultIndex++] = selectedOrg.getLong("selectedorg.id");
        }
        return result;
    }

    private void loadFilterSchemeTree() {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        treeView.deleteAllNodes();
        TreeNode rootNode = new TreeNode("", ROOT_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgFilterSchemePlugin_6", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), true);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        Map orgFilterSchemes = BusinessDataServiceHelper.loadFromCache((String)ENTITY_ORG_FILTER_SCHEME, (String)"id,name,filtercondition", (QFilter[])new QFilter[]{new QFilter(PROP_ENTITY_ID, "=", (Object)entityId)}, (String)PROP_NAME);
        for (Map.Entry entry : orgFilterSchemes.entrySet()) {
            DynamicObject orgFilterScheme = (DynamicObject)entry.getValue();
            ILocaleString name = orgFilterScheme.getLocaleString(PROP_NAME);
            String nameStr = name.getLocaleValue();
            if (StringUtils.isEmpty((String)nameStr)) {
                nameStr = (String)name.getDefaultItem();
            }
            TreeNode treeNode = new TreeNode();
            treeNode.setId(entry.getKey().toString());
            treeNode.setText(nameStr);
            treeNode.setParentid(ROOT_ID);
            rootNode.addChild(treeNode);
        }
        treeView.addNode(rootNode);
        treeView.setRootVisible(true);
        treeView.setMulti(false);
        treeView.expand(ROOT_ID);
        treeView.queryTreeNodeChildren("", rootNode.getId());
        this.getView().sendFormAction(treeView.getView());
    }

    private void loadSchemeById(String schemeId) {
        DynamicObject scheme;
        if (ROOT_ID.equals(schemeId) || NEW_SCHEME_ID.equals(schemeId)) {
            scheme = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ORG_FILTER_SCHEME);
        } else {
            scheme = BusinessDataServiceHelper.loadSingle((String)ENTITY_ORG_FILTER_SCHEME, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(schemeId))});
            if (null == scheme) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u52a0\u8f7d\u9875\u9762\u3002", (String)"OrgFilterSchemePlugin_7", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        this.loadFilterCondition();
        ((BillModel)this.getModel()).push((Object)scheme);
        this.getView().updateView();
    }

    private void focusTreeNode(String nodeId) {
        if (StringUtils.isEmpty((String)nodeId)) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        TreeNode node = new TreeNode();
        node.setId(nodeId);
        treeView.focusNode(node);
    }

    private void newFilterScheme() {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        TreeNode newNode = new TreeNode(ROOT_ID, NEW_SCHEME_ID, ResManager.loadKDString((String)"\u65b0\u5efa\u65b9\u6848", (String)"OrgFilterSchemePlugin_8", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), false);
        treeView.addNode(newNode);
        treeView.expand(ROOT_ID);
        treeView.focusNode(newNode);
        this.loadSchemeById(NEW_SCHEME_ID);
    }

    private void showOrgSelectF7(String entityId) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        if (null == ctrlView) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u63a7\u5236\u7b56\u7565\u3002", (String)"OrgFilterSchemePlugin_9", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String viewNumber = ctrlView.getString("number");
        Long viewId = (Long)ctrlView.getPkValue();
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)ENTITY_ORG, (boolean)true);
        parameter.setFormId(TEMP_ORG_F7);
        parameter.setCustomParam(PARAM_ORG_VIEW_NUMBER, (Object)viewNumber);
        ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
        if (listFilterParameter == null) {
            listFilterParameter = new ListFilterParameter();
        }
        listFilterParameter.setFilter(new QFilter("id", "not in", (Object)this.getSelectedOrgIds()));
        listFilterParameter.setFilter(new QFilter("enable", "=", (Object)Boolean.TRUE));
        QFilter joinFilter = QFilter.of((String)"bos_org_structure.view = ?", (Object[])new Object[]{viewId}).and("bos_org_structure.isctrlunit", "=", (Object)Boolean.TRUE).and("bos_org_structure.isfreeze", "=", (Object)Boolean.FALSE);
        listFilterParameter.setFilter(QFilter.join((String)"id", (String)"bos_org_structure.org", (QFilter)joinFilter));
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String ctrlStrtgy = fsp.getCustomParam(PARAM_CTRL_STRATEGY).toString();
        if ("1".equals(ctrlStrtgy)) {
            Long assignOrgId = Long.valueOf(fsp.getCustomParam(PARAM_ASSIGN_ORG_ID).toString());
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)viewNumber, Collections.singletonList(assignOrgId), (boolean)false);
            listFilterParameter.setFilter(new QFilter("id", "in", (Object)subOrgIds));
        }
        parameter.setListFilterParameter(listFilterParameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_SELECT_ORG));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void loadFilterCondition() {
        String filterConditionStr = (String)this.getModel().getValue(PROP_FILTER_CONDITION);
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRID);
        if (StringUtils.isEmpty((String)filterConditionStr)) {
            filterGrid.SetValue(new FilterCondition());
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
        if (null != filterCondition) {
            filterGrid.SetValue(filterCondition);
        } else {
            filterGrid.SetValue(new FilterCondition());
        }
    }

    private void cleanSearchCache(boolean clearSearchAp) {
        this.getPageCache().remove(CACHE_SEARCH_TEXT);
        this.getPageCache().removeBigObject(CACHE_SEARCH_RESULT);
        this.getPageCache().remove(CACHE_LAST_SEARCH_INDEX);
        if (clearSearchAp) {
            ((Search)this.getControl(SEARCH_AP)).setSearchKey("");
        }
    }
}

