/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.common.BaseDataCtrlLog;
import kd.bos.basedata.service.BDCtrlLogServiceHelper;
import kd.bos.basedata.service.BaseDataServiceImpl;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.ChangeManageRightService;
import kd.bos.bd.utils.BaseDataMutexUtils;
import kd.bos.bd.validator.ChangeManageRightValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.AssignQueryResponse;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.bdctrl.helper.PermissionValidatorHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.validate.DataMutexResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.jetbrains.annotations.NotNull;

public class OrgPermChangePlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(OrgPermChangePlugin.class);
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private static final String CTRL_TARGET_ORG = "targetorg";
    private static final String CTRL_SAVE = "save";
    private static final String OP_MODIFY = "modify";
    private static final String KEY_MUTEX_LOCK_RET = "mutex_lock_Key";
    public static final String BASEDATAUSEREGSUFFIX = "UseReg";
    public static final String BASEDATAUSERANGESUFFIX = "_U";
    public static final String CTRLSTRATEGY_CU_ASSIGN = "1";
    public static final String CTRLSTRATEGY_CU_FREE_ASSIGN = "2";
    public static final String CTRLSTRATEGY_OU_ASSIGN = "3";
    public static final String CTRLSTRATEGY_OU_FREE_ASSIGN = "4";
    public static final String CTRLSTRATEGY_GLOBAL_SHARE = "5";
    public static final String CTRLSTRATEGY_CU_SHARE = "6";
    public static final String CTRLSTRATEGY_PRIVATE = "7";
    public static final String CREATEORG = "createorg";
    private static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    private static final String ORG_ID = "org.id";
    private static final String OBJECTTYPE = "objecttype";
    private static final String ORG_CHANGE_CONFIRM = "org_change_confirm";
    private static final String FIELD_APPID = "appId";
    private static final String PROGRESS_BAR = "progressbar";
    private static final String PROGRESS_FLEX = "progressflex";
    private static final String UPPER_CREATE_ORG = "createOrg";
    private static final String CHANGE_NOTICE = "changenotice";

    public void initialize() {
        this.addClickListeners(new String[]{CTRL_SAVE, CTRL_TARGET_ORG});
        this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESS_FLEX});
        this.setTargetOrgFilter();
    }

    private void setTargetOrgFilter() {
        OrgEdit bde = (OrgEdit)this.getControl(CTRL_TARGET_ORG);
        String viewNum = (String)this.getView().getFormShowParameter().getCustomParam("viewNum");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("id", "<>", this.getView().getFormShowParameter().getCustomParam(UPPER_CREATE_ORG)));
        filters.add(new QFilter("structure.isCtrlUnit", "=", (Object)CTRLSTRATEGY_CU_ASSIGN));
        try {
            QFilter orgFilter = this.getTargetOrgQFilter();
            if (null != orgFilter) {
                filters.add(orgFilter);
            }
        }
        catch (KDBizException e) {
            logger.error("\u4e1a\u52a1\u81ea\u5b9a\u4e49\u5f02\u5e38", (Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
        catch (Exception e) {
            logger.error("OrgPermChangePlugin error :", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52a0\u8f7d\u7ec4\u7ec7\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OrgPermChangePlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        bde.setQFilters(filters);
        bde.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.getFormShowParameter().setCustomParam("orgViewSchemeNumber", (Object)viewNum));
    }

    private QFilter getTargetOrgQFilter() throws KDException {
        this.getView().setVisible(Boolean.FALSE, new String[]{CHANGE_NOTICE});
        List<Long> dataIds = this.getChangePermDataIds();
        if (CollectionUtils.isEmpty(dataIds)) {
            return null;
        }
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(OBJECTTYPE);
        Long orgId = this.getUseOrgId();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)dataIds.get(0))};
        DynamicObject obj = QueryServiceHelper.queryOne((String)entityId, (String)"id,ctrlStrategy", (QFilter[])qFilters);
        if (null == obj) {
            return null;
        }
        String ctrlStrategy = obj.getString("ctrlstrategy");
        if (CTRLSTRATEGY_CU_ASSIGN.equals(ctrlStrategy)) {
            BaseDataServiceImpl service = new BaseDataServiceImpl();
            Map paramsMap = this.getView().getFormShowParameter().getCustomParams();
            String appId = null != paramsMap.get(FIELD_APPID) ? (String)paramsMap.get(FIELD_APPID) : this.getAppId(entityId);
            AssignQueryResponse response = service.assignQueryByData(dataIds, entityId, orgId, appId);
            if (!response.isSuccess()) {
                throw new KDBizException(response.getErrorMsg());
            }
            Map assignData = response.getData();
            if (CollectionUtils.isEmpty((Map)assignData)) {
                return null;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{CHANGE_NOTICE});
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
            String viewNumber = ctrlView.getString("number");
            List targetOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)viewNumber, (long)orgId);
            List<Long> directSubOrgIds = this.getDirectSubOrg(ctrlView.getLong("id"), orgId);
            if (!CollectionUtils.isEmpty(directSubOrgIds)) {
                targetOrgIds.addAll(directSubOrgIds);
            }
            if (!CollectionUtils.isEmpty((Collection)targetOrgIds)) {
                return new QFilter("id", "in", (Object)targetOrgIds);
            }
        }
        return null;
    }

    private String getAppId(String entityId) {
        if (null != entityId) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            return null != mainEntityType ? mainEntityType.getAppId() : null;
        }
        return null;
    }

    private Long getUseOrgId() {
        Object orgIdObj = this.getView().getFormShowParameter().getCustomParam(UPPER_CREATE_ORG);
        Long orgId = orgIdObj instanceof DynamicObject ? Long.valueOf(((DynamicObject)orgIdObj).getLong("id")) : (orgIdObj instanceof Integer ? Long.valueOf(orgIdObj.toString()) : (Long)orgIdObj);
        return orgId;
    }

    private List<Long> getDirectSubOrg(Long viewId, Long orgId) {
        ArrayList<Long> directSubOrgIds = new ArrayList<Long>(10);
        ORM ormOV = ORM.create();
        QFilter[] qFilters = new QFilter[]{new QFilter("view.id", "=", (Object)viewId), new QFilter("parent.id", "=", (Object)orgId)};
        try (DataSet ds = ormOV.queryDataSet(OrgPermChangePlugin.class.getName(), ENTITYID_ORG_STRUCTURE, ORG_ID, qFilters);){
            for (Row row : ds) {
                Long directSubOrg = row.getLong(ORG_ID);
                directSubOrgIds.add(directSubOrg);
            }
        }
        return directSubOrgIds;
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("oriorg", this.getView().getFormShowParameter().getCustomParam(UPPER_CREATE_ORG));
        super.afterCreateNewData(e);
        HashSet<Long> ids = new HashSet<Long>(this.getChangePermDataIds());
        if (ids.isEmpty()) {
            return;
        }
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(OBJECTTYPE);
        List dataMutexResults = BaseDataMutexUtils.batchRequireAndReturnFailMutex((String)entityId, ids, (String)OP_MODIFY);
        if (CollectionUtils.isEmpty((Collection)dataMutexResults)) {
            this.getView().getPageCache().put(KEY_MUTEX_LOCK_RET, Boolean.TRUE.toString());
            return;
        }
        Map<String, String> numberMap = this.selectDataNumber(dataMutexResults, entityId);
        String msg = ResManager.loadKDString((String)"%1$s\uff1a%2$s", (String)"OrgPermChangePlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        if (dataMutexResults.size() == 1) {
            DataMutexResult dataMutexResult = (DataMutexResult)dataMutexResults.get(0);
            String dataId = dataMutexResult.getId();
            ids.remove(Long.valueOf(dataId));
            this.getView().showTipNotification(String.format(msg, numberMap.get(dataId), dataMutexResult.getMessage()));
        } else {
            String title = ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u88ab\u9501\u5b9a", (String)"OrgPermChangePlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            StringJoiner joiner = new StringJoiner("\r\n");
            for (DataMutexResult result : dataMutexResults) {
                String dataId = result.getId();
                joiner.add(String.format(msg, numberMap.get(dataId), result.getMessage()));
                ids.remove(Long.valueOf(dataId));
            }
            this.getView().showMessage(title, joiner.toString(), MessageTypes.Default);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{CTRL_SAVE, CTRL_TARGET_ORG});
        if (!ids.isEmpty()) {
            BaseDataMutexUtils.batchRelease((String)entityId, (String)OP_MODIFY, ids);
        }
    }

    private Map<String, String> selectDataNumber(List<DataMutexResult> dataMutexResults, String entity) {
        ArrayList dataIds = new ArrayList(dataMutexResults.size());
        dataMutexResults.forEach(mutexResult -> dataIds.add(Long.valueOf(mutexResult.getId())));
        String numberField = "number";
        if (BaseDataCommonService.isOtherMasterIdType((String)entity)) {
            numberField = "masterid.number";
        }
        HashMap<String, String> result = new HashMap<String, String>(dataIds.size());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)("id, " + numberField), (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                result.put(row.getString("id"), row.getString(numberField));
            }
        }
        return result;
    }

    private List<Long> getChangePermDataIds() {
        Object param = this.getView().getFormShowParameter().getCustomParam("ids");
        if (null == param) {
            return new ArrayList<Long>(0);
        }
        List ids = SerializationUtils.fromJsonStringToList((String)param.toString(), Long.class);
        ArrayList<Long> dataIds = new ArrayList<Long>(ids.size());
        ids.forEach(id -> dataIds.add(Long.valueOf(id.toString())));
        return dataIds;
    }

    public void pageRelease(EventObject e) {
        String lockCache = this.getView().getPageCache().get(KEY_MUTEX_LOCK_RET);
        if (Boolean.parseBoolean(lockCache)) {
            List<Long> ids = this.getChangePermDataIds();
            if (ids.isEmpty()) {
                return;
            }
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam(OBJECTTYPE);
            BaseDataMutexUtils.batchRelease((String)entityId, (String)OP_MODIFY, ids);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().toLowerCase().startsWith(CTRL_SAVE)) {
            String opName;
            Map paramsMap = this.getView().getFormShowParameter().getCustomParams();
            String appId = (String)paramsMap.get(FIELD_APPID);
            String entityNumber = (String)paramsMap.get("entitynumber");
            List<Long> ids = this.getChangePermDataIds();
            long createOrg = Long.parseLong(paramsMap.get(UPPER_CREATE_ORG).toString());
            boolean hasFuncPerm = PermissionValidatorHelper.checkFuncPerm("DIM_ORG", createOrg, appId, entityNumber, "4730fc9f000000ac", opName = ResManager.loadKDString((String)"\u7ba1\u7406\u6743\u8f6c\u8ba9", (String)"OrgPermChangePlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), this.getView());
            if (!hasFuncPerm) {
                evt.setCancel(true);
                return;
            }
            Map<String, Object> map = PermissionValidatorHelper.checkDataRule(appId, entityNumber, "4730fc9f000000ac", (Long)createOrg, opName, ids);
            List messages = (List)map.get("messages");
            if (!messages.isEmpty()) {
                FormShowParameter parameter = PermissionValidatorHelper.buildFormShowParameter(messages);
                this.getView().showForm(parameter);
                evt.setCancel(true);
                return;
            }
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if (c.getKey().toLowerCase().startsWith(CTRL_SAVE)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(CTRL_TARGET_ORG);
            if (org == null) {
                return;
            }
            List<Long> dataIds = this.getChangePermDataIds();
            if (dataIds.isEmpty()) {
                return;
            }
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam(OBJECTTYPE);
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)dataIds.get(0), (String)entityId, (String)"id,number,ctrlStrategy");
            String ctrlStrategy = obj.getString("ctrlstrategy");
            long targetOrgId = org.getLong("id");
            long useOrgId = this.getUseOrgId();
            if (CTRLSTRATEGY_CU_SHARE.equals(ctrlStrategy)) {
                DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
                String viewNumber = ctrlView.getString("number");
                List allSuperiorOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)viewNumber, (long)useOrgId);
                List directSubOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)viewNumber, Collections.singletonList(useOrgId), (boolean)false);
                String showMsg = allSuperiorOrgIds.contains(targetOrgId) ? ResManager.loadKDString((String)"\u8f6c\u8ba9\u76ee\u6807\u7ec4\u7ec7\u662f\u539f\u521b\u5efa\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8f6c\u8ba9\u540e\uff0c\u6570\u636e\u53ef\u89c1\u8303\u56f4\u53d8\u5927\uff0c\u539f\u521b\u5efa\u7ec4\u7ec7\u7684\u5e73\u7ea7\u7ec4\u7ec7\u5c06\u4f1a\u53ef\u89c1\u3002\r\n\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OrgPermChangePlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]) : (directSubOrgIds.contains(targetOrgId) ? ResManager.loadKDString((String)"\u8f6c\u8ba9\u76ee\u6807\u7ec4\u7ec7\u4e3a\u539f\u521b\u5efa\u7ec4\u7ec7\u7684\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u8f6c\u8ba9\u540e\uff0c\u6570\u636e\u53ef\u89c1\u8303\u56f4\u7f29\u5c0f\uff0c\u539f\u59cb\u521b\u5efa\u7ec4\u7ec7\u53ca\u90e8\u5206\u4e0b\u7ea7\u7ec4\u7ec7\u5c06\u4e0d\u53ef\u89c1\u6570\u636e\uff0c\u4e0d\u5f71\u54cd\u5386\u53f2\u6570\u636e\u3002", (String)"OrgPermChangePlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6c\u8ba9\u76ee\u6807\u7ec4\u7ec7\u975e\u539f\u521b\u5efa\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8f6c\u8ba9\u540e\uff0c\u539f\u59cb\u521b\u5efa\u7ec4\u7ec7\u53ca\u5176\u6240\u6709\u4e0b\u7ea7\u7ec4\u7ec7\u5c06\u4e0d\u53ef\u89c1\u6570\u636e\uff0c\u4e0d\u5f71\u54cd\u5386\u53f2\u6570\u636e\u3002", (String)"OrgPermChangePlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.getView().showConfirm(showMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ORG_CHANGE_CONFIRM, (IFormPlugin)this));
                return;
            }
            this.orgPermChange();
        }
    }

    private void orgPermChange() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(CTRL_TARGET_ORG);
        if (org == null) {
            return;
        }
        List<Long> dataIds = this.getChangePermDataIds();
        if (dataIds.isEmpty()) {
            return;
        }
        ProgressBar progressBar = this.showProgressBar();
        progressBar.setPercent(20, "20%");
        DynamicObject targetOrg = (DynamicObject)this.getModel().getValue(CTRL_TARGET_ORG);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(OBJECTTYPE);
        Long targetOrgId = targetOrg.getLong("id");
        ChangeManageRightValidator validator = new ChangeManageRightValidator(entityId);
        Map paramsMap = this.getView().getFormShowParameter().getCustomParams();
        String appId = null != paramsMap.get(FIELD_APPID) ? (String)paramsMap.get(FIELD_APPID) : this.getAppId(entityId);
        int dataIdSize = dataIds.size();
        BaseDataResponse response = validator.validateBeforeChangeManage(this.getUseOrgId(), appId, dataIds, targetOrgId);
        progressBar.setPercent(60, "60%");
        if (CollectionUtils.isEmpty(dataIds)) {
            this.showFailNotice(response, dataIdSize, dataIds.size());
            this.hireProgressBar(progressBar);
            return;
        }
        ChangeManageRightService service = new ChangeManageRightService();
        BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.INTERFACE_OP);
        BaseDataResponse changeResponse = service.changeManageRight(entityId, this.getUseOrgId(), appId, new HashSet<Long>(dataIds), Long.valueOf(targetOrg.getLong("id")), false);
        if (!changeResponse.isSuccess()) {
            String pageId = this.getView().getFormShowParameter().getParentPageId();
            if (null != this.getView().getViewNoPlugin(pageId)) {
                this.getView().getViewNoPlugin(pageId).showErrorNotification(changeResponse.getErrorMsg());
                this.getView().sendFormAction(this.getView().getViewNoPlugin(pageId));
                return;
            }
        }
        progressBar.setPercent(99, "99%");
        this.getView().returnDataToParent((Object)true);
        this.hireProgressBar(progressBar);
        this.showChangeManageNotice(dataIds, entityId, response, dataIdSize);
        this.getView().close();
    }

    private void showChangeManageNotice(List<Long> dataIds, String entityId, BaseDataResponse response, int dataIdSize) {
        Map result = response.getResult();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (!CollectionUtils.isEmpty((Map)result)) {
            String pageId = formShowParameter.getParentPageId();
            if (null != this.getView().getViewNoPlugin(pageId)) {
                this.showFailNotice(response, dataIdSize, dataIds.size());
            }
        } else {
            String pageId = formShowParameter.getParentPageId();
            if (null != this.getView().getViewNoPlugin(pageId)) {
                this.getView().getViewNoPlugin(pageId).showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"OrgPermChangePlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getViewNoPlugin(pageId));
                MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityId);
                ArrayList<BaseDataCtrlLog> bdCtrlLogs = new ArrayList<BaseDataCtrlLog>(dataIds.size());
                String opName = ResManager.loadKDString((String)"\u7ba1\u7406\u6743\u8f6c\u8ba9", (String)"OrgPermChangePlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                Long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam(UPPER_CREATE_ORG).toString());
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
                Collection values = BusinessDataServiceHelper.loadFromCache((String)entityId, (String)"number", (QFilter[])filters).values();
                for (DynamicObject value : values) {
                    String number = value.getString("number");
                    String opDescription = String.format(ResManager.loadKDString((String)"%s\uff1a\u7ba1\u7406\u6743\u8f6c\u8ba9\u6210\u529f\u3002", (String)"OrgPermChangePlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), number);
                    String appNumber = formShowParameter.getAppId();
                    BaseDataCtrlLog log = new BaseDataCtrlLog(appNumber, entity.getName(), opName, orgId, opDescription);
                    log.setMultiLangDesc(new MultiLangEnumBridge("%s\uff1a\u7ba1\u7406\u6743\u8f6c\u8ba9\u6210\u529f\u3002", "OrgPermChangePlugin_3", SYSTEM_TYPE));
                    log.setOpKey("Transfer of Management Rights");
                    log.setOpNameBridge(new MultiLangEnumBridge("\u7ba1\u7406\u6743\u8f6c\u8ba9", "OrgPermChangePlugin_7", SYSTEM_TYPE));
                    log.setArgs(new String[]{number});
                    bdCtrlLogs.add(log);
                }
                BDCtrlLogServiceHelper.saveLogBatch(bdCtrlLogs);
            }
        }
    }

    private void hireProgressBar(ProgressBar progressBar) {
        progressBar.stop();
        this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESS_FLEX});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        this.getView().setEnable(Boolean.TRUE, new String[]{CTRL_SAVE, "btnclose"});
    }

    @NotNull
    private ProgressBar showProgressBar() {
        this.getView().setVisible(Boolean.TRUE, new String[]{PROGRESS_FLEX});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        this.getView().setEnable(Boolean.FALSE, new String[]{CTRL_SAVE, "btnclose"});
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROGRESS_BAR);
        progressBar.start();
        return progressBar;
    }

    private void showFailNotice(BaseDataResponse response, int dataIdSize, int successSize) {
        String pageId = this.getView().getFormShowParameter().getParentPageId();
        if (null != this.getView().getViewNoPlugin(pageId)) {
            ArrayList errorMsgList = new ArrayList(10);
            Map resultMap = response.getResult();
            Collection errorMsgMap = resultMap.values();
            for (Map errorMap : errorMsgMap) {
                if (CollectionUtils.isEmpty((Map)errorMap)) continue;
                Collection errorList = errorMap.values();
                errorMsgList.addAll(errorList);
            }
            if (errorMsgList.size() == 1) {
                this.getView().getViewNoPlugin(pageId).showTipNotification((String)errorMsgList.get(0));
            } else {
                StringJoiner stringJoiner = new StringJoiner("\r\n");
                String title = String.format(ResManager.loadKDString((String)"\u7ba1\u7406\u6743\u8f6c\u8ba9\u6210\u529f%1$s\u5931\u8d25%2$s\u6761", (String)"OrgPermChangePlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]), successSize, dataIdSize - successSize);
                errorMsgList.forEach(stringJoiner::add);
                String detail = stringJoiner.toString();
                this.getView().getViewNoPlugin(pageId).showMessage(title, detail, MessageTypes.Default);
            }
            this.getView().sendFormAction(this.getView().getViewNoPlugin(pageId));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if (ORG_CHANGE_CONFIRM.equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.orgPermChange();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROGRESS_BAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void onProgress(ProgressEvent progressEvent) {
    }
}

