/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.service.BaseDataRepairService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.util.CollectionUtils;

public class OrgSavePlugin
extends AbstractOperationServicePlugIn {
    private static final String ADD = "add";
    private static final String UPDATE = "update";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (objs == null) {
            return;
        }
        String orgJsonStr = this.getOption().getVariableValue("becEventOperationParams", "");
        ArrayList<Long> needRefreshOrgIds = new ArrayList<Long>(objs.length);
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)orgJsonStr)) {
            JSONObject orgJsonObj = (JSONObject)JSON.parse((String)orgJsonStr);
            this.getViewParentOrgMap(orgJsonObj, ADD, needRefreshOrgIds);
            this.getViewParentOrgMap(orgJsonObj, UPDATE, needRefreshOrgIds);
        }
        if (!CollectionUtils.isEmpty(needRefreshOrgIds)) {
            BaseDataRepairService repairService = new BaseDataRepairService();
            repairService.orgSaveHandler(needRefreshOrgIds);
        }
    }

    private void getViewParentOrgMap(JSONObject params, String operation, List<Long> needRefreshOrgIds) {
        JSONObject opJson = params.getJSONObject(operation);
        if (opJson != null) {
            Set entries = opJson.entrySet();
            for (Map.Entry entry : entries) {
                long id = Long.parseLong((String)entry.getKey());
                if (operation.equals(ADD)) {
                    needRefreshOrgIds.add(id);
                    continue;
                }
                JSONObject idJson = (JSONObject)entry.getValue();
                JSONObject entityJson = idJson.getJSONObject("structure");
                if (entityJson == null) continue;
                if (null != entityJson.get((Object)ADD)) {
                    needRefreshOrgIds.add(id);
                    continue;
                }
                JSONObject proJson = entityJson.getJSONObject("property");
                if (proJson == null) continue;
                Set entrySet = proJson.entrySet();
                for (Map.Entry viewEntry : entrySet) {
                    JSONObject viewJson = (JSONObject)viewEntry.getValue();
                    this.getViewParentOrgMap(id, viewJson, needRefreshOrgIds);
                }
            }
        }
    }

    private void getViewParentOrgMap(long id, JSONObject changeProJson, List<Long> needRefreshOrgId) {
        JSONObject parentJson;
        if (changeProJson != null && (parentJson = changeProJson.getJSONObject("viewparent")) != null) {
            Object newValue = parentJson.get((Object)"newValue");
            Object oldValue = parentJson.get((Object)"oldValue");
            if (!StringUtils.isBlank((Object)newValue) && !newValue.toString().equals(oldValue.toString())) {
                needRefreshOrgId.add(id);
            }
        }
    }
}

