/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.BaseDataCustomService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;

public class TreeBaseDataSaveValidator
extends AbstractValidator {
    public static final String USEORGID = "useorgId";

    public void validate() {
        Map<Long, Long> parentCreateOrgMap = this.getParentCreateOrgMap();
        HashMap<Long, ExtendedDataEntity> parentDataMap = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dynamicObject : this.dataEntities) {
            DynamicObject baseData = dynamicObject.getDataEntity();
            boolean checkPass = true;
            if (!baseData.getDataEntityState().getFromDatabase()) {
                Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)baseData, (String)"useorg");
                checkPass = this.checkAddDatas(useOrgId, dynamicObject, parentCreateOrgMap);
            }
            Long parentId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)baseData, (String)"parent");
            if (!checkPass || parentId == 0L) continue;
            parentDataMap.put(parentId, dynamicObject);
        }
        if (parentDataMap.isEmpty()) {
            return;
        }
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)this.entityKey);
        if (baseDataCtrlPlugin == null) {
            return;
        }
        ArrayList dataIds = new ArrayList(1);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)parentDataMap.keySet().toArray()), new QFilter("isleaf", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.entityKey, (String)"id", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        collection.forEach(p -> dataIds.add(p.getLong("id")));
        Map checkResult = baseDataCtrlPlugin.checkBeforeAddSubData(this.entityKey, dataIds);
        if (checkResult != null && checkResult.size() > 0) {
            for (Map.Entry entry : checkResult.entrySet()) {
                Long pid = (Long)entry.getKey();
                String result = (String)entry.getValue();
                String errorMsg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e0a\u7ea7\u6821\u9a8c\u5931\u8d25\u3002%s", (String)"TreeBaseDataSaveValidator_0", (String)"bos-bd-formplugin", (Object[])new Object[0]), result);
                ExtendedDataEntity dynamicObject = (ExtendedDataEntity)parentDataMap.get(pid);
                this.addErrorMessage(dynamicObject, errorMsg);
            }
        }
    }

    private boolean checkAddDatas(Long useOrgId, ExtendedDataEntity dataEntity, Map<Long, Long> parentCreateOrgMap) {
        boolean isShareData;
        BaseDataCustomService service;
        Map customOrgInfo;
        DynamicObject baseData = dataEntity.getDataEntity();
        Long parentId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)baseData, (String)"parent");
        if (parentId == 0L) {
            return true;
        }
        String entity = this.getEntityKey();
        DynamicObject parent = baseData.getDynamicObject("parent");
        if (null == parent) {
            return true;
        }
        if (!(TreeBaseDataCommonService.isAssignUnDetail((String)entity) || CollectionUtils.isEmpty((Map)(customOrgInfo = (service = new BaseDataCustomService(entity)).getCustomOrgInfo(parent, useOrgId))) || BaseDataBusinessServiceUtils.isEnableVersion((String)entity))) {
            String orgName = (String)new ArrayList(customOrgInfo.values()).get(0);
            String number = parent.getString("number");
            String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5728\u7ec4\u7ec7\uff1a\u201c%2$s\u201d\u5b58\u5728\u4e0b\u7ea7\u8d44\u6599\u6216\u4e2a\u6027\u5316\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\u4e0b\u7ea7\u8d44\u6599\u3002", (String)"TreeBaseDataSaveValidator_1", (String)"bos-bd-formplugin", (Object[])new Object[0]), number, orgName);
            this.addErrorMessage(dataEntity, errorMsg);
            return false;
        }
        String strategy = parent.getString("ctrlstrategy");
        boolean bl = isShareData = "5".equals(strategy) || "6".equals(strategy);
        if (isShareData && !Objects.equals(useOrgId, parentCreateOrgMap.get(parentId))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5171\u4eab\u201d \u578b\u7b56\u7565\u4e0b\uff0c\u6240\u6709\u5c42\u7ea7\u7684\u521b\u5efa\u7ec4\u7ec7\u5fc5\u987b\u76f8\u540c\u3002", (String)"TreeBaseDataSaveValidator_2", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<Long, Long> getParentCreateOrgMap() {
        HashMap<Long, Long> dataOrgMap = new HashMap<Long, Long>(16);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject parent;
            String strategy;
            DynamicObject data = entity.getDataEntity();
            Long parentId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)data, (String)"parent");
            if (0L == parentId || !"5".equals(strategy = (parent = data.getDynamicObject("parent")).getString("ctrlstrategy")) && !"6".equals(strategy)) continue;
            dataOrgMap.put(parentId, BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)parent, (String)"createorg"));
        }
        return dataOrgMap;
    }
}

