/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.common.BaseDataCommon;
import kd.bos.bd.ctsy.utils.CtsyDBUtils;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.AssignQueryService;
import kd.bos.bd.service.AssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.plugin.bdctrl.helper.BaseDataAssignServiceHelper;
import kd.bos.form.plugin.bdctrl.helper.BaseDataCommonServiceHelper;
import kd.bos.form.plugin.bdctrl.validator.BaseDataAssignPreValidator;
import kd.bos.form.plugin.bdctrl.validator.TreeBaseDataAssignPreValidator;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.list.query.impl.CountQuery;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class UnassignQueryPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener,
SetFilterListener {
    public static final String TREEVIEW = "treeviewap";
    public static final String BASEDATAUSEREGSUFFIX = "UseReg";
    public static final String BASEDATAEXCSUFFIX = "Exc";
    public static final String ENTITYNUMBER = "entityNumber";
    public static final String BILLLISTAP = "billlistap";
    public static final String FILEDLIST = "filedList";
    public static final String SEARCHFILED = "searchfiled";
    public static final String BOS_FORM_BUSINESS = "bos-bd-formplugin";
    public static final String STATUS = "status";
    private static final String SEARCH_TEXT_KEY = "searchTextKey";
    private static final String SELECTED_NODE_KEY = "selectedNodeKey";
    private static final String BTN_ASSIGN = "btn_assign";
    private static final String TREE_BILL_LIST = "billlistap2";
    private static final String BDMATERIALINFO_BILL_LIST = "billlistap3";
    private static final String KEY_BILL_LIST_SEARCH = "searchap";
    private static final String KEY_TREE_SEARCH = "searchap_tree";
    private static final String CACHE_ALL_ORG = "cache_all_org";
    private static final String KEY_ASSIGN_ORG = "assignorg";
    private static final String CACHE_BILL_LIST_FILTER = "idFilter";

    public void initialize() {
        super.initialize();
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
        boolean isTreeType = BaseDataCommonService.isTreeType((String)entityNumber);
        boolean isMaterialInfo = BaseDataCommonService.isOtherMasterIdType((String)entityNumber);
        BillList billList = this.getBillList(entityNumber, isTreeType, isMaterialInfo);
        billList.addCreateListDataProviderListener(args -> {
            IListDataProvider provider = args.getListDataProvider();
            if (null == provider) {
                args.setListDataProvider((IListDataProvider)new ListDataProviderImpl(!isTreeType));
            }
        });
        if (isTreeType) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TREE_BILL_LIST});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BILLLISTAP});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BDMATERIALINFO_BILL_LIST});
        } else if (isMaterialInfo) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BDMATERIALINFO_BILL_LIST});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TREE_BILL_LIST});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BILLLISTAP});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BILLLISTAP});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BDMATERIALINFO_BILL_LIST});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TREE_BILL_LIST});
        }
    }

    private BillList getBillList(String entityNumber, boolean isTreeType, boolean isMaterialInfo) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.setBillFormId(entityNumber);
        BillList treeBillList = (BillList)this.getControl(TREE_BILL_LIST);
        treeBillList.setBillFormId(entityNumber);
        treeBillList.addCreateListDataProviderListener(args -> {
            IListDataProvider provider = args.getListDataProvider();
            if (null == provider) {
                args.setListDataProvider((IListDataProvider)new ListDataProviderImpl(isTreeType));
            }
        });
        BillList bdBillList = (BillList)this.getControl(BDMATERIALINFO_BILL_LIST);
        bdBillList.setBillFormId(entityNumber);
        if (isTreeType) {
            return treeBillList;
        }
        if (isMaterialInfo) {
            return bdBillList;
        }
        return billList;
    }

    private BillList getBillList() {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
        boolean isTreeType = BaseDataCommonService.isTreeType((String)entityNumber);
        boolean isMaterialInfo = BaseDataCommonService.isOtherMasterIdType((String)entityNumber);
        if (isTreeType) {
            return (BillList)this.getControl(TREE_BILL_LIST);
        }
        if (isMaterialInfo) {
            return (BillList)this.getControl(BDMATERIALINFO_BILL_LIST);
        }
        return (BillList)this.getControl(BILLLISTAP);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ASSIGN});
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
        BillList billList = this.getBillList();
        billList.addSetFilterListener((SetFilterListener)this);
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search treeSearch = (Search)this.getControl(KEY_TREE_SEARCH);
        treeSearch.addEnterListener((SearchEnterListener)this);
        OrgEdit orgEdit = (OrgEdit)this.getControl(KEY_ASSIGN_ORG);
        orgEdit.addBeforeF7SelectListener(event -> {
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityNumber);
            if (null == ctrlView) {
                event.addCustomQFilter(new QFilter("id", "in", Collections.emptyList()));
            } else {
                HasPermOrgResult result;
                Object param;
                parameter.setCustomParam("orgViewSchemeNumber", (Object)ctrlView.getString("number"));
                parameter.setCustomParam("orgFuncId", (Object)ctrlView.getString("treetype"));
                ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
                if (null == listFilterParameter) {
                    listFilterParameter = new ListFilterParameter();
                    parameter.setListFilterParameter(listFilterParameter);
                }
                if (null != (param = this.getView().getFormShowParameter().getCustomParam("viewOrgFilter"))) {
                    listFilterParameter.setFilter(QFilter.fromSerializedString((String)param.toString()));
                }
                long userId = RequestContext.get().getCurrUserId();
                MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityNumber);
                String appNumber = this.getView().getFormShowParameter().getAppId();
                String appId = null;
                if (!StringUtils.isBlank((CharSequence)appNumber)) {
                    try {
                        appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
                    }
                    catch (Exception ex) {
                        appId = met.getAppId();
                    }
                }
                if ((result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityNumber, (String)"80513208000000ac")) == null) {
                    listFilterParameter.setFilter(new QFilter("org", "=", (Object)-1));
                } else {
                    ArrayList<QFilter> filters = new ArrayList<QFilter>();
                    if (!result.hasAllOrgPerm()) {
                        filters.add(new QFilter("id", "in", (Object)result.getHasPermOrgs()));
                    }
                    filters.add(new QFilter("structure.isctrlunit", "=", (Object)Boolean.TRUE));
                    listFilterParameter.setQFilters(filters);
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityNumber = (String)parameter.getCustomParam(ENTITYNUMBER);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityNumber);
        if (null == ctrlView) {
            return;
        }
        Long useOrgId = Long.valueOf(Objects.toString(parameter.getCustomParam("useOrgId"), "0"));
        this.getModel().setValue(KEY_ASSIGN_ORG, (Object)useOrgId);
        this.initOrgTree((Long)ctrlView.getPkValue());
        this.refresh(false);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        Search search = (Search)searchEnterEvent.getSource();
        if (KEY_BILL_LIST_SEARCH.equals(search.getKey())) {
            List searchFields = searchEnterEvent.getSearchFields();
            if (searchFields != null) {
                List filedList = (List)((Map)searchFields.get(0)).get("fieldName");
                List text = (List)((Map)searchFields.get(0)).get("value");
                String fileStr = SerializationUtils.toJsonString((Object)filedList);
                String value = SerializationUtils.toJsonString((Object)text);
                this.getPageCache().put(FILEDLIST, fileStr);
                this.getPageCache().put(SEARCHFILED, value);
            } else {
                this.getPageCache().put(FILEDLIST, null);
                this.getPageCache().put(SEARCHFILED, null);
            }
            this.refresh(true);
        } else if (KEY_TREE_SEARCH.equals(search.getKey())) {
            String searchText = searchEnterEvent.getText();
            if (StringUtils.isBlank((CharSequence)searchText)) {
                this.getPageCache().remove(SEARCH_TEXT_KEY);
                this.getPageCache().remove(SELECTED_NODE_KEY);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u67e5\u8be2\u5173\u952e\u5b57\u3002", (String)"UnassignTreeQueryPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            } else {
                this.refreshBySearchOrg(searchText);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        this.queryData(String.valueOf(nodeId), true);
    }

    public void setFilter(SetFilterEvent e) {
        String idFilterStr = this.getPageCache().get(CACHE_BILL_LIST_FILTER);
        QFilter idFilter = QFilter.fromSerializedString((String)idFilterStr);
        e.getCustomQFilters().clear();
        e.getCustomQFilters().add(idFilter);
        super.setFilter(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        if (KEY_ASSIGN_ORG.equals(property.getName())) {
            this.refresh(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (BTN_ASSIGN.equals(control.getKey())) {
            this.executeAssign();
        }
    }

    private void executeAssign() {
        String appId;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entity = (String)parameter.getCustomParam(ENTITYNUMBER);
        if (CtsyDBUtils.ctsyBaseDataUseOnly((String)entity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u542f\u4e86\u8de8\u79df\u6237\u4e3b\u6570\u636e\u57df\u7ba1\u63a7\uff0c\u5f53\u524d\u64cd\u4f5c\u4e0d\u652f\u6301\uff0c\u8bf7\u5230\u96c6\u56e2\u79df\u6237\u6267\u884c\u3002", (String)"UnassignQueryPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        boolean isTreeType = BaseDataCommonService.isTreeType((String)entity);
        BillList billList = this.getBillList();
        ListSelectedRowCollection selectRows = billList.getSelectedRows();
        if (selectRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6570\u636e\u3002", (String)"UnassignQueryPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        HashMap<Long, String> idNumMap = new HashMap<Long, String>(selectRows.size());
        for (ListSelectedRow row : selectRows) {
            idNumMap.put(Long.valueOf(String.valueOf(row.getPrimaryKeyValue())), row.getNumber());
        }
        List<Long> dataIds = new ArrayList<Long>(idNumMap.keySet());
        Object value = this.getModel().getValue(KEY_ASSIGN_ORG);
        if (Objects.isNull(value)) {
            return;
        }
        Long useOrgId = value instanceof DynamicObject ? (Long)((DynamicObject)value).getPkValue() : Long.valueOf(value.toString());
        BaseDataAssignPreValidator validator = isTreeType ? new TreeBaseDataAssignPreValidator(this.getView(), entity, "assign", useOrgId) : new BaseDataAssignPreValidator(this.getView(), entity, "assign");
        if (!validator.validateDataWithSpecificOpType(appId = (String)parameter.getCustomParam("appId"), useOrgId, dataIds)) {
            return;
        }
        if (isTreeType) {
            dataIds = this.fillAllSupDataNode(entity, dataIds, useOrgId);
        }
        String strategy = validator.getAssignQueryCtrlStrategy();
        List<Long> orgIds = this.getReceiveDataOrgIds(entity, strategy, useOrgId);
        BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.INTERFACE_OP);
        AssignService assignService = new AssignService(entity, false);
        BaseDataResponse response = assignService.assign(useOrgId, appId, new HashSet<Long>(dataIds), new HashSet<Long>(orgIds), false);
        if (response.isSuccess() && CollectionUtils.isEmpty((Map)response.getResult())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"UnassignQueryPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        } else {
            Map checkAssignRes = response.getResult();
            BaseDataAssignServiceHelper.noticeAfterAssignError(checkAssignRes, idNumMap, this.getView());
        }
        this.refresh(true);
    }

    private List<Long> fillAllSupDataNode(String entity, List<Long> dataIds, Long useOrgId) {
        TreeBaseDataCommonService service = new TreeBaseDataCommonService(entity);
        if (TreeBaseDataCommonService.isAssignUnDetail((String)entity)) {
            List<Object> integrityNodeIds = service.getIntegrityNodeIds(new HashSet<Long>(dataIds), useOrgId);
            return integrityNodeIds.isEmpty() ? dataIds : integrityNodeIds;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entity, (String)"id, number, longnumber, isleaf", (QFilter[])filters);
        ArrayList<DynamicObject> leafNodes = new ArrayList<DynamicObject>(collection.size());
        for (DynamicObject data : collection) {
            if (!data.getBoolean("isleaf")) continue;
            leafNodes.add(data);
        }
        Map treeIdsMap = service.getAllTreeNode(leafNodes, useOrgId);
        return treeIdsMap.isEmpty() ? dataIds : new ArrayList(treeIdsMap.keySet());
    }

    private List<Long> getReceiveDataOrgIds(String entity, String strategy, Long assignOrgId) {
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        List selectOrgIds = treeView.getTreeState().getSelectedNodeId();
        Long selectOrgId = Long.valueOf((String)selectOrgIds.get(0));
        if ("2".equals(strategy)) {
            return new ArrayList<Long>(Collections.singletonList(selectOrgId));
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        List supperOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)ctrlView.getString("number"), (long)selectOrgId);
        if (CollectionUtils.isEmpty((Collection)supperOrgIds)) {
            return new ArrayList<Long>(Collections.singletonList(selectOrgId));
        }
        int index = supperOrgIds.indexOf(assignOrgId) + 1;
        ArrayList<Long> orgIds = new ArrayList<Long>(supperOrgIds.subList(index, supperOrgIds.size()));
        orgIds.add(selectOrgId);
        return orgIds;
    }

    private void initOrgNode(OrgTreeParam param, TreeNode rootNode, Long viewId) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid from t_org_structure where fisctrlunit = '1' and fviewid = ?;", new Object[]{viewId});
        Set cuOrgIds = (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, rs -> {
            HashSet<String> result = new HashSet<String>(16);
            while (rs.next()) {
                result.add(rs.getString("forgid"));
            }
            return result;
        });
        param.setId(Long.parseLong(rootNode.getId()));
        List children = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        this.removeUnCuOrgNode(children, cuOrgIds);
        if (CollectionUtils.isEmpty((Collection)children)) {
            rootNode.setChildren(null);
        } else {
            rootNode.addChildren(children);
        }
        this.getView().getPageCache().putBigObject(CACHE_ALL_ORG, SerializationUtils.toJsonString((Object)rootNode));
    }

    private void removeUnCuOrgNode(List<TreeNode> nodes, Set<String> cuOrgIds) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        Iterator<TreeNode> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            TreeNode node = iterator.next();
            if (!cuOrgIds.contains(node.getId())) {
                iterator.remove();
                continue;
            }
            this.removeUnCuOrgNode(node.getChildren(), cuOrgIds);
            if (!CollectionUtils.isEmpty((Collection)node.getChildren())) continue;
            node.setChildren(null);
        }
    }

    private void refreshBySearchOrg(String searchText) {
        String orgString = this.getPageCache().getBigObject(CACHE_ALL_ORG);
        if (StringUtils.isBlank((CharSequence)orgString)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"UnassignTreeQueryPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)orgString, TreeNode.class);
        List treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, BaseDataCommon.BATCH_MAX.intValue());
        if (CollectionUtils.isEmpty((Collection)treeNodes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"UnassignTreeQueryPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        String oldSearchText = this.getPageCache().get(SEARCH_TEXT_KEY);
        if (!searchText.equals(oldSearchText)) {
            TreeNode focusNode = (TreeNode)treeNodes.get(0);
            treeView.expand(focusNode.getParentid());
            String nodeId = focusNode.getId();
            treeView.showNode(nodeId);
            treeView.focusNode(focusNode);
            this.getPageCache().put(SEARCH_TEXT_KEY, searchText);
            this.getPageCache().put(SELECTED_NODE_KEY, nodeId);
            this.queryData(nodeId, true);
            return;
        }
        String lastSelectedNodeId = this.getPageCache().get(SELECTED_NODE_KEY);
        for (int i = 0; i < treeNodes.size(); ++i) {
            TreeNode node = (TreeNode)treeNodes.get(i);
            String nodeId = node.getId();
            if (!nodeId.equals(lastSelectedNodeId)) continue;
            int index = i + 1 >= treeNodes.size() ? 0 : i + 1;
            TreeNode focusNode = (TreeNode)treeNodes.get(index);
            String focusNodeId = focusNode.getId();
            treeView.expand(focusNodeId);
            treeView.showNode(focusNodeId);
            treeView.focusNode(focusNode);
            this.getPageCache().put(SELECTED_NODE_KEY, focusNodeId);
            this.queryData(focusNodeId, true);
            return;
        }
    }

    private void refresh(boolean needRefresh) {
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        List orgIds = treeView.getTreeState().getSelectedNodeId();
        if (!orgIds.isEmpty()) {
            this.queryData((String)orgIds.get(0), needRefresh);
        } else {
            BillList billList = this.getBillList();
            billList.clearSelection();
            billList.clearEntryState();
            billList.clearData();
        }
    }

    private void queryData(String selectedOrg, boolean needRefresh) {
        QFilter filter;
        BillList billList = this.getBillList();
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
        Object value = this.getModel().getValue(KEY_ASSIGN_ORG);
        if (Objects.isNull(value)) {
            billList.clearSelection();
            billList.clearEntryState();
            billList.clearData();
            this.getPageCache().put(CACHE_BILL_LIST_FILTER, new QFilter("id", "in", Collections.emptyList()).toSerializedString());
            if (needRefresh) {
                billList.refresh();
            }
            return;
        }
        String useOrgId = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue().toString() : value.toString();
        this.getView().setVisible(Boolean.valueOf(!selectedOrg.equals(useOrgId)), new String[]{BTN_ASSIGN});
        if (BaseDataCommonService.isNewModel((String)entityNumber)) {
            AssignQueryService service = new AssignQueryService(entityNumber);
            filter = service.queryUnAssignDataFilter(Long.valueOf(selectedOrg), Long.valueOf(useOrgId));
        } else {
            filter = this.getBillListFilterOnOldModel(selectedOrg, entityNumber, useOrgId);
        }
        filter = this.packSearchFilter(filter, entityNumber);
        this.getPageCache().put(CACHE_BILL_LIST_FILTER, filter.toSerializedString());
        billList.clearSelection();
        if (needRefresh) {
            billList.refresh();
        } else {
            billList.getFilterParameter().getQFilters().clear();
            billList.getFilterParameter().getQFilters().add(filter);
        }
    }

    private QFilter getBillListFilterOnOldModel(String selectedOrg, String entityNumber, String useOrgId) {
        boolean isIgnoreStatus;
        if (selectedOrg.equals(useOrgId)) {
            return new QFilter("id", "in", Collections.emptyList());
        }
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        Long assignOrgId = Long.valueOf(useOrgId);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityNumber);
        List superOrgList = OrgUnitServiceHelper.getAllSuperiorOrgs((String)ctrlView.getString("number"), (long)Long.parseLong(selectedOrg));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        String billStatusKey = dt.getBillStatus();
        boolean bl = isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
        if (!isIgnoreStatus) {
            filters.add(new QFilter(billStatusKey, "=", (Object)BillStatus.C.name()));
        }
        if (superOrgList.contains(assignOrgId)) {
            filters.add(this.getGraduallyFilter(entityNumber, dt, superOrgList, assignOrgId, Long.valueOf(selectedOrg)));
        } else {
            String masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entityNumber);
            filters.add(new QFilter("ctrlstrategy", "=", (Object)"2"));
            filters.add(new QFilter("createorg", "=", (Object)assignOrgId));
            filters.add(QFilter.sqlExpress((String)"id", (String)"=", (String)masterIdFieldName));
            filters.add(QFilter.sqlExpress((String)"id", (String)"not in", (String)("(select fdataid from " + dt.getAlias() + "usereg where fuseorgid = " + selectedOrg + ")")));
        }
        QFilter filter = (QFilter)filters.get(0);
        for (int i = 1; i < filters.size(); ++i) {
            filter = filter.and((QFilter)filters.get(i));
        }
        return filter;
    }

    private QFilter getGraduallyFilter(String entity, BillEntityType dt, List<Long> supperOrgIds, Long assignOrgId, Long selectOrgId) {
        HashSet<Long> assignOrgDataIs = new HashSet<Long>(16);
        HashSet<Long> selectOrgDataIds = new HashSet<Long>(16);
        String masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entity);
        DBRoute route = DBRoute.of((String)dt.getDBRouteKey());
        String tableName = dt.getAlias() + "_U";
        SqlBuilder builder = new SqlBuilder();
        builder.append("select u.fdataid id, u.fuseorgid orgId from", new Object[0]).append(tableName, new Object[0]).append(" u join ", new Object[0]).append(dt.getAlias(), new Object[0]).append("t on t.fid = u.fdataid where t.fctrlstrategy in ('1', '2') and", new Object[0]).appendIn("u.fuseorgid", Arrays.asList(assignOrgId, selectOrgId)).append("and not exists (select tx.fid from", new Object[0]).append(dt.getAlias(), new Object[0]).append(" tx where tx.fid != tx.", new Object[0]).append(masterIdFieldName, new Object[0]).append(" and tx.fctrlstrategy = '2' and t.fid = tx.fid", new Object[0]).append("and tx.fcreateorgid = ?)", new Object[]{assignOrgId});
        try (DataSet ds = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)route, (SqlBuilder)builder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                if (assignOrgId.equals(row.getLong("orgId"))) {
                    assignOrgDataIs.add(row.getLong("id"));
                    continue;
                }
                selectOrgDataIds.add(row.getLong("id"));
            }
        }
        assignOrgDataIs.removeIf(selectOrgDataIds::contains);
        if (assignOrgDataIs.isEmpty()) {
            return new QFilter("id", "in", assignOrgDataIs);
        }
        builder = new SqlBuilder();
        builder.append("select fid from", new Object[0]).append(dt.getAlias(), new Object[0]).append("where fctrlstrategy = '2' and fid = ", new Object[0]).append(masterIdFieldName, new Object[0]).append("and fcreateorgid != ?;", new Object[]{assignOrgId});
        List freeList = (List)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
            ArrayList<Long> dataIs = new ArrayList<Long>(10);
            while (rs.next()) {
                dataIs.add(rs.getLong("fid"));
            }
            return dataIs;
        });
        assignOrgDataIs.removeAll(freeList);
        if (assignOrgDataIs.isEmpty() || selectOrgDataIds.isEmpty()) {
            return new QFilter("id", "in", assignOrgDataIs);
        }
        HashSet<Long> orgIds = new HashSet<Long>(supperOrgIds);
        orgIds.add(selectOrgId);
        builder = new SqlBuilder();
        builder.append("select fid, ", new Object[0]).append(masterIdFieldName, new Object[0]).append("from", new Object[0]).append(dt.getAlias(), new Object[0]).append("where ", new Object[0]);
        builder.appendIn("fcreateorgid", orgIds.toArray()).append("and", new Object[0]);
        builder.appendIn("fctrlstrategy", new Object[]{"1", "2"});
        builder.append("and fid !=", new Object[0]).append(masterIdFieldName, new Object[0]);
        Map mid2IdMap = (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
            HashMap<Long, Set> result = new HashMap<Long, Set>(16);
            while (rs.next()) {
                result.computeIfAbsent(rs.getLong(masterIdFieldName), k -> new HashSet(16)).add(rs.getLong("fid"));
            }
            return result;
        });
        block10: for (Map.Entry entry : mid2IdMap.entrySet()) {
            Set dataIds = (Set)entry.getValue();
            for (Long dataId : dataIds) {
                if (!selectOrgDataIds.contains(dataId)) continue;
                assignOrgDataIs.removeAll(dataIds);
                assignOrgDataIs.remove(entry.getKey());
                continue block10;
            }
        }
        return new QFilter("id", "in", assignOrgDataIs);
    }

    private QFilter packSearchFilter(QFilter idFilter, String entity) {
        String filedListStr = this.getPageCache().get(FILEDLIST);
        String filedValue = this.getPageCache().get(SEARCHFILED);
        if (StringUtils.isNotBlank((CharSequence)filedListStr) && StringUtils.isNotBlank((CharSequence)filedValue)) {
            List filedList = (List)SerializationUtils.fromJsonString((String)filedListStr, List.class);
            List values = (List)SerializationUtils.fromJsonString((String)filedValue, List.class);
            if (CollectionUtils.isEmpty((Collection)filedList) || CollectionUtils.isEmpty((Collection)values)) {
                return idFilter;
            }
            boolean isMaterialInfo = BaseDataCommonServiceHelper.isMaterialInfo(entity);
            QFilter orFilter = null;
            String field = isMaterialInfo ? String.format("masterid.%s", filedList.get(0)) : (String)filedList.get(0);
            for (String value : values) {
                if (orFilter == null) {
                    orFilter = new QFilter(field, "like", (Object)("%" + value + "%"));
                    continue;
                }
                orFilter = orFilter.or(new QFilter(field, "like", (Object)("%" + value + "%")));
            }
            for (int i = 1; i < filedList.size(); ++i) {
                field = isMaterialInfo ? String.format("masterid.%s", filedList.get(i)) : (String)filedList.get(i);
                for (String value : values) {
                    if (orFilter == null) {
                        orFilter = new QFilter(field, "like", (Object)("%" + value + "%"));
                        continue;
                    }
                    orFilter = orFilter.or(new QFilter(field, "like", (Object)("%" + value + "%")));
                }
            }
            idFilter = idFilter.and(orFilter);
        }
        return idFilter;
    }

    private void initOrgTree(Long orgViewId) {
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        OrgTreeParam param = new OrgTreeParam();
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        param.setOrgViewId(orgViewId.longValue());
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (rootNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u5355\u5143\u6839\u7ec4\u7ec7\u5931\u8d25\u3002", (String)"UnassignQueryPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
        this.initOrgNode(param, rootNode, orgViewId);
        treeView.addNode(rootNode);
        treeView.focusNode(rootNode);
    }

    private static final class ListDataProviderImpl
    extends ListDataProvider {
        private boolean needLoad;

        private ListDataProviderImpl(boolean needLoad) {
            this.needLoad = needLoad;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            if (!this.needLoad) {
                return new DynamicObjectCollection(this.getQueryBuilder().getReturnEntityType(), null);
            }
            DynamicObjectCollection collection = super.getData(start, limit);
            QueryResult queryResult = this.getQueryResult();
            queryResult.setDataCount(collection.size());
            queryResult.setCollection(collection);
            return collection;
        }

        public int getRealCount() {
            return this.needLoad ? CountQuery.getCount((QueryBuilder)this.getQueryBuilder()) : 0;
        }
    }
}

