/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class BaseDataAssignServiceHelper {
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String BOS_BD_FORMPLUGIN = "bos-bd-formplugin";

    public static List<TreeNode> getAllOrg(DynamicObject ctrlView) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(String.valueOf(ctrlView.get("number")));
        param.setOrgViewId(ctrlView.getLong("id"));
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (null == rootNode) {
            return Collections.emptyList();
        }
        param.setId(Long.parseLong(rootNode.getId()));
        List allChildOrgNodeList = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid from t_org_structure where fisctrlunit = '1' and fviewid = ?;", new Object[]{ctrlView.getPkValue()});
        Set allCtrlUintOrgIds = (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, rs -> {
            HashSet<String> result = new HashSet<String>(16);
            while (rs.next()) {
                result.add(rs.getString("forgid"));
            }
            return result;
        });
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        ArrayList<TreeNode> rootNodeChildList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        if (allCtrlUintOrgIds.contains(rootNode.getId())) {
            rootNode.setChildren(rootNodeChildList);
            nodeList.add(rootNode);
        }
        if (CollectionUtils.isEmpty((Collection)allChildOrgNodeList)) {
            return nodeList;
        }
        ArrayList<TreeNode> cuOrgChildNodeList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        for (TreeNode node : allChildOrgNodeList) {
            if (!allCtrlUintOrgIds.contains(node.getId())) continue;
            List children = node.getChildren();
            if (!CollectionUtils.isEmpty((Collection)children)) {
                ArrayList<TreeNode> tempChildOrgList = new ArrayList<TreeNode>(children.size());
                for (TreeNode childrenNode : children) {
                    if (!allCtrlUintOrgIds.contains(childrenNode.getId())) continue;
                    tempChildOrgList.add(childrenNode);
                }
                if (tempChildOrgList.size() > 0) {
                    node.setChildren(tempChildOrgList);
                } else {
                    node.setChildren(null);
                }
            }
            if (node.getParentid().equals(rootNode.getId())) {
                rootNodeChildList.add(node);
            }
            nodeList.add(node);
            cuOrgChildNodeList.add(node);
        }
        BaseDataAssignServiceHelper.getChildNode(cuOrgChildNodeList, nodeList, allCtrlUintOrgIds);
        return nodeList;
    }

    private static void getChildNode(List<TreeNode> orgChildrenTreeData, List<TreeNode> allOrgs, Set<String> allCtrlUintOrgIds) {
        for (TreeNode node : orgChildrenTreeData) {
            List childNodes = node.getChildren();
            if (CollectionUtils.isEmpty((Collection)childNodes)) continue;
            ArrayList<TreeNode> tempChildOrgs = new ArrayList<TreeNode>(childNodes.size());
            for (TreeNode childrenNode : childNodes) {
                if (!allCtrlUintOrgIds.contains(childrenNode.getId())) continue;
                allOrgs.add(childrenNode);
                tempChildOrgs.add(childrenNode);
            }
            if (tempChildOrgs.size() > 0) {
                node.setChildren(tempChildOrgs);
            } else {
                node.setChildren(null);
            }
            BaseDataAssignServiceHelper.getChildNode(childNodes, allOrgs, allCtrlUintOrgIds);
        }
    }

    public static void noticeAfterAssignError(Map<Long, Map<Long, String>> checkAssignRes, Map<Long, String> numIDMap, IFormView view) {
        StringBuilder sbd = new StringBuilder();
        StringBuilder sbdErrorMsg = new StringBuilder();
        String entityNumber = (String)view.getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        HashMap orgsMap = new HashMap(16);
        if (CollectionUtils.isEmpty(checkAssignRes)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25", (String)"BaseDataAssignServiceHelper_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        HashMap baseDatasMap = new HashMap(checkAssignRes.size());
        IDataEntityType dataEntityType = ORM.create().getDataEntityType(entityNumber);
        String extendName = dataEntityType.getDisplayName().toString();
        QFilter baseDataFilter = new QFilter("id", "in", checkAssignRes.keySet());
        QFilter[] baseDataFilters = new QFilter[]{baseDataFilter};
        baseDatasMap.putAll(BusinessDataServiceHelper.loadFromCache((String)entityNumber, (QFilter[])baseDataFilters));
        for (Map.Entry<Long, Map<Long, String>> entry : checkAssignRes.entrySet()) {
            Map<Long, String> tempMap = entry.getValue();
            Long key = entry.getKey();
            QFilter filter = new QFilter("id", "in", tempMap.keySet());
            QFilter[] filters = new QFilter[]{filter};
            orgsMap.putAll(BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])filters));
            String baseDataNumber = null == baseDatasMap.get(key) ? "" : ((DynamicObject)baseDatasMap.get(key)).get("number").toString();
            for (Map.Entry<Long, String> tempEntry : tempMap.entrySet()) {
                Long orgKey = tempEntry.getKey();
                String errorMsg = tempEntry.getValue();
                String orgName = null == orgsMap.get(orgKey) ? "" : ((DynamicObject)orgsMap.get(orgKey)).getString("name");
                String msg = String.format(ResManager.loadKDString((String)"%1$s(\u7f16\u7801%2$s)\u5206\u914d(%3$s)\u5931\u8d25\uff1a%4$s\n", (String)"BaseDataAssignServiceHelper_0", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), extendName, baseDataNumber, orgName, errorMsg);
                sbd.append(msg);
                sbdErrorMsg.append(errorMsg);
            }
        }
        String errorMsg = sbdErrorMsg.toString();
        if (StringUtils.isEmpty((CharSequence)errorMsg)) {
            long firstData = checkAssignRes.keySet().iterator().next();
            view.showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u7b49%2$s\u6761\u6570\u636e\u5206\u914d\u5931\u8d25\u3002", (String)"BaseDataAssignServiceHelper_2", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), numIDMap.get(firstData), checkAssignRes.size()));
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25", (String)"BaseDataAssignServiceHelper_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), sbd.toString(), MessageTypes.Default);
        }
    }

    public static TreeNode getTreeNode(String checkedNodeId, List<TreeNode> nodeList) {
        for (TreeNode node : nodeList) {
            String nodeId = node.getId();
            if (!checkedNodeId.equals(nodeId)) continue;
            return node;
        }
        return null;
    }

    public static void getChildrenNodeList(TreeNode node, List<TreeNode> list) {
        List children = node.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        list.addAll(children);
        children.forEach(child -> BaseDataAssignServiceHelper.getChildrenNodeList(child, list));
    }
}

