/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl.helper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BaseDataCommonServiceHelper {
    private static Log logger = LogFactory.getLog(BaseDataCommonServiceHelper.class);
    private static final String ISCTRLUNIT = "1";
    private static final String PRO_CREATEORG = "createOrg";
    private static final String CREATEORG = "createorg";
    private static final String MASTERID = "masterid";
    private static final String BASEDATAUSERANGESUFFIX = "_U";
    private static final String SEARCHNODEKEY = "searchNodeKey";

    public static boolean checkIsMaterialInfo(DynamicObject data) {
        return BaseDataCommonService.checkIsMaterialInfo((DynamicObject)data);
    }

    public static boolean isMaterialInfo(String entity) {
        return BaseDataCommonService.isOtherMasterIdType((String)entity);
    }

    public static boolean havePersonaliedData(DynamicObject saveObj, String useOrgID) {
        String entity = saveObj.getDataEntityType().getName();
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        Long masterID = 0L;
        if (saveObj.get(masteridPropName) instanceof Long) {
            masterID = (Long)saveObj.get(masteridPropName);
        } else if (saveObj.get(masteridPropName) instanceof DynamicObject) {
            masterID = (Long)((DynamicObject)saveObj.get(masteridPropName)).getPkValue();
        }
        QFilter[] filters = new QFilter[2];
        filters[0] = new QFilter(CREATEORG, "=", (Object)Long.valueOf(useOrgID));
        ORM orm = ORM.create();
        filters[1] = new QFilter(masteridPropName, "=", (Object)masterID);
        DynamicObjectCollection doc = orm.query(entity, "id, " + masteridPropName, filters);
        for (DynamicObject obj : doc) {
            boolean notSaveData;
            Object masterid = obj.get(masteridPropName);
            Object dataId = obj.get("id");
            boolean bl = notSaveData = !saveObj.get("id").equals(dataId);
            if (null == masterid || masterid.equals(dataId) || !notSaveData) continue;
            return true;
        }
        return false;
    }

    public static Set<Object> havePersonaliedData(Map<Object, DynamicObject> saveObjs, Long useOrgID, String entityKey) {
        HashSet<Object> result = new HashSet<Object>(saveObjs.size());
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityKey);
        List masterIds = saveObjs.values().stream().map(obj -> BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)masterIdPropName)).collect(Collectors.toList());
        String selectFields = "id," + masterIdPropName;
        QFilter filter1 = new QFilter(CREATEORG, "=", (Object)useOrgID);
        QFilter filter2 = new QFilter(masterIdPropName, "in", masterIds);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{filter1, filter2});
        for (DynamicObject obj2 : doc) {
            boolean notSaveData;
            Object masterid = obj2.get(masterIdPropName);
            Object dataId = obj2.get("id");
            boolean bl = notSaveData = !saveObjs.containsKey(dataId);
            if (null == masterid || masterid.equals(dataId) || !notSaveData) continue;
            result.add(dataId);
        }
        return result;
    }

    public static TreeNode queryNodeByOrgId(Long currentOrgId, String entityNumber) {
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityNumber);
        Long ctrlViewId = (Long)ctrlview.getPkValue();
        Object[] params = new SqlParameter[3];
        String sql = "SELECT o.fid,o.fname,t.fparentid from t_org_structure t inner join T_ORG_ORG o on t.forgid=o.fid where t.fviewid = ?  and t.fisctrlunit = ? and o.fid = ?";
        params[0] = new SqlParameter(":fviewid", 12, (Object)ctrlViewId);
        params[1] = new SqlParameter(":fisctrlunit", 12, (Object)ISCTRLUNIT);
        params[2] = new SqlParameter(":fid", 12, (Object)currentOrgId);
        TreeNode treeNode = (TreeNode)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<TreeNode>(){

            public TreeNode handle(ResultSet rs) throws Exception {
                TreeNode treeNode = null;
                while (rs.next()) {
                    String id = rs.getString(1);
                    String name = rs.getString(2);
                    String parentid = rs.getString(3);
                    treeNode = new TreeNode(parentid, id, name);
                }
                return treeNode;
            }
        });
        return treeNode;
    }

    public static boolean checkCreateOrgIsCurrentOrg(List<Long> ids, String entity, IPageCache pageCache) {
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        String selectFields = "id, createOrg," + masteridPropName + ",number";
        QFilter[] qfArr = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject[] dyCol = BusinessDataServiceHelper.load((String)entity, (String)selectFields, (QFilter[])qfArr);
        long useOrgId = Long.parseLong(pageCache.get(PRO_CREATEORG));
        for (int i = 0; i < dyCol.length; ++i) {
            Long createorg = 0L;
            if (dyCol[0].get(CREATEORG) instanceof DynamicObject) {
                createorg = (Long)dyCol[i].getDynamicObject(CREATEORG).getPkValue();
            } else if (dyCol[0].get(CREATEORG) instanceof Long) {
                createorg = (Long)dyCol[i].get(CREATEORG);
            }
            if (createorg == useOrgId) continue;
            return false;
        }
        return true;
    }

    public static String getAppId(String entity, IFormView view) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entity);
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        return appid;
    }

    public static Map<String, String> getMaterialInfoNameNumber(String dataTableName, Set<Object> dataIds, DynamicObject data) {
        Map<String, String> nameMap = new HashMap<String, String>(16);
        Map nameCNMap = new HashMap(16);
        String lang = RequestContext.get().getLang().getLocale().getLanguage() + "_" + RequestContext.get().getLang().getLocale().getCountry();
        String originalDataTableName = null;
        originalDataTableName = null != data.getDynamicObject(MASTERID) ? data.getDynamicObject(MASTERID).getDataEntityType().getAlias() : "t_bd_material";
        String dataTableLName = originalDataTableName + "_l";
        if (dataIds.size() > 0) {
            StringBuilder orgIdsSet = new StringBuilder();
            for (Object orgid : dataIds) {
                if (orgIdsSet.length() > 0) {
                    orgIdsSet.append(',');
                }
                orgIdsSet.append(orgid);
            }
            String orgNameSql = "select fid,fname from " + dataTableLName + " where flocaleid = '" + lang + "' and fid in (" + orgIdsSet + ")";
            nameMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)orgNameSql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    String orgId = null;
                    String name = null;
                    while (rs.next()) {
                        orgId = rs.getString("fid");
                        name = rs.getString("fname");
                        map.put(orgId, name);
                    }
                    return map;
                }
            });
            if (lang.equals("en_US")) {
                orgNameSql = "select fid, fname from " + dataTableLName + " where flocaleid = 'zh_CN' and fid in (" + orgIdsSet + ")";
                nameCNMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)orgNameSql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                    public Map<String, String> handle(ResultSet rs) throws SQLException {
                        HashMap<String, String> map = new HashMap<String, String>(16);
                        String orgId = null;
                        String name = null;
                        while (rs.next()) {
                            orgId = rs.getString("fid");
                            name = rs.getString("fname");
                            map.put(orgId, name);
                        }
                        return map;
                    }
                });
                for (Map.Entry<String, String> entry : nameMap.entrySet()) {
                    String dataid = entry.getKey();
                    String name = entry.getValue();
                    if (null != name) continue;
                    nameMap.put(dataid, (String)nameCNMap.get(dataid));
                }
            }
        }
        return nameMap;
    }

    public static void deleteBaseDataUseRange(String objectType, List<Long> dataIDs) {
        try {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)objectType);
            String baseDataTableName = dt.getAlias();
            DBRoute dbRoute = null;
            String dbRouteKey = dt.getDBRouteKey();
            dbRoute = DBRoute.of((String)dbRouteKey);
            String bsaeDataUseRangeTableName = baseDataTableName + BASEDATAUSERANGESUFFIX;
            String deleteUseRangeSql = "delete from " + bsaeDataUseRangeTableName + " where fdataid = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(dataIDs.size());
            Object[] params = null;
            for (Long dataId : dataIDs) {
                params = new Object[]{dataId};
                paramsList.add(params);
            }
            DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeSql, paramsList);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static List<TreeNode> getTreeNodeFromCache(IFormView view) {
        String searchNodesStr = view.getPageCache().get(view.getPageId() + SEARCHNODEKEY);
        List searchNodes = (List)SerializationUtils.fromJsonString((String)searchNodesStr, List.class);
        ArrayList<TreeNode> tempList = new ArrayList<TreeNode>(searchNodes.size());
        TreeNode tempNode = null;
        for (int i = 0; i < searchNodes.size(); ++i) {
            Map tempMap = (Map)searchNodes.get(i);
            tempNode = new TreeNode((String)tempMap.get("parentid"), (String)tempMap.get("id"), (String)tempMap.get("text"));
            tempList.add(tempNode);
        }
        return tempList;
    }

    public static void putTreeNodeToCache(List<TreeNode> treeNodes, IFormView view) {
        view.getPageCache().put(view.getPageId() + SEARCHNODEKEY, SerializationUtils.toJsonString(treeNodes));
    }
}

