/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PermissionValidatorHelper {
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";

    public static Map<String, Object> checkDataRule(String appId, String entity, String permItemId, Long currentOrgId, String opMsg, ListSelectedRowCollection selectedRows) {
        if (StringUtils.isBlank((CharSequence)selectedRows.get(0).getNumber())) {
            ArrayList<Long> dataIds = new ArrayList<Long>(selectedRows.size());
            selectedRows.forEach(r -> dataIds.add((Long)r.getPrimaryKeyValue()));
            return PermissionValidatorHelper.checkDataRule(appId, entity, permItemId, currentOrgId, opMsg, dataIds);
        }
        QFilter dataRuleFilter = PermissionValidatorHelper.getDataRuleFilter(appId, entity, permItemId, Collections.singletonList(currentOrgId));
        if (null == dataRuleFilter) {
            return PermissionValidatorHelper.packResult(new ArrayList<String>(0));
        }
        Set<Long> idsMatchDataRule = PermissionValidatorHelper.selectMatchDataRuleIds(dataRuleFilter, entity);
        ArrayList<String> messages = new ArrayList<String>();
        for (ListSelectedRow row : selectedRows) {
            Long dataId = (Long)row.getPrimaryKeyValue();
            if (idsMatchDataRule.contains(dataId)) continue;
            String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u201c%2$s\u201d\u64cd\u4f5c\u6240\u9700\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PermissionValidatorHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            messages.add(String.format(msg, row.getNumber(), opMsg));
        }
        return PermissionValidatorHelper.packResult(messages);
    }

    public static Map<String, Object> checkDataRule(String appId, String entity, String permItemId, Long currentOrgId, String opMsg, List<Long> dataIds) {
        QFilter dataRuleFilter = PermissionValidatorHelper.getDataRuleFilter(appId, entity, permItemId, Collections.singletonList(currentOrgId));
        if (null == dataRuleFilter) {
            return PermissionValidatorHelper.packResult(new ArrayList<String>(0));
        }
        Set<Long> idsMatchDataRule = PermissionValidatorHelper.selectMatchDataRuleIds(dataRuleFilter, entity);
        QFilter filter = new QFilter("id", "in", dataIds);
        DynamicObjectCollection selectObjs = QueryServiceHelper.query((String)entity, (String)"id,number", (QFilter[])filter.toArray());
        ArrayList<String> messages = new ArrayList<String>(10);
        for (DynamicObject data : selectObjs) {
            long dataId = data.getLong("id");
            if (idsMatchDataRule.contains(dataId)) continue;
            String number = data.getString("number");
            String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u201c%2$s\u201d\u64cd\u4f5c\u6240\u9700\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PermissionValidatorHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            messages.add(String.format(msg, number, opMsg));
        }
        return PermissionValidatorHelper.packResult(messages);
    }

    private static QFilter getDataRuleFilter(String appId, String entity, String permItemId, List<Long> orgIds) {
        long currUserId = RequestContext.get().getCurrUserId();
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return service.getDataRuleWithoutDim(currUserId, appId, entity, permItemId, orgIds);
    }

    private static Set<Long> selectMatchDataRuleIds(QFilter dataRuleFilter, String entity) {
        DynamicObjectCollection objs = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{dataRuleFilter});
        return objs.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
    }

    private static Map<String, Object> packResult(List<String> messages) {
        HashMap<String, Object> res = new HashMap<String, Object>(16);
        res.put("isMatch", messages.isEmpty());
        res.put("messages", messages);
        return res;
    }

    public static FormShowParameter buildFormShowParameter(List<String> messages) {
        HashMap<String, List<String>> customParams = new HashMap<String, List<String>>(1);
        customParams.put("errorMsg", messages);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_operationresult");
        parameter.setCustomParams(customParams);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setShowTitle(false);
        return parameter;
    }

    public static boolean checkFuncPerm(String dimOrg, long createOrg, String appId, String entityNumber, String permItemId, String opName, IFormView view) {
        boolean hasFunction;
        long userId = RequestContext.get().getCurrUserId();
        String caption = FormMetadataCache.getFormConfig((String)entityNumber).getCaption().getLocaleValue();
        boolean bl = hasFunction = 1 == PermissionServiceHelper.checkPermission((long)userId, (String)dimOrg, (long)createOrg, (String)appId, (String)entityNumber, (String)permItemId);
        if (!hasFunction) {
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"AbstractBaseDataPreValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            view.showErrorNotification(String.format(msg, caption, opName));
            return false;
        }
        return true;
    }
}

