/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl.op;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;

public abstract class AbstractBaseDataOpServicePlugin
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(AbstractBaseDataOpServicePlugin.class);
    private List<Object> leafDataIds = new ArrayList<Object>(10);
    private Boolean noneCustomEntity;
    private Boolean newModel;
    private Boolean treeType;

    protected void beforeExecuteOperationTransaction(BeforeOperationArgs e, ExtendedDataEntity entity) {
        String entityNumber = this.billEntityType.getName();
        DynamicObject obj = entity.getDataEntity();
        Long parentId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)"parent");
        if (parentId == 0L) {
            return;
        }
        if (BaseDataBusinessServiceUtils.isEnableVersion((String)entityNumber)) {
            return;
        }
        Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)"useorg");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityNumber, (Long)useOrgId);
        if (null == baseDataFilter) {
            return;
        }
        DynamicObject parent = this.restoreParentData(obj, parentId, e, baseDataFilter);
        if (e.isCancel()) {
            return;
        }
        boolean isLeaf = parent.getBoolean("isleaf");
        if (isLeaf) {
            this.leafDataIds.add(parent.getPkValue());
        }
        String parentStrategy = parent.getString("ctrlstrategy");
        if (!isLeaf || "5".equals(parentStrategy)) {
            return;
        }
        parent.set("useorg", (Object)useOrgId);
        Long parentCreateOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)parent, (String)"createorg");
        if (parentCreateOrgId != 0L && !parentCreateOrgId.equals(useOrgId)) {
            if (this.isNoneCustomEntity()) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u8d44\u6599\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"AbstractBaseDataOpServicePlugin_1", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DynamicObject oldParent = (DynamicObject)cloneUtils.clone((IDataEntityBase)parent);
            oldParent.set("id", (Object)parentId);
            BaseDataServiceHelper.handleModify((DynamicObject)parent);
            obj.set("parent", (Object)parent);
            if ("6".equals(parentStrategy) && !this.isNewModel()) {
                ArrayList<Long> orgIds = new ArrayList<Long>();
                orgIds.add(useOrgId);
                String ctrlStgyView = BaseDataServiceHelper.getCtrlStgyViewSchema((String)obj.getDataEntityType().toString());
                List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.parseLong(ctrlStgyView), orgIds, (boolean)false);
                if (!CollectionUtils.isEmpty((Collection)subOrgIds)) {
                    BaseDataServiceHelper.saveBaseDataExc((DynamicObject)oldParent, (Long)parentId, (Long)parentCreateOrgId, (List)subOrgIds);
                }
            }
        }
    }

    protected DynamicObject restoreParentData(DynamicObject obj, Long parentId, BeforeOperationArgs e, QFilter baseDataFilter) {
        String entityNumber = this.billEntityType.getName();
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)entityNumber);
        if (null != obj.get("parent")) {
            DynamicObject newParent = this.restoreParentData(obj, entityNumber, baseDataFilter, parentId, parent);
            if (null != newParent) {
                parent = newParent;
            } else {
                this.cancelOP(e);
            }
        }
        return parent;
    }

    protected void cancelOP(BeforeOperationArgs e) {
        e.setCancel(true);
        e.setCancelMessage(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u65e0\u6743\u4f7f\u7528\u5f55\u5165\u7684\u4e0a\u7ea7\u8d44\u6599\uff0c\u4e0d\u80fd\u7ed9\u8be5\u4e0a\u7ea7\u8d44\u6599\u6dfb\u52a0\u4e0b\u7ea7\u3002", (String)"AbstractBaseDataOpServicePlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
    }

    private DynamicObject restoreParentData(DynamicObject obj, String entityNumber, QFilter baseDataFilter, Long parentId, DynamicObject oldParent) {
        String number = oldParent.getString("number");
        QFilter[] filters = new QFilter[]{baseDataFilter, new QFilter("number", "=", (Object)number)};
        DynamicObject newParent = BusinessDataServiceHelper.loadSingle((String)entityNumber, (QFilter[])filters);
        return this.restoreParentData(obj, newParent, parentId, oldParent);
    }

    protected DynamicObject restoreParentData(DynamicObject obj, DynamicObject newParent, Long parentId, DynamicObject oldParent) {
        if (null == newParent) {
            return null;
        }
        this.setCtrlStrategy(newParent, obj);
        Long newParenId = newParent.getLong("id");
        if (parentId.equals(newParenId)) {
            return oldParent;
        }
        if (!oldParent.getPkValue().equals(newParent.getPkValue())) {
            obj.set("parent", (Object)newParent);
        }
        return newParent;
    }

    private void setCtrlStrategy(DynamicObject parent, DynamicObject obj) {
        String objStrategy;
        String parentStrategy = parent.getString("ctrlstrategy");
        if (!parentStrategy.equals(objStrategy = obj.getString("ctrlstrategy"))) {
            obj.set("ctrlstrategy", (Object)parentStrategy);
        }
    }

    protected void triggerEventSubscribe() {
        if (this.leafDataIds.isEmpty() || !this.isTreeType()) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", this.leafDataIds), new QFilter("isleaf", "=", (Object)Boolean.FALSE)};
        ArrayList dataIds = new ArrayList(this.leafDataIds.size());
        try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), this.billEntityType.getName(), "id", filters);){
            ds.forEach(row -> dataIds.add(row.get("id")));
        }
        if (dataIds.isEmpty()) {
            return;
        }
        try {
            HashMap<String, Object> eventParam = new HashMap<String, Object>(2);
            eventParam.put("dataIds", dataIds);
            eventParam.put("entity", this.billEntityType.getName());
            EventServiceHelper.triggerEventSubscribe((String)"bd.changeToNonLeafEvent", (String)SerializationUtils.toJsonString(eventParam));
        }
        catch (Exception e) {
            LOGGER.error("\u53f6\u5b50\u8282\u70b9\u81ea\u52a8\u53d8\u66f4\u4e3a\u975e\u53f6\u5b50\u8282\u70b9\u65f6\uff0c\u53d1\u9001\u4e8b\u4ef6\u901a\u77e5\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
    }

    protected boolean isNewModel() {
        if (null == this.newModel) {
            this.newModel = BaseDataCommonService.isNewModel((String)this.billEntityType.getName());
        }
        return this.newModel;
    }

    protected boolean isTreeType() {
        if (null == this.treeType) {
            this.treeType = BaseDataCommonService.isTreeType((String)this.billEntityType.getName());
        }
        return this.treeType;
    }

    private boolean isNoneCustomEntity() {
        if (null == this.noneCustomEntity) {
            this.noneCustomEntity = BaseDataServiceHelper.isNoneCustomEntity((String)this.billEntityType.getName());
        }
        return this.noneCustomEntity;
    }
}

