/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.common.BaseDataCtrlLog;
import kd.bos.basedata.service.BDCtrlLogServiceHelper;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

@Deprecated
public class BaseDataAssignService {
    private String entity;
    private Long assignOrgId;
    private String strategy;
    private String masterIdField;
    private String masterIdProp;
    private final String numberPro;
    private Map<Long, Set<Long>> assignMap;
    private Set<Long> orgIds;

    public BaseDataAssignService(String entity, Long assignOrgId, String strategy, Set<Long> orgIds, Map<Long, Set<Long>> assignMap) {
        boolean isAssignStrategy;
        if (StringUtils.isBlank((CharSequence)entity)) {
            throw new KDBizException("entity can not be null.");
        }
        this.entity = entity;
        if (null == assignOrgId) {
            throw new KDBizException("assignOrgId can not be null.");
        }
        this.assignOrgId = assignOrgId;
        boolean bl = isAssignStrategy = "2".equals(strategy) || "1".equals(strategy);
        if (!isAssignStrategy) {
            throw new KDBizException("strategy is not assign type.");
        }
        this.strategy = strategy;
        if (CollectionUtils.isEmpty(orgIds)) {
            throw new KDBizException("'orgIds' can not be empty.");
        }
        this.orgIds = orgIds;
        if ("1".equals(strategy) && CollectionUtils.isEmpty(assignMap)) {
            throw new KDBizException("gradually strategy type's data, 'assignMap' can not be empty.");
        }
        this.assignMap = assignMap;
        this.masterIdField = BaseDataServiceHelper.getMasterIdFieldName((String)entity);
        this.masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        this.numberPro = BaseDataCommonService.isOtherMasterIdType((String)entity) ? "masterid.number" : "number";
    }

    @Deprecated
    public Map<Long, Map<Long, String>> executeAssign(List<Long> dataIds) {
        if (CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptyMap();
        }
        Map<Long, String> dataIdNumberMap = this.initDataNumber(dataIds);
        HashMap<Long, Map<Long, String>> checkAssignRes = new HashMap(16);
        if (this.strategy.equals("2")) {
            checkAssignRes = BaseDataServiceHelper.batchAssignWithDetail((String)this.entity, (Long)this.assignOrgId, dataIds, new ArrayList<Long>(this.orgIds));
        } else {
            String selectFields = String.join((CharSequence)",", "id", "ctrlstrategy", this.numberPro, this.masterIdProp);
            this.handleAssignDataByLevel(this.assignOrgId, checkAssignRes, dataIds, dataIdNumberMap, selectFields);
        }
        this.addAssignLog(dataIds, this.assignOrgId, this.orgIds, dataIdNumberMap, checkAssignRes);
        return checkAssignRes;
    }

    private Map<Long, String> initDataNumber(List<Long> dataIds) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entity);
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid, fnumber from ", new Object[0]).append(dt.getAlias(), new Object[0]).append(" where ", new Object[0]);
        builder.appendIn("fid", dataIds.toArray());
        return (Map)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
            HashMap<Long, String> idNumber = new HashMap<Long, String>(16);
            while (rs.next()) {
                idNumber.put(rs.getLong("FID"), rs.getString("FNUMBER"));
            }
            return idNumber;
        });
    }

    private void handleAssignDataByLevel(Long parentId, Map<Long, Map<Long, String>> checkAssignRes, List<Long> dataIds, Map<Long, String> dataIdNumberMap, String selectFields) {
        if (!this.assignMap.containsKey(parentId) || CollectionUtils.isEmpty(dataIds)) {
            return;
        }
        Map<Long, Long> dataIdMasterIdMap = this.getDataIdMasterIdMap(dataIds);
        QFilter[] filters = new QFilter[]{new QFilter(this.masterIdProp, "in", dataIdMasterIdMap.values()), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdField), new QFilter("createorg", "=", (Object)parentId)};
        Map individuation = BusinessDataServiceHelper.loadFromCache((String)this.entity, (String)selectFields, (QFilter[])filters);
        HashMap<Long, String> personalDataMap = new HashMap<Long, String>(individuation.size());
        for (Object data : individuation.values()) {
            Long mid = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)data, (String)this.masterIdProp);
            Object dataId = data.getPkValue();
            personalDataMap.put(mid, dataId + "_" + data.getString("ctrlstrategy"));
            dataIdNumberMap.put((Long)dataId, data.getString(this.numberPro));
        }
        ArrayList<Long> assignDataIds = new ArrayList<Long>(dataIds.size());
        for (Long dataId : dataIds) {
            Long masterId = dataIdMasterIdMap.get(dataId);
            if (!personalDataMap.containsKey(masterId)) {
                assignDataIds.add(dataId);
                continue;
            }
            if (!"1".equals(((String)personalDataMap.get(masterId)).split("_")[1])) continue;
            assignDataIds.add(Long.valueOf(((String)personalDataMap.get(masterId)).split("_")[0]));
        }
        ArrayList orgIds = new ArrayList(this.assignMap.get(parentId));
        Map checkAssignReMap = BaseDataServiceHelper.batchAssignWithDetail((String)this.entity, (Long)parentId, assignDataIds, orgIds);
        if (!CollectionUtils.isEmpty((Map)checkAssignReMap)) {
            for (Map.Entry entry : checkAssignReMap.entrySet()) {
                checkAssignRes.computeIfAbsent((Long)entry.getKey(), (Function<Long, Map<Long, String>>)((Function<Long, Map>)k -> new HashMap(16))).putAll((Map)entry.getValue());
            }
        }
        for (Long l : orgIds) {
            this.handleAssignDataByLevel(l, checkAssignRes, assignDataIds, dataIdNumberMap, selectFields);
        }
    }

    private Map<Long, Long> getDataIdMasterIdMap(List<Long> dataIds) {
        HashMap<Long, Long> dataIdMasterIdMap = new HashMap<Long, Long>(dataIds.size());
        SqlBuilder builder = new SqlBuilder();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entity);
        builder.append("select fid,", new Object[0]).append(this.masterIdField, new Object[0]).append(" from ", new Object[0]).append(dt.getAlias(), new Object[0]);
        builder.append(" where ", new Object[0]).appendIn("fid", new ArrayList<Long>(dataIds));
        try (DataSet ds = DB.queryDataSet((String)BaseDataAssignService.class.getName(), (DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder);){
            for (Row row : ds) {
                dataIdMasterIdMap.put(row.getLong("fid"), row.getLong(this.masterIdField));
            }
        }
        return dataIdMasterIdMap;
    }

    private void addAssignLog(List<Long> dataIds, Long assignOrgId, Collection<Long> orgIds, Map<Long, String> dataIdNumberMap, Map<Long, Map<Long, String>> checkAssignReMap) {
        if (CollectionUtils.isEmpty(dataIds)) {
            return;
        }
        ArrayList<BaseDataCtrlLog> loges = new ArrayList<BaseDataCtrlLog>(dataIds.size());
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)this.entity);
        String appNumber = met.getBizAppNumber();
        BaseDataCtrlLog log = new BaseDataCtrlLog(appNumber, this.entity, "assign_new", assignOrgId, "");
        loges.add(log);
        BDCtrlLogServiceHelper.saveLogBatch(loges);
    }
}

