/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl.validator;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.plugin.bdctrl.helper.PermissionValidatorHelper;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BaseDataCtrlChangePreValidator {
    private static final String CREATEORG = "createorg";
    private static final String BDCTRL_CHANGE = "/IN0GIK354+3";
    private static final String CTRLSTRATEGY_CU_ASSIGN = "1";
    private static final String CTRLSTRATEGY_CU_FREE_ASSIGN = "2";
    private static final String CTRLSTRATEGY_PRIVATE = "7";
    private static final String CTRLSTRATEGY_FILEDNAME = "ctrlstrategy";
    private static final String NUMBER = "number";

    public boolean beforeItemClickBdctrlChange(BeforeItemClickEvent evt, Long userId, Long orgid, String appId, String entityName, List<Long> ids, IFormView viewPlugin) {
        int permRes = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgid, (String)appId, (String)entityName, (String)BDCTRL_CHANGE);
        if (0 == permRes) {
            String caption = FormMetadataCache.getFormConfig((String)entityName).getCaption().getLocaleValue();
            viewPlugin.showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"BaseDataCtrlChangePreValidator_0", (String)"bos-bd-formplugin", (Object[])new Object[0]), caption));
            return false;
        }
        if (!this.checkDataRule(orgid, appId, entityName, ids, viewPlugin)) {
            return false;
        }
        if (!this.checkHaveConfigOfCtrlStrategy(entityName, viewPlugin)) {
            return false;
        }
        if (!this.checkBdCtrlDatas(entityName, ids, viewPlugin, orgid)) {
            return false;
        }
        return !this.checkFreeAssgin(entityName, ids, viewPlugin);
    }

    private boolean checkDataRule(Long orgid, String appId, String entityName, List<Long> dataIds, IFormView viewPlugin) {
        String opMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u63a7\u5236\u7b56\u7565", (String)"BaseDataCtrlChangePreValidator_1", (String)"bos-bd-formplugin", (Object[])new Object[0]);
        Map<String, Object> map = PermissionValidatorHelper.checkDataRule(appId, entityName, BDCTRL_CHANGE, orgid, opMsg, dataIds);
        List messages = (List)map.get("messages");
        if (messages.size() > 0) {
            FormShowParameter parameter = PermissionValidatorHelper.buildFormShowParameter(messages);
            viewPlugin.showForm(parameter);
        }
        return (Boolean)map.get("isMatch");
    }

    private boolean checkBdCtrlDatas(String entityName, List<Long> ids, IFormView viewPlugin, Long useOrgId) {
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityName);
        String selectFields = "id, ctrlstrategy, createOrg," + masteridPropName + ",number,level";
        QFilter[] qfArr = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject[] dyCol = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfArr);
        String appId = viewPlugin.getFormShowParameter().getAppId();
        if (dyCol == null || dyCol.length == 0) {
            return false;
        }
        Long orgId = 0L;
        if (dyCol[0].get(CREATEORG) instanceof DynamicObject) {
            orgId = (Long)dyCol[0].getDynamicObject(CREATEORG).getPkValue();
        } else if (dyCol[0].get(CREATEORG) instanceof Long) {
            orgId = (Long)dyCol[0].get(CREATEORG);
        }
        if (!this.checkBdCtrlDatas_1(dyCol, orgId, useOrgId, viewPlugin, masteridPropName, entityName)) {
            return false;
        }
        if (PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (long)orgId, (String)appId, (String)entityName, (String)BDCTRL_CHANGE) == 0) {
            viewPlugin.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u6743\u9650\u3002", (String)"BaseDataCtrlChangePreValidator_2", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkHaveConfigOfCtrlStrategy(String entityId, IFormView formView) {
        DynamicObject view = BaseDataServiceHelper.getCtrlview((String)entityId);
        if (view == null) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u63a7\u5236\u7b56\u7565\u7684\u7ba1\u63a7\u89c6\u56fe\u5931\u8d25\uff0c \u8bf7\u5728\u201c\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u201d\u4e2d\u5148\u914d\u7f6e\u65b0\u589e\u3002", (String)"BaseDataCtrlChangePreValidator_3", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkFreeAssgin(String entityName, List<Long> ids, IFormView viewPlugin) {
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityName);
        boolean isMaterialInfo = false;
        String selectFilds = null;
        if (!"masterid".equals(masteridPropName)) {
            selectFilds = "id,number," + masteridPropName + ",ctrlstrategy,masterid.number";
            isMaterialInfo = true;
        } else {
            selectFilds = "id,number," + masteridPropName + ",ctrlstrategy";
        }
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "in", ids);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection list = orm.query(entityName, selectFilds, filters);
        for (DynamicObject obj : list) {
            boolean checkIdentify;
            String id = obj.get("id").toString();
            String masterid = obj.get(masteridPropName).toString();
            String ctrlstrategy = obj.get(CTRLSTRATEGY_FILEDNAME).toString();
            if (BaseDataCommonService.isTreeType((String)entityName)) {
                boolean bl = checkIdentify = (ctrlstrategy.equals(CTRLSTRATEGY_CU_FREE_ASSIGN) || ctrlstrategy.equals(CTRLSTRATEGY_CU_ASSIGN)) && !masterid.equals(id);
                if (checkIdentify) {
                    StringBuilder noticeMsg = new StringBuilder();
                    Object number = isMaterialInfo ? obj.get("masterid.number") : obj.get(NUMBER);
                    noticeMsg.append(number).append("\uff1a");
                    if (ctrlstrategy.equals(CTRLSTRATEGY_CU_FREE_ASSIGN)) {
                        noticeMsg.append(ResManager.loadKDString((String)"\u81ea\u7531\u5206\u914d\u7684\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataCtrlChangePreValidator_5", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                    } else {
                        noticeMsg.append(ResManager.loadKDString((String)"\u9010\u7ea7\u5206\u914d\u7684\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataCtrlChangePreValidator_6", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                    }
                    viewPlugin.showTipNotification(noticeMsg.toString());
                    return true;
                }
                if (!ctrlstrategy.equals(CTRLSTRATEGY_PRIVATE)) continue;
                viewPlugin.showTipNotification(ResManager.loadKDString((String)"\u201c\u79c1\u6709\u578b\u201d\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataCtrlChangePreValidator_7", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                return true;
            }
            checkIdentify = ctrlstrategy.equals(CTRLSTRATEGY_CU_FREE_ASSIGN) && !masterid.equals(id);
            if (!checkIdentify) continue;
            Object number = isMaterialInfo ? obj.get("masterid.number") : obj.get(NUMBER);
            viewPlugin.showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u81ea\u7531\u5206\u914d\u7684\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataCtrlChangePreValidator_4", (String)"bos-bd-formplugin", (Object[])new Object[0]), number));
            return true;
        }
        return false;
    }

    private boolean checkBdCtrlDatas_1(DynamicObject[] dyCol, Long orgId, Long useOrgId, IFormView viewPlugin, String masteridPropName, String entityName) {
        String ctrlstrategy = dyCol[0].getString(CTRLSTRATEGY_FILEDNAME);
        String baseDataTableName = dyCol[0].getDataEntityType().getAlias();
        String dataTableUseName = baseDataTableName + "UseReg";
        String dbRouteKey = dyCol[0].getDataEntityType().getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        for (int i = 0; i < dyCol.length; ++i) {
            Long createorg = 0L;
            if (dyCol[0].get(CREATEORG) instanceof DynamicObject) {
                createorg = (Long)dyCol[i].getDynamicObject(CREATEORG).getPkValue();
            } else if (dyCol[0].get(CREATEORG) instanceof Long) {
                createorg = (Long)dyCol[i].get(CREATEORG);
            }
            if (!useOrgId.equals(createorg)) {
                viewPlugin.showTipNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataCtrlChangePreValidator_8", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!ctrlstrategy.equals(dyCol[i].getString(CTRLSTRATEGY_FILEDNAME))) {
                viewPlugin.showTipNotification(ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataCtrlChangePreValidator_9", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!orgId.equals(useOrgId)) {
                viewPlugin.showTipNotification(String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u4e0e%s\u76f8\u540c\u65f6\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataCtrlChangePreValidator_10", (String)"bos-bd-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"BaseDataCtrlChangePreValidator_12", (String)"bos-bd-formplugin", (Object[])new Object[0])));
                return false;
            }
            List<String> AssignResult = this.getAssignResult(dyCol, dataTableUseName, dbRoute, i);
            if (AssignResult == null || AssignResult.size() <= 0) continue;
            viewPlugin.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u672a\u5206\u914d\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataCtrlChangePreValidator_11", (String)"bos-bd-formplugin", (Object[])new Object[0]), dyCol[i].get(NUMBER)));
            return false;
        }
        return true;
    }

    private List<String> getAssignResult(DynamicObject[] dyCol, String dataTableUseName, DBRoute dbRoute, int i) {
        String sql = " SELECT  mu.fuseorgid uoid from " + dataTableUseName + " mu  where mu.fdataid = " + dyCol[i].getPkValue() + " and mu.FisAssign = '1' ";
        List AssignResult = (List)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(8);
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                return list;
            }
        });
        return AssignResult;
    }
}

