/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.bdctrl.validator.BaseDataAssignPreValidator;
import kd.bos.orm.util.CollectionUtils;

public class TreeBaseDataAssignPreValidator
extends BaseDataAssignPreValidator {
    private static final String KEY_IS_LEAF = "isleaf";
    private static final String KEY_LONG_NUMBER = "longnumber";
    private final Long currentOrgId;

    public TreeBaseDataAssignPreValidator(IFormView view, String entity, String type, Long currentOrgId) {
        super(view, entity, type);
        this.entity = entity;
        this.currentOrgId = currentOrgId;
    }

    protected Set<String> getSelectFields() {
        Set selectFields = super.getSelectFields();
        selectFields.addAll(Arrays.asList(KEY_IS_LEAF, KEY_LONG_NUMBER));
        return selectFields;
    }

    public boolean integrityValidate(List<Long> dataIds, Collection<String> fields) {
        DynamicObjectCollection collection = this.getDataCollectionByDataIds(dataIds, fields);
        return this.otherBusinessValidate(this.currentOrgId, collection, dataIds);
    }

    public boolean otherBusinessValidate(Long currentOrgId, DynamicObjectCollection collection, List<Long> dataIds) {
        if (!super.otherBusinessValidate(currentOrgId, collection, dataIds)) {
            return false;
        }
        ArrayList<String> longNumberList = new ArrayList<String>(10);
        String dlm = BaseDataCommonService.getLongNumberDLM((String)this.entity);
        TreeBaseDataCommonService service = new TreeBaseDataCommonService(this.entity);
        if (TreeBaseDataCommonService.isAssignUnDetail((String)this.entity)) {
            collection.forEach(e -> this.collectLongNumber(e.getString(KEY_LONG_NUMBER), longNumberList, dlm));
            List nodes = service.getIntegrityRootNodes(new HashSet<Long>(dataIds), longNumberList, currentOrgId);
            return this.uniqueStrategyValidate(nodes);
        }
        HashSet<Long> leafNodeIds = new HashSet<Long>(collection.size());
        HashMap<Long, String> selectNodeMap = new HashMap<Long, String>(dataIds.size());
        for (DynamicObject data : collection) {
            Long id = data.getLong("id");
            selectNodeMap.put(id, data.getString("number"));
            if (!data.getBoolean(KEY_IS_LEAF)) continue;
            leafNodeIds.add(id);
            this.collectLongNumber(data.getString(KEY_LONG_NUMBER), longNumberList, dlm);
        }
        List nodes = service.getIntegrityNodes(longNumberList, leafNodeIds, currentOrgId);
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            return this.excludeDetailTip(selectNodeMap, dataIds);
        }
        for (TreeNode node : nodes) {
            selectNodeMap.remove(Long.valueOf(node.getId()));
            if (!this.inconsistentStrategy(node.getChildren(), node.getType(), selectNodeMap)) continue;
            return false;
        }
        if (!CollectionUtils.isEmpty(selectNodeMap)) {
            return this.excludeDetailTip(selectNodeMap, dataIds);
        }
        return true;
    }

    private boolean excludeDetailTip(Map<Long, String> selectNodeMap, List<Long> dataIds) {
        if (CollectionUtils.isEmpty(selectNodeMap)) {
            return true;
        }
        StringJoiner joiner = new StringJoiner("\r\n");
        selectNodeMap.forEach((k, v) -> joiner.add(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5206\u914d\u65f6\u5fc5\u987b\u5305\u542b\u660e\u7ec6\u8d44\u6599\u624d\u80fd\u5206\u914d\u3002", (String)"TreeBaseDataAssignPreValidator_1", (String)"bos-bd-formplugin", (Object[])new Object[0]), v)));
        if (selectNodeMap.size() == 1) {
            this.getView().showTipNotification(joiner.toString());
        } else {
            String msg = ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u6821\u9a8c\u5931\u8d25%2$s\u6761", (String)"TreeBaseDataAssignPreValidator_2", (String)"bos-bd-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(String.format(msg, dataIds.size(), selectNodeMap.size()), joiner.toString(), MessageTypes.Default);
        }
        return false;
    }

    private boolean inconsistentStrategy(List<TreeNode> nodes, String strategy, Map<Long, String> selectNodeMap) {
        if (CollectionUtils.isEmpty(nodes)) {
            return false;
        }
        for (TreeNode node : nodes) {
            boolean inconsistent;
            selectNodeMap.remove(Long.valueOf(node.getId()));
            String childStrategy = node.getType();
            boolean bl = inconsistent = StringUtils.isEmpty((CharSequence)childStrategy) || !childStrategy.equals(strategy);
            if (inconsistent) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4e0b\u7ea7\u8d44\u6599\u63a7\u5236\u7b56\u7565\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u3002", (String)"TreeBaseDataAssignPreValidator_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (!this.inconsistentStrategy(node.getChildren(), strategy, selectNodeMap)) continue;
            return true;
        }
        return false;
    }

    private boolean uniqueStrategyValidate(List<TreeNode> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return true;
        }
        for (TreeNode node : nodes) {
            if (this.uniqueStrategyValidate(node.getChildren(), node.getType())) continue;
            return false;
        }
        return true;
    }

    private boolean uniqueStrategyValidate(List<TreeNode> children, String strategy) {
        if (CollectionUtils.isEmpty(children)) {
            return true;
        }
        for (TreeNode node : children) {
            String childStrategy = node.getType();
            if (StringUtils.isEmpty((CharSequence)childStrategy) || !childStrategy.equals(strategy)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4e0b\u7ea7\u8d44\u6599\u63a7\u5236\u7b56\u7565\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u3002", (String)"TreeBaseDataAssignPreValidator_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (this.uniqueStrategyValidate(node.getChildren(), strategy)) continue;
            return false;
        }
        return true;
    }

    private void collectLongNumber(String longNumber, List<String> longNumberList, String dlm) {
        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
            longNumberList.add(longNumber);
            if (longNumber.contains(dlm)) {
                this.getLongNumbers(longNumberList, longNumber, dlm);
            }
        }
    }

    private void getLongNumbers(List<String> numberList, String longNumber, String dlm) {
        int lastIndex = longNumber.lastIndexOf(dlm);
        String number = longNumber.substring(0, lastIndex);
        numberList.add(number);
        if (number.contains(dlm)) {
            this.getLongNumbers(numberList, number, dlm);
        }
    }
}

