/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.bd.service.AssignQueryService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.bdctrl.validator.BaseDataCancelAssignPreValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TreeBaseDataCancelAssignPreValidator
extends BaseDataCancelAssignPreValidator {
    static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private static final String FIELD_LONG_NUMBER = "longnumber";
    private static final String FIELD_IS_LEAF = "isleaf";
    private static final String FIELD_PARENT_ID = "parent.id";
    private Set<String> unableCancelDataNumSet = new HashSet<String>(16);
    private final Long currentOrgId;

    public TreeBaseDataCancelAssignPreValidator(IFormView view, String entity, Long currentOrgId, String type) {
        super(view, entity, type);
        this.currentOrgId = currentOrgId;
    }

    protected Set<String> getSelectFields() {
        Set selectFields = super.getSelectFields();
        selectFields.addAll(Arrays.asList(FIELD_LONG_NUMBER, FIELD_IS_LEAF));
        return selectFields;
    }

    protected String getOrderBys() {
        return FIELD_LONG_NUMBER;
    }

    @Override
    public boolean otherBusinessValidate(Long currentOrgId, DynamicObjectCollection collection, List<Long> dataIds) {
        if (!super.otherBusinessValidate(currentOrgId, collection, dataIds)) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)collection) || 1 == collection.size() && ((DynamicObject)collection.get(0)).getBoolean(FIELD_IS_LEAF)) {
            return true;
        }
        Set<Long> unableCancelDataIds = this.getUnableCancelDataIds(dataIds);
        for (DynamicObject data : collection) {
            Long dataId;
            if (data.getBoolean(FIELD_IS_LEAF) || !unableCancelDataIds.contains(dataId = Long.valueOf(data.getLong("id")))) continue;
            this.unableCancelDataNumSet.add(data.getString(this.numberField));
        }
        return this.validateAndTip();
    }

    private Set<Long> getUnableCancelDataIds(List<Long> dataIds) {
        HashSet<Long> idSet = new HashSet<Long>(dataIds);
        String selectFields = "id,parent.id";
        QFilter[] filters = new QFilter[]{new QFilter(FIELD_PARENT_ID, "in", dataIds)};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)this.entity, (String)selectFields, (QFilter[])filters);
        if (dynamicObjectMap.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Long> ableSelectDataIds = this.getAbleSelectDataIds(dataIds, dynamicObjectMap);
        HashSet<Long> unableCancelDataIds = new HashSet<Long>(16);
        for (DynamicObject data : dynamicObjectMap.values()) {
            Long pid = data.getLong(FIELD_PARENT_ID);
            Long dataId = data.getLong("id");
            if (idSet.contains(dataId) || !ableSelectDataIds.contains(dataId)) continue;
            unableCancelDataIds.add(pid);
        }
        return unableCancelDataIds;
    }

    private Set<Long> getAbleSelectDataIds(List<Long> dataIds, Map<Object, DynamicObject> dataMap) {
        HashSet<Long> ableSelectDataIds = new HashSet<Long>(dataIds);
        dataMap.keySet().forEach(dataId -> ableSelectDataIds.add(Long.valueOf(dataId.toString())));
        if (BaseDataCommonService.isNewModel((String)this.entity)) {
            HashSet allDataList = new HashSet(new AssignQueryService(this.entity).getAssignTypeDataList(this.entity, this.currentOrgId));
            ableSelectDataIds.retainAll(allDataList);
            return ableSelectDataIds;
        }
        IDataEntityType dt = ORM.create().getDataEntityType(this.entity);
        SqlBuilder builder = new SqlBuilder();
        builder.append(String.format("select fdataid from %s_u where fuseorgid = %s and ", dt.getAlias(), this.currentOrgId), new Object[0]);
        builder.appendIn("fdataid", ableSelectDataIds.toArray(new Object[0]));
        return (Set)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
            HashSet<Long> result = new HashSet<Long>(16);
            while (rs.next()) {
                result.add(rs.getLong("fdataid"));
            }
            return result;
        });
    }

    private String getTip(String number) {
        String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5b58\u5728\u4e0b\u7ea7\u6570\u636e\uff0c\u53d6\u6d88\u5206\u914d\u65f6\u5fc5\u987b\u52fe\u9009\u6240\u6709\u4e0b\u7ea7\u6570\u636e\u624d\u80fd\u53d6\u6d88\u5206\u914d\u3002", (String)"TreeBaseDataCancelAssignPreValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        return String.format(msg, number);
    }

    private boolean validateAndTip() {
        if (this.unableCancelDataNumSet.isEmpty()) {
            return true;
        }
        if (1 == this.unableCancelDataNumSet.size()) {
            for (String value : this.unableCancelDataNumSet) {
                this.getView().showTipNotification(this.getTip(value));
            }
        } else {
            String title = ResManager.loadKDString((String)"\u7981\u6b62\u53d6\u6d88\u5206\u914d\u3002", (String)"TreeBaseDataCancelAssignPreValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            StringJoiner joiner = new StringJoiner("\r\n");
            for (String value : this.unableCancelDataNumSet) {
                joiner.add(this.getTip(value));
            }
            this.getView().showMessage(title, joiner.toString(), MessageTypes.Default);
        }
        return false;
    }
}

