/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdlog;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BDCtrlLogSettingsPlugin
extends AbstractFormPlugin {
    private static final String ENTITY_OPERATE_TYPE = "bdlog_optype";
    private static final String PROP_ID = "id";
    private static final String PROP_NAME = "name";
    private static final String PROP_OPERATE_TYPE = "operatetype";
    private static final String PROP_ARCHIVE_RETAIN_DAYS = "archiveretaindays";
    private static final String PROP_ENTRYENTITY = "entryentity";
    private static final String BTN_SAVE = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_SAVE});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadOperateTypeData();
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_SAVE.equals(key)) {
            this.saveSettings();
        }
    }

    private void loadOperateTypeData() {
        String selectFields = "name,archiveretaindays";
        DynamicObject[] operateTypes = BusinessDataServiceHelper.load((String)ENTITY_OPERATE_TYPE, (String)selectFields, (QFilter[])new QFilter[0]);
        if (operateTypes == null || operateTypes.length == 0) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PROP_ENTRYENTITY);
        if (entryEntity != null) {
            for (DynamicObject operateType : operateTypes) {
                ILocaleString operateTypeName = operateType.getLocaleString(PROP_NAME);
                int archiveRetainDays = operateType.getInt(PROP_ARCHIVE_RETAIN_DAYS);
                if (operateTypeName == null || archiveRetainDays == 0) continue;
                DynamicObject row = entryEntity.addNew();
                row.set(PROP_OPERATE_TYPE, (Object)operateTypeName);
                row.set(PROP_ARCHIVE_RETAIN_DAYS, (Object)archiveRetainDays);
                row.set(PROP_ID, operateType.getPkValue());
            }
        }
    }

    private void saveSettings() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PROP_ENTRYENTITY);
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        HashMap<Object, Integer> archiveRetainDaysMap = new HashMap<Object, Integer>(entryEntity.size());
        for (DynamicObject[] row : entryEntity) {
            Object id = row.getPkValue();
            int archiveRetainDays = row.getInt(PROP_ARCHIVE_RETAIN_DAYS);
            archiveRetainDaysMap.put(id, archiveRetainDays);
        }
        DynamicObject[] operateTypes = BusinessDataServiceHelper.load((String)ENTITY_OPERATE_TYPE, (String)PROP_ARCHIVE_RETAIN_DAYS, (QFilter[])new QFilter[0]);
        if (operateTypes == null || operateTypes.length == 0) {
            return;
        }
        for (DynamicObject operateType : operateTypes) {
            Object id = operateType.getPkValue();
            operateType.set(PROP_ARCHIVE_RETAIN_DAYS, archiveRetainDaysMap.get(id));
        }
        SaveServiceHelper.save((DynamicObject[])operateTypes);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BDCtrlLogSettingsPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }
}

