/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdlog;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bd.log.enums.BDCtrlOperateType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterObject;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class BDLogListPlugin
extends AbstractListPlugin {
    private static final String BTN_ARCHIVE_SETTINGS = "tblarchivesettings";
    private static final String BTN_REPORT_QUERY = "reportquery";
    private static final String FORM_ARCHIVE_SETTINGS = "bdctrl_log_setting";
    private static final String PROP_OP_OBJ_NAME = "operatobjname";
    private static final String PROP_OP_TYPE = "operattypename";
    private static final String PROP_OPERATED_ORG_NUMBER = "operatedorgnumber";
    private static final String PROP_OPERATED_ORG_NAME = "operatedorgname";
    private static final String PROP_OPERATED_DATA_NUMBER = "operateddatanumber";
    private static final String PROP_OPERATED_DATA_NAME = "operateddataname";
    private static final String PROP_DATA_ENTRY_NUMBER = "dataentry.datanumber";
    private static final String PROP_DATA_ENTRY_NAME = "dataentry.dataname";
    private static final String PROP_ORG_ENTRY_NUMBER = "orgentry.orgnumber";
    private static final String PROP_ORG_ENTRY_NAME = "orgentry.orgname";
    private static Map<String, String> customFilterFieldMap = new HashMap<String, String>(4);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{BTN_ARCHIVE_SETTINGS});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (StringUtils.isNotEmpty((String)fieldName) && customFilterFieldMap.containsKey(fieldName)) {
                filterColumn.setEntityField(false);
            }
            if (!"operattype.name".equals(filterColumn.getFieldName())) continue;
            filterColumn.setDefaultValue(BDCtrlOperateType.ASSIGN.getId().toString());
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getFilterValues();
        if (filterValues != null && !filterValues.isEmpty() && filterValues.containsKey("schemefilter")) {
            String msg = ResManager.loadKDString((String)"\u65e5\u5fd7\u67e5\u8be2\u65f6\uff1a\r\n1.\u9700\u6307\u5b9a\u4e00\u79cd\u201c\u64cd\u4f5c\u7c7b\u578b\u201d\u53ca\u201c\u64cd\u4f5c\u5bf9\u8c61\u201d\u4e14\u4ec5\u652f\u6301\u201c\u7b49\u4e8e\u201d\u6761\u4ef6\u3002\r\n2.\u903b\u8f91\u8fde\u63a5\u7b26\u4ec5\u652f\u6301\u201c\u5e76\u4e14\u201d\u3002", (String)"BDLogListPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]);
            FilterObject filterObject = args.getFilterModel().getFilterObject();
            List selectFields = filterObject.getSelectFields();
            if (CollectionUtils.isEmpty((Collection)selectFields) || !selectFields.contains(PROP_OP_TYPE) || !selectFields.contains(PROP_OP_OBJ_NAME)) {
                throw new KDBizException(msg);
            }
            QFilter filter = filterObject.getQFilter();
            if (!this.checkFilter(filter)) {
                throw new KDBizException(msg);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        if (CollectionUtils.isEmpty((Collection)qFilters)) {
            return;
        }
        for (QFilter filter : qFilters) {
            this.setEmptyFieldProperty(filter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_ARCHIVE_SETTINGS.equals(itemKey)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(FORM_ARCHIVE_SETTINGS);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        } else if (BTN_REPORT_QUERY.equals(itemKey)) {
            ReportShowParameter rsp = new ReportShowParameter();
            rsp.setFormId("bd_rpt_log");
            rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)rsp);
        }
    }

    private boolean checkFilter(QFilter filter) {
        Object filterValue;
        String filterProperty = filter.getProperty();
        if ((PROP_OP_TYPE.equals(filterProperty) || PROP_OP_OBJ_NAME.equals(filterProperty)) && ((filterValue = filter.getValue()) == null || "EMPTY".equalsIgnoreCase(filterValue.toString()))) {
            return false;
        }
        List nests = filter.getNests(true);
        if (CollectionUtils.isEmpty((Collection)nests)) {
            return true;
        }
        for (QFilter.QFilterNest nest : nests) {
            String op = nest.getOp();
            if (!"AND".equalsIgnoreCase(op)) {
                return false;
            }
            QFilter nestFilter = nest.getFilter();
            String nestFilterProperty = nestFilter.getProperty();
            if (!PROP_OP_TYPE.equals(nestFilterProperty) && !PROP_OP_OBJ_NAME.equals(nestFilterProperty)) continue;
            Object nestFilterValue = nestFilter.getValue();
            if (nestFilterValue == null || "EMPTY".equalsIgnoreCase(nestFilterValue.toString())) {
                return false;
            }
            String cp = nestFilter.getCP();
            if ("=".equals(cp)) continue;
            return false;
        }
        return true;
    }

    private void setEmptyFieldProperty(QFilter filter) {
        List nests;
        String filterProperty = filter.getProperty();
        if (customFilterFieldMap.containsKey(filterProperty)) {
            filter.__setProperty(customFilterFieldMap.get(filterProperty));
        }
        if (CollectionUtils.isEmpty((Collection)(nests = filter.getNests(true)))) {
            return;
        }
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestFilter = nest.getFilter();
            String nestFilterProperty = nestFilter.getProperty();
            if (!customFilterFieldMap.containsKey(nestFilterProperty)) continue;
            nestFilter.__setProperty(customFilterFieldMap.get(nestFilterProperty));
        }
    }

    static {
        customFilterFieldMap.put(PROP_OPERATED_ORG_NUMBER, PROP_ORG_ENTRY_NUMBER);
        customFilterFieldMap.put(PROP_OPERATED_ORG_NAME, PROP_ORG_ENTRY_NAME);
        customFilterFieldMap.put(PROP_OPERATED_DATA_NUMBER, PROP_DATA_ENTRY_NUMBER);
        customFilterFieldMap.put(PROP_OPERATED_DATA_NAME, PROP_DATA_ENTRY_NAME);
    }
}

