/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdlog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;

public class BDLogQueryRpt
extends AbstractReportListDataPlugin {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String FILTER_OPERATE_DATA = "operateddatas";
    private static final String FILTER_OPERATE_TYPE = "operattype";
    private static final String FILTER_OPERATE_OBJ = "operatobj";
    private static final String FILTER_OPERATED_ORG = "operatedorgs";
    private static final String FILTER_OPERATE_ORG = "operatorg";
    private static final String FILTER_START_TIME = "starttime";
    private static final String FILTER_END_TIME = "endtime";
    private static final String OP_TYPE_ORG_PERM_CHANGE = "orgpermchange";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select", new Object[0]);
        sql.append(" fid as id,", new Object[0]);
        sql.append("fnumber as number,", new Object[0]);
        sql.append("foperattypename as operatetype,", new Object[0]);
        sql.append("foperatobjname as operateobj,", new Object[0]);
        sql.append("foperatorgid as operateorg,", new Object[0]);
        sql.append("foperattime as operatetime,", new Object[0]);
        sql.append("foperatsource as operatesource,", new Object[0]);
        sql.append("foperatorname as operatorname,", new Object[0]);
        sql.append("foperatornumber as operatornumber,", new Object[0]);
        sql.append("fclienttype as clienttype,", new Object[0]);
        sql.append("fclientip as clientip", new Object[0]);
        sql.append(" from t_bdlog_log", new Object[0]);
        this.appendFilter(sql, reportQueryParam);
        sql.append("order by operatetime desc", new Object[0]);
        return DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.log, (SqlBuilder)sql);
    }

    private void appendFilter(SqlBuilder sql, ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        DynamicObject operateObj = filterInfo.getDynamicObject(FILTER_OPERATE_OBJ);
        DynamicObject operateType = filterInfo.getDynamicObject(FILTER_OPERATE_TYPE);
        String operateTypeNumber = operateType.getString(NUMBER);
        sql.append(" where foperattypenumber = ?", new Object[]{operateType.getString(NUMBER)});
        if (operateObj != null) {
            String operateObjName = operateObj.getLocaleString(NAME).getLocaleValue();
            sql.append(" and foperatobjname = ?", new Object[]{operateObjName});
        }
        Date startTime = filterInfo.getDate(FILTER_START_TIME);
        Date endTime = filterInfo.getDate(FILTER_END_TIME);
        DynamicObject operateOrg = filterInfo.getDynamicObject(FILTER_OPERATE_ORG);
        DynamicObjectCollection operatedOrgs = filterInfo.getDynamicObjectCollection(FILTER_OPERATED_ORG);
        DynamicObjectCollection operatedDatas = filterInfo.getDynamicObjectCollection(FILTER_OPERATE_DATA);
        if (operateOrg != null) {
            Long operateOrgId = (Long)operateOrg.getPkValue();
            sql.append(" and foperatorgid = ?", new Object[]{operateOrgId});
        }
        if (startTime != null) {
            sql.append(" and foperattime > ?", new Object[]{startTime});
        }
        if (endTime != null) {
            sql.append(" and foperattime < ?", new Object[]{endTime});
        }
        if (CollectionUtils.isNotEmpty((Collection)operatedOrgs)) {
            List<Object> orgNumbers = this.getFieldListByCol(operatedOrgs, NUMBER);
            if (OP_TYPE_ORG_PERM_CHANGE.equals(operateTypeNumber)) {
                sql.append(" and fid in (select fid from t_bdlog_dataentry where", new Object[0]);
                sql.appendIn(" fnewcreateorgnumber", orgNumbers);
            } else {
                sql.append(" and fid in (select fid from t_bdlog_orgentry where", new Object[0]);
                sql.appendIn(" forgnumber", orgNumbers);
            }
            sql.append(")", new Object[0]);
        }
        if (CollectionUtils.isNotEmpty((Collection)operatedDatas)) {
            List<Object> numberList = this.getFieldListByCol(operatedDatas, NUMBER);
            sql.append(" and fid in (select fid from t_bdlog_dataentry where", new Object[0]);
            sql.appendIn(" fdatanumber", numberList);
            sql.append(")", new Object[0]);
        }
    }

    private List<Object> getFieldListByCol(DynamicObjectCollection doc, String fieldName) {
        ArrayList<Object> result = new ArrayList<Object>(10);
        for (DynamicObject obj : doc) {
            Object fieldValue = obj.get(fieldName);
            result.add(fieldValue);
        }
        return result;
    }
}

