/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdlog;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BDLogReportFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(BDLogReportFormPlugin.class);
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String CONTROL_REPORT_LIST = "reportlistap";
    private static final String FILTER_OPERATE_DATA = "operateddatas";
    private static final String FILTER_OPERATE_TYPE = "operattype";
    private static final String FILTER_OPERATE_OBJ = "operatobj";
    private static final String FILTER_OPERATED_ORG = "operatedorgs";
    private static final String CACHE_ENTITY_ID = "entityId";
    private static final String OP_TYPE_INDIVIDUATION = "individuation";
    private static final String OP_TYPE_BD_CTRL_CHANGE = "bdctrlchange";
    private static final String OP_TYPE_SET_CTRL_UNIT = "setctrlunit";
    private static final String OP_TYPE_CANCEL_CTRL_UNIT = "cancelctrlunit";

    public void registerListener(EventObject e) {
        ReportList reportList = (ReportList)this.getControl(CONTROL_REPORT_LIST);
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        MulBasedataEdit mulbasedatafield = (MulBasedataEdit)this.getControl(FILTER_OPERATE_DATA);
        mulbasedatafield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String operateTypeNumber;
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject operateType = filterInfo.getDynamicObject(FILTER_OPERATE_TYPE);
        if (operateType != null && (OP_TYPE_SET_CTRL_UNIT.equals(operateTypeNumber = operateType.getString(NUMBER)) || OP_TYPE_CANCEL_CTRL_UNIT.equals(operateTypeNumber))) {
            return true;
        }
        if (operateType == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u64cd\u4f5c\u7c7b\u578b\u201d\u3002", (String)"BDLogReportFormPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject operateObj = filterInfo.getDynamicObject(FILTER_OPERATE_OBJ);
        if (operateObj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u64cd\u4f5c\u5bf9\u8c61\u201d\u3002", (String)"BDLogReportFormPlugin_1", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (NUMBER.equals(fieldName)) {
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId("bd_log");
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bsp.setBillStatus(BillOperationStatus.VIEW);
            bsp.setStatus(OperationStatus.VIEW);
            bsp.setPkId(hyperLinkClickEvent.getRowData().get(ID));
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject operateObjType = (DynamicObject)this.getModel().getValue(FILTER_OPERATE_OBJ);
        if (operateObjType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u64cd\u4f5c\u5bf9\u8c61\u201d\u3002", (String)"BDLogReportFormPlugin_1", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        String filterName = evt.getProperty().getName();
        if (FILTER_OPERATE_DATA.equals(filterName)) {
            ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
            String entityId = operateObjType.getString(NUMBER);
            lsp.setBillFormId(entityId);
            String f7ListFormId = FormMetadataCache.getListFormConfig((String)entityId).getF7ListFormId();
            lsp.setFormId(f7ListFormId);
            List qFilters = lsp.getListFilterParameter().getQFilters();
            String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
            qFilters.add(QFilter.of((String)("id = " + masterIdPropName), (Object[])new Object[0]));
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType mainType;
        String entityId = this.getView().getPageCache().get(CACHE_ENTITY_ID);
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            return;
        }
        MainEntityType baseType = EntityMetadataCache.getDataEntityType((String)entityId);
        try {
            mainType = (MainEntityType)e.getOriginalEntityType().clone();
        }
        catch (CloneNotSupportedException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
            return;
        }
        MulBasedataProp baseProp = (MulBasedataProp)mainType.findProperty(FILTER_OPERATE_DATA);
        baseProp.setBaseEntityId(baseType.getName());
        BasedataProp bp = (BasedataProp)baseProp.getRefBaseProp();
        bp.setComplexType((IDataEntityType)baseType);
        bp.setBaseEntityId(baseType.getName());
        DynamicSimpleProperty refIdProp = (DynamicSimpleProperty)mainType.findProperty(baseProp.getRefIdProp().getName());
        mainType.getProperties().remove((Object)refIdProp);
        refIdProp = bp.createRefIDProp();
        refIdProp.setPrimaryKey(false);
        if (kd.bos.orm.util.StringUtils.isEmpty((Object)bp.getAlias())) {
            refIdProp.setDbIgnore(true);
        } else {
            refIdProp.setAlias(bp.getAlias());
            refIdProp.setTableGroup(bp.getTableGroup());
        }
        refIdProp.setName(bp.getName() + "_id");
        mainType.addProperty((DynamicProperty)refIdProp);
        bp.setRefIdPropName(baseProp.getName() + "_id");
        bp.setRefIdProp((IDataEntityProperty)refIdProp);
        e.setNewEntityType(mainType);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        if (FILTER_OPERATE_OBJ.equals(fieldName)) {
            this.getView().getModel().setValue(FILTER_OPERATE_DATA, null);
            DynamicObject operateObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (operateObj == null) {
                return;
            }
            String entityId = operateObj.getString(NUMBER);
            this.getView().getPageCache().put(CACHE_ENTITY_ID, entityId);
        } else if (FILTER_OPERATE_TYPE.equals(fieldName)) {
            DynamicObject operateType = (DynamicObject)this.getModel().getValue(FILTER_OPERATE_TYPE);
            if (operateType == null) {
                return;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FILTER_OPERATE_OBJ, FILTER_OPERATED_ORG, FILTER_OPERATE_DATA});
            String operateTypeNumber = operateType.getString(NUMBER);
            if (OP_TYPE_BD_CTRL_CHANGE.equals(operateTypeNumber) || OP_TYPE_INDIVIDUATION.equals(operateTypeNumber)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FILTER_OPERATED_ORG});
            } else if (OP_TYPE_SET_CTRL_UNIT.equals(operateTypeNumber) || OP_TYPE_CANCEL_CTRL_UNIT.equals(operateTypeNumber)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FILTER_OPERATE_OBJ, FILTER_OPERATE_DATA});
                this.getModel().setValue(FILTER_OPERATE_OBJ, null);
            }
        }
    }
}

