/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.assistant.validator.AssistantValidator;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;

public class AssistantDeleteOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("parent");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("isleaf");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AssistantDeleteValidator());
    }

    private static class AssistantDeleteValidator
    extends AssistantValidator {
        private static final String ASSISTANT_DATA_ENTITYID = "bos_assistantdata_detail";
        private static final String SYSTEM = "bos-bd-opplugin";
        private static final String PROP_CREATEORG_ID = "createorg.id";
        private static final String PROP_PARENT_ID = "parent.id";
        private static final String PROP_IS_LEAF = "isleaf";
        private Map<Object, BaseDataCheckRefrenceResult> refrenceResult = new HashMap<Object, BaseDataCheckRefrenceResult>(16);

        private AssistantDeleteValidator() {
        }

        @Override
        public void validate() {
            super.validate();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (dataEntities == null || dataEntities.length == 0) {
                return;
            }
            this.refrenceResult = BaseDataRefrenceHelper.checkRefrenced((String)ASSISTANT_DATA_ENTITYID, (Object[])this.dataMap.keySet().toArray(new Long[0]), Collections.singletonList(ASSISTANT_DATA_ENTITYID), null, (OperateOption)OperateOption.create());
            for (Map.Entry entry : this.dataMap.entrySet()) {
                Long dataId = (Long)entry.getKey();
                DynamicObject obj = ((ExtendedDataEntity)entry.getValue()).getDataEntity();
                if (obj.getBoolean(PROP_IS_LEAF)) {
                    this.recursionParents(dataId, false);
                    continue;
                }
                List children = (List)this.parentChildrenMap.get(dataId);
                Set childIds = children.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
                if (this.dataMap.keySet().containsAll(childIds)) continue;
                this.recursionParents(dataId, true);
            }
            for (Map.Entry failedDetail : this.failedDetails.entrySet()) {
                Long failedDataId = (Long)failedDetail.getKey();
                this.addErrorMessage((ExtendedDataEntity)this.dataMap.get(failedDataId), (String)failedDetail.getValue());
            }
        }

        private void recursionParents(Long dataId, boolean childFail) {
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)this.dataMap.get(dataId);
            DynamicObject obj = dataEntity.getDataEntity();
            long parentId = obj.getLong(PROP_PARENT_ID);
            if (childFail) {
                String msg = ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u7ea7\u8d44\u6599\u4e0d\u80fd\u5220\u9664\u3002", (String)"AssistantDeleteValidator_0", (String)SYSTEM, (Object[])new Object[0]);
                this.failedDetails.put(dataId, msg);
            } else if (!this.dataMap.containsKey(dataId)) {
                childFail = true;
            } else if (this.failedDetails.containsKey(dataId)) {
                childFail = true;
            } else if (this.refrenceResult.containsKey(dataId) && this.refrenceResult.get(dataId).isRefence()) {
                BaseDataRefenceKey refenceKey = this.refrenceResult.get(dataId).getRefenceKey();
                String refEntityKey = refenceKey.getRefEntityKey();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)refEntityKey);
                String entityName = dataEntityType.getDisplayName().getLocaleValue();
                String msg = ResManager.loadKDString((String)"\u5df2\u88ab\u201d%s\u201c\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AssistantDeleteValidator_2", (String)SYSTEM, (Object[])new Object[0]);
                this.failedDetails.put(dataId, String.format(msg, entityName));
                childFail = true;
            }
            if (this.dataMap.containsKey(parentId)) {
                this.recursionParents(parentId, childFail);
            }
        }

        @Override
        protected String getPermId() {
            return "4715e1f1000000ac";
        }
    }
}

