/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.List;
import java.util.Map;
import kd.bd.assistant.validator.AssistantValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;

public class AssistantDisableOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String ASSISTANT_DATA_ENTITYID = "bos_assistantdata_detail";
    private static final String PROP_ENABLE = "enable";
    private static final String PROP_MODIFY_TIME = "modifytime";
    private static final String PROP_MODIFIER = "modifier";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("parent");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("isleaf");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AssistantDisableValidator());
    }

    private static class AssistantDisableValidator
    extends AssistantValidator {
        private static final String SYSTEM = "bos-bd-opplugin";
        private static final String PROP_PARENT_ID = "parent.id";
        private static final String PROP_IS_LEAF = "isleaf";

        private AssistantDisableValidator() {
        }

        @Override
        public void validate() {
            super.validate();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (dataEntities == null || dataEntities.length == 0) {
                return;
            }
            for (Map.Entry entry : this.dataMap.entrySet()) {
                Long dataId = (Long)entry.getKey();
                DynamicObject obj = ((ExtendedDataEntity)entry.getValue()).getDataEntity();
                if (obj.getBoolean(PROP_IS_LEAF)) {
                    this.recursionParents(dataId, false);
                    continue;
                }
                List children = (List)this.parentChildrenMap.get(dataId);
                for (DynamicObject child : children) {
                    long childId = child.getLong("id");
                    boolean childEnable = child.getBoolean(AssistantDisableOpPlugin.PROP_ENABLE);
                    if (this.dataMap.containsKey(childId) || !childEnable) continue;
                    this.recursionParents(dataId, true);
                }
            }
            for (Map.Entry failedDetail : this.failedDetails.entrySet()) {
                Long failedDataId = (Long)failedDetail.getKey();
                this.addErrorMessage((ExtendedDataEntity)this.dataMap.get(failedDataId), (String)failedDetail.getValue());
            }
        }

        private void recursionParents(Long dataId, boolean childFail) {
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)this.dataMap.get(dataId);
            DynamicObject obj = dataEntity.getDataEntity();
            long parentId = obj.getLong(PROP_PARENT_ID);
            if (childFail) {
                String msg = ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u7ea7\u8d44\u6599\u4e0d\u80fd\u7981\u7528\u3002", (String)"AssistantDisableValidator_0", (String)SYSTEM, (Object[])new Object[0]);
                this.failedDetails.put(dataId, msg);
            } else if (!this.dataMap.containsKey(dataId)) {
                childFail = true;
            } else if (this.failedDetails.containsKey(dataId)) {
                childFail = true;
            }
            if (this.dataMap.containsKey(parentId)) {
                this.recursionParents(parentId, childFail);
            }
        }

        @Override
        protected String getPermId() {
            return "47160c2b000000ac";
        }
    }
}

