/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.HashSet;
import java.util.List;
import kd.bd.assistant.validator.AssistantValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;

public class AssistantEnableOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String SYSTEM = "bos-bd-opplugin";
    private static final String PROP_CREATEORG = "createorg";
    private static final String PROP_PARENT = "parent";
    private static final String PROP_ID = "id";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_ENABLE = "enable";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(PROP_PARENT);
        e.getFieldKeys().add(PROP_CREATEORG);
        e.getFieldKeys().add(PROP_ENABLE);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AssistantEnableValidator());
    }

    private static class AssistantEnableValidator
    extends AssistantValidator {
        private AssistantEnableValidator() {
        }

        @Override
        public void validate() {
            super.validate();
            if (this.dataEntities == null || this.dataEntities.length == 0) {
                return;
            }
            this.enableValidate();
        }

        private void enableValidate() {
            HashSet<Long> failedDataIds = new HashSet<Long>(16);
            HashSet errorDataIndexs = this.getValidateContext().getValidateResults().getErrorDataIndexs();
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject parent;
                DynamicObject dataObj;
                if (errorDataIndexs.contains(dataEntity.getDataEntityIndex()) || (dataObj = dataEntity.getDataEntity()).getBoolean(AssistantEnableOpPlugin.PROP_ENABLE)) continue;
                Long dataId = (Long)dataObj.getPkValue();
                if (this.isFormOperate && this.useOrgId != 0L) {
                    DynamicObject createOrg = dataObj.getDynamicObject(AssistantEnableOpPlugin.PROP_CREATEORG);
                    String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u662f\u8f85\u52a9\u8d44\u6599\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"AssistantEnableOpPlugin_0", (String)AssistantEnableOpPlugin.SYSTEM, (Object[])new Object[0]);
                    if (StringUtils.isNotEmpty((CharSequence)this.useOrgName) && (createOrg == null || this.useOrgId.longValue() != createOrg.getLong(AssistantEnableOpPlugin.PROP_ID))) {
                        this.addErrorMessage(dataEntity, String.format(msg, this.useOrgName));
                        failedDataIds.add(dataId);
                    }
                }
                if (this.failedDetails.containsKey(dataId)) {
                    this.addErrorMessage(dataEntity, (String)this.failedDetails.get(dataId));
                    failedDataIds.add(dataId);
                }
                if ((parent = dataObj.getDynamicObject(AssistantEnableOpPlugin.PROP_PARENT)) == null) continue;
                long parentId = parent.getLong(AssistantEnableOpPlugin.PROP_ID);
                List falseDataEntities = this.getFalseDataEntities();
                if (this.dataMap.containsKey(parentId) || parent.getBoolean(AssistantEnableOpPlugin.PROP_ENABLE) || falseDataEntities.contains(dataEntity)) continue;
                String msg = ResManager.loadKDString((String)"\u4e0a\u7ea7\u8d44\u6599\u201d%s\u201c\u672a\u542f\u7528\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"AssistantEnableOpPlugin_1", (String)AssistantEnableOpPlugin.SYSTEM, (Object[])new Object[0]);
                String parentNumber = parent.getString(AssistantEnableOpPlugin.PROP_NUMBER);
                this.addErrorMessage(dataEntity, String.format(msg, parentNumber));
                failedDataIds.add(dataId);
            }
            for (Long failedDataId : failedDataIds) {
                if (!this.parentChildrenMap.containsKey(failedDataId)) continue;
                this.recursionChildren(failedDataId);
            }
        }

        private void recursionChildren(Long parentId) {
            List children = (List)this.parentChildrenMap.get(parentId);
            ExtendedDataEntity parentEntity = (ExtendedDataEntity)this.dataMap.get(parentId);
            for (DynamicObject child : children) {
                Long childId = child.getLong(AssistantEnableOpPlugin.PROP_ID);
                if (!this.dataMap.containsKey(childId)) continue;
                ExtendedDataEntity childEntity = (ExtendedDataEntity)this.dataMap.get(childId);
                if (this.getFalseDataEntities().contains(childEntity)) continue;
                String parentNumber = parentEntity.getDataEntity().getString(AssistantEnableOpPlugin.PROP_NUMBER);
                String msg = ResManager.loadKDString((String)"\u4e0a\u7ea7\u8d44\u6599\u201d%s\u201c\u672a\u542f\u7528\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"AssistantEnableOpPlugin_1", (String)AssistantEnableOpPlugin.SYSTEM, (Object[])new Object[0]);
                this.addErrorMessage((ExtendedDataEntity)this.dataMap.get(childId), String.format(msg, parentNumber));
                if (!this.parentChildrenMap.containsKey(childId) || !this.dataMap.containsKey(childId)) continue;
                this.recursionChildren(childId);
            }
        }

        @Override
        protected String getPermId() {
            return "4730fc5d000000ac";
        }
    }
}

