/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class AssistantGroupValidator
extends AbstractOperationServicePlugIn {
    private static final String BOS_BD_OPP = "bos-bd-opplugin";
    private static final String ENTITY_ASSISTANT_GROUP = "bos_assistantdatagroup";
    private static final String PROP_CLOUD_NUMBER = "fbizcloudid.number";
    private static final String PROP_CLOUD_NAME = "fbizcloudid.name";
    private static final String PROP_GROUP_CONTROL = "isgroupcontrol";
    private static final String PROP_CTRL_VIEW = "ctrlview";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("name");
        fieldKeys.add("number");
        fieldKeys.add("ctrlstrategy");
        fieldKeys.add("createorg");
        fieldKeys.add(PROP_CTRL_VIEW);
        fieldKeys.add(PROP_GROUP_CONTROL);
        fieldKeys.add(PROP_CLOUD_NUMBER);
        fieldKeys.add(PROP_CLOUD_NAME);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AssistantGroupBaseValidator());
    }

    private static class View {
        private Long viewId;
        private Long rootOrgId;
        private Set<Long> orgIds = new HashSet<Long>(16);
        private Set<Long> disableOrgIds = new HashSet<Long>(1);

        private View(Long viewId) {
            this.viewId = viewId;
        }

        private static Map<Long, View> getView(Set<Object> orgIds, Set<Object> viewIds) {
            QFilter[] filters = new QFilter[]{new QFilter("view", "in", viewIds), new QFilter("org", "in", orgIds)};
            HashMap<Long, View> viewMap = new HashMap<Long, View>(16);
            try (DataSet ds = ORM.create().queryDataSet(View.class.getName(), "bos_org_structure", "view, parent, org, org.enable, isfreeze", filters);){
                for (Row row : ds) {
                    Long viewId = row.getLong("view");
                    View view = viewMap.computeIfAbsent(viewId, v -> new View(viewId));
                    Long orgId = row.getLong("org");
                    view.orgIds.add(orgId);
                    Long parentId = row.getLong("parent");
                    if (null == parentId || 0L == parentId) {
                        view.rootOrgId = orgId;
                    }
                    if (!row.getBoolean("isfreeze").booleanValue() && row.getBoolean("org.enable").booleanValue()) continue;
                    view.disableOrgIds.add(orgId);
                }
            }
            return viewMap;
        }
    }

    private static class AssistantGroupBaseValidator
    extends AbstractValidator {
        private AssistantGroupBaseValidator() {
        }

        public void validate() {
            HashMap<String, List<ExtendedDataEntity>> cloudTypeMap = new HashMap<String, List<ExtendedDataEntity>>(16);
            QFilter filter = this.preValidate(cloudTypeMap);
            if (cloudTypeMap.isEmpty()) {
                return;
            }
            LinkedHashSet<ExtendedDataEntity> entities = this.currentDataRepeatedValidate(cloudTypeMap);
            if (entities.isEmpty()) {
                return;
            }
            String selectProperties = "id,number,name,createorg,createorg.name,fbizcloudid.number,fbizcloudid.name,ctrlview,isgroupcontrol,ctrlstrategy";
            DynamicObjectCollection collection = QueryServiceHelper.query((String)AssistantGroupValidator.ENTITY_ASSISTANT_GROUP, (String)selectProperties, (QFilter[])new QFilter[]{filter});
            Map<String, List<DynamicObject>> groupAssistantGroupMap = collection.stream().collect(Collectors.groupingBy(e -> e.getString(AssistantGroupValidator.PROP_CLOUD_NUMBER)));
            HashMap<ExtendedDataEntity, DynamicObject> curr2OriginalDataMap = new HashMap<ExtendedDataEntity, DynamicObject>(entities.size());
            Iterator iterator = entities.iterator();
            while (iterator.hasNext()) {
                DynamicObject originalData;
                ExtendedDataEntity entity = (ExtendedDataEntity)iterator.next();
                iterator.remove();
                DynamicObject saveData = entity.getDataEntity();
                List<DynamicObject> dbTypeList = groupAssistantGroupMap.get(saveData.getString(AssistantGroupValidator.PROP_CLOUD_NUMBER));
                if (CollectionUtils.isEmpty(dbTypeList) || null == (originalData = this.localValidate(entity, saveData, dbTypeList))) continue;
                curr2OriginalDataMap.put(entity, originalData);
            }
            if (!curr2OriginalDataMap.isEmpty()) {
                this.hasAssistantValidate(curr2OriginalDataMap);
            }
        }

        private LinkedHashSet<ExtendedDataEntity> currentDataRepeatedValidate(Map<String, List<ExtendedDataEntity>> cloudTypeMap) {
            LinkedHashSet<ExtendedDataEntity> result = new LinkedHashSet<ExtendedDataEntity>(16);
            HashMap<ExtendedDataEntity, StringBuilder> errorMsg = new HashMap<ExtendedDataEntity, StringBuilder>(16);
            List<ExtendedDataEntity> numberPassDataList = this.filterRepeatedData(cloudTypeMap, errorMsg, "number");
            result.addAll(numberPassDataList);
            List<ExtendedDataEntity> namePassDataList = this.filterRepeatedData(cloudTypeMap, errorMsg, "name");
            result.addAll(namePassDataList);
            if (!errorMsg.isEmpty()) {
                errorMsg.forEach((key, value) -> this.addErrorMessage((ExtendedDataEntity)key, value.toString()));
                errorMsg.clear();
            }
            cloudTypeMap.clear();
            return result;
        }

        private List<ExtendedDataEntity> filterRepeatedData(Map<String, List<ExtendedDataEntity>> groupMapByCloud, Map<ExtendedDataEntity, StringBuilder> errorMsg, String prop) {
            ArrayList<ExtendedDataEntity> result = new ArrayList<ExtendedDataEntity>(10);
            for (List<ExtendedDataEntity> types : groupMapByCloud.values()) {
                if (types.size() == 1) {
                    result.addAll(types);
                    continue;
                }
                Map<String, List<ExtendedDataEntity>> groupMapByProp = types.stream().collect(Collectors.groupingBy(item -> item.getDataEntity().getString(prop)));
                for (Map.Entry<String, List<ExtendedDataEntity>> entry : groupMapByProp.entrySet()) {
                    List<ExtendedDataEntity> values = entry.getValue();
                    if (values.size() == 1) {
                        result.addAll(values);
                        continue;
                    }
                    String tip = "number".equals(prop) ? ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u201d%2$s\u201c\u5728\u201c%3$s\u201d\u4e0b\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6570\u636e\u3002", (String)"AssistantGroupValidator_0", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]) : ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u201d%2$s\u201c\u5728\u201c%3$s\u201d\u4e0b\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u6570\u636e\u3002", (String)"AssistantGroupValidator_1", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]);
                    Iterator<ExtendedDataEntity> iterator = values.iterator();
                    ExtendedDataEntity first = iterator.next();
                    result.add(first);
                    DynamicObject data = first.getDataEntity();
                    String orgName = data.getString("createorg.name");
                    String cloudName = data.getString(AssistantGroupValidator.PROP_CLOUD_NAME);
                    String key = entry.getKey();
                    while (iterator.hasNext()) {
                        ExtendedDataEntity dataEntity = iterator.next();
                        errorMsg.computeIfAbsent(dataEntity, v -> new StringBuilder()).append(String.format(tip, key, orgName, cloudName));
                        iterator.remove();
                    }
                }
            }
            return result;
        }

        private QFilter preValidate(Map<String, List<ExtendedDataEntity>> groupMapByCloud) {
            HashSet errorDataIndexes = this.getValidateContext().getValidateResults().getErrorDataIndexs();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            List dataIds = Arrays.stream(dataEntities).filter(data -> !errorDataIndexes.contains(data.getDataEntityIndex()) && data.getDataEntity().getDataEntityState().getFromDatabase()).mapToLong(value -> value.getDataEntity().getLong("id")).boxed().collect(Collectors.toList());
            HashMap<Long, String> cloudMap = new HashMap<Long, String>(16);
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
            try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), AssistantGroupValidator.ENTITY_ASSISTANT_GROUP, "id, fbizcloudid", filters);){
                ds.forEach(row -> cloudMap.put(row.getLong("id"), row.getString("fbizcloudid")));
            }
            HashSet<Object> orgIds = new HashSet<Object>(16);
            HashSet<Object> viewIds = new HashSet<Object>(16);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                if (errorDataIndexes.contains(dataEntity.getDataEntityIndex()) || this.isModifyBizCloudInfo(dataEntity, cloudMap) || !this.mustInputValidate(dataEntity)) continue;
                DynamicObject obj = dataEntity.getDataEntity();
                orgIds.add(obj.getDynamicObject("createorg").getPkValue());
                viewIds.add(obj.getDynamicObject(AssistantGroupValidator.PROP_CTRL_VIEW).getPkValue());
                groupMapByCloud.computeIfAbsent(obj.getString(AssistantGroupValidator.PROP_CLOUD_NUMBER), v -> new ArrayList(10)).add(dataEntity);
            }
            return this.businessValidate(groupMapByCloud, orgIds, viewIds);
        }

        private boolean isModifyBizCloudInfo(ExtendedDataEntity dataEntity, Map<Long, String> cloudMap) {
            Long pk;
            DynamicObject currData = dataEntity.getDataEntity();
            if (!currData.getDataEntityState().getFromDatabase()) {
                return false;
            }
            DynamicObject cloud = currData.getDynamicObject("fbizcloudid");
            String cloudId = null;
            if (null != cloud) {
                cloudId = (String)cloud.getPkValue();
            }
            if (!Objects.equals(cloudMap.get(pk = (Long)currData.getPkValue()), cloudId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u76f4\u63a5\u4fee\u6539\u201d\u4e1a\u52a1\u4e91\u201c\u3002", (String)"AssistantGroupValidator_16", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]));
                return true;
            }
            return false;
        }

        private boolean mustInputValidate(ExtendedDataEntity dataEntity) {
            DynamicObject obj = dataEntity.getDataEntity();
            String cloudNumber = obj.getString(AssistantGroupValidator.PROP_CLOUD_NUMBER);
            if (StringUtils.isEmpty((CharSequence)cloudNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201d\u4e1a\u52a1\u4e91\u201c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssistantGroupValidator_2", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]));
                return false;
            }
            String number = obj.getString("number");
            if (StringUtils.isEmpty((CharSequence)number)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201d\u7f16\u7801\u201c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssistantGroupValidator_3", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]));
                return false;
            }
            String name = obj.getString("name");
            if (StringUtils.isEmpty((CharSequence)name)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201d\u540d\u79f0\u201c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssistantGroupValidator_4", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)obj.getString("ctrlstrategy"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201d\u8f85\u52a9\u8d44\u6599\u7ba1\u63a7\u7b56\u7565\u201c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssistantGroupValidator_5", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]));
                return false;
            }
            DynamicObject ctrlView = obj.getDynamicObject(AssistantGroupValidator.PROP_CTRL_VIEW);
            if (StringUtils.isBlank((Object)ctrlView)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201d\u63a7\u5236\u89c6\u56fe\u201c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssistantGroupValidator_6", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]));
                return false;
            }
            DynamicObject createOrg = obj.getDynamicObject("createorg");
            if (StringUtils.isBlank((Object)createOrg)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201d\u521b\u5efa\u7ec4\u7ec7\u201c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssistantGroupValidator_7", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]));
                return false;
            }
            return true;
        }

        private QFilter businessValidate(Map<String, List<ExtendedDataEntity>> groupMapByCloud, Set<Object> orgIds, Set<Object> viewIds) {
            if (orgIds.isEmpty() || viewIds.isEmpty()) {
                return null;
            }
            Map viewMap = View.getView(orgIds, viewIds);
            HashSet<String> groupNumberSet = new HashSet<String>(16);
            HashSet<String> groupNameSet = new HashSet<String>(16);
            Iterator<Map.Entry<String, List<ExtendedDataEntity>>> iterator = groupMapByCloud.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<ExtendedDataEntity>> entry = iterator.next();
                List<ExtendedDataEntity> values = entry.getValue();
                Iterator<ExtendedDataEntity> it = values.iterator();
                while (it.hasNext()) {
                    boolean notRootOrg;
                    ExtendedDataEntity next = it.next();
                    DynamicObject data = next.getDataEntity();
                    DynamicObject viewData = data.getDynamicObject(AssistantGroupValidator.PROP_CTRL_VIEW);
                    Long viewId = (Long)viewData.getPkValue();
                    View view = (View)viewMap.get(viewId);
                    DynamicObject org = data.getDynamicObject("createorg");
                    Long orgId = (Long)org.getPkValue();
                    if (null == view || !view.orgIds.contains(orgId)) {
                        this.addErrorMessage(next, ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5728\u63a7\u5236\u89c6\u56fe\u5185\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AssistantGroupValidator_8", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]));
                        it.remove();
                        continue;
                    }
                    if (view.disableOrgIds.contains(orgId)) {
                        this.addErrorMessage(next, ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u5df2\u7ecf\u88ab\u7981\u7528\u6216\u8005\u5c01\u5b58\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AssistantGroupValidator_15", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]));
                        it.remove();
                        continue;
                    }
                    boolean isGroupCtrl = data.getBoolean(AssistantGroupValidator.PROP_GROUP_CONTROL);
                    boolean bl = notRootOrg = isGroupCtrl && (null == view.rootOrgId || !view.rootOrgId.equals(orgId));
                    if (notRootOrg) {
                        this.addErrorMessage(next, ResManager.loadKDString((String)"\u53ea\u6709\u89c6\u56fe\u6839\u7ec4\u7ec7\u624d\u53ef\u4ee5\u5f00\u542f\u96c6\u56e2\u7ba1\u63a7\u3002", (String)"AssistantGroupValidator_9", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]));
                        it.remove();
                        continue;
                    }
                    if (isGroupCtrl && "7".equals(data.getString("ctrlstrategy"))) {
                        this.addErrorMessage(next, ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565\u4e3a\u79c1\u6709\u7684\u7c7b\u522b\uff0c\u4e0d\u53ef\u4ee5\u5f00\u542f\u96c6\u56e2\u7ba1\u63a7\u3002", (String)"AssistantGroupValidator_10", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]));
                        it.remove();
                        continue;
                    }
                    groupNumberSet.add(data.getString("number"));
                    groupNameSet.add(data.getString("name"));
                }
                if (!values.isEmpty()) continue;
                iterator.remove();
            }
            QFilter filter = new QFilter("number", "in", groupNumberSet);
            filter.or(new QFilter("name", "in", groupNameSet));
            return new QFilter(AssistantGroupValidator.PROP_CLOUD_NUMBER, "in", new ArrayList<String>(groupMapByCloud.keySet())).and(filter);
        }

        private boolean dataRepeatedValidate(ExtendedDataEntity entity, DynamicObject saveData, DynamicObject dbData) {
            String targetName;
            String sourceName;
            String targetNumber;
            StringBuilder err = new StringBuilder();
            String createOrgName = dbData.getString("createorg.name");
            String cloudName = dbData.getString(AssistantGroupValidator.PROP_CLOUD_NAME);
            String sourceNumber = saveData.getString("number");
            if (sourceNumber.equals(targetNumber = dbData.getString("number"))) {
                err.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u201d%2$s\u201c\u5728\u201c%3$s\u201d\u4e0b\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6570\u636e\u3002", (String)"AssistantGroupValidator_0", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]), targetNumber, createOrgName, cloudName));
            }
            if ((sourceName = saveData.getString("name")).equals(targetName = dbData.getString("name"))) {
                err.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u201d%2$s\u201c\u5728\u201c%3$s\u201d\u4e0b\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u6570\u636e\u3002", (String)"AssistantGroupValidator_1", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]), targetName, createOrgName, cloudName));
            }
            if (StringUtils.isNotBlank((CharSequence)err.toString())) {
                this.addErrorMessage(entity, err.toString());
                return true;
            }
            return false;
        }

        private void hasAssistantValidate(Map<ExtendedDataEntity, DynamicObject> curr2OriginalDataMap) {
            Set<Long> groupIds = this.getExistAssistantGroupIds(curr2OriginalDataMap);
            ArrayList<ExtendedDataEntity> nextFilterDataList = new ArrayList<ExtendedDataEntity>(groupIds.size());
            Iterator<Map.Entry<ExtendedDataEntity, DynamicObject>> it = curr2OriginalDataMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ExtendedDataEntity, DynamicObject> entry = it.next();
                it.remove();
                ExtendedDataEntity dataEntity = entry.getKey();
                DynamicObject currData = dataEntity.getDataEntity();
                String number = currData.getString("number");
                DynamicObject originalData = entry.getValue();
                Long groupId = originalData.getLong("id");
                boolean hasAssistantData = groupIds.contains(groupId);
                if (hasAssistantData && this.isUpdateStrategy(currData, originalData)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5206\u7c7b\u4e0b\u6709\u8f85\u52a9\u8d44\u6599\u660e\u7ec6\uff0c\u4e0d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"AssistantGroupValidator_12", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]), number));
                    continue;
                }
                if (hasAssistantData && this.isUpdateView(currData, originalData)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5206\u7c7b\u4e0b\u6709\u8f85\u52a9\u8d44\u6599\u660e\u7ec6\uff0c\u4e0d\u80fd\u53d8\u66f4\u63a7\u5236\u89c6\u56fe\u3002", (String)"AssistantGroupValidator_13", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]), number));
                    continue;
                }
                if (!hasAssistantData || !this.isSetGroupCtrl(currData, originalData)) continue;
                nextFilterDataList.add(dataEntity);
            }
            if (!nextFilterDataList.isEmpty()) {
                this.setGroupCtrlValidate(nextFilterDataList);
            }
        }

        private Set<Long> getExistAssistantGroupIds(Map<ExtendedDataEntity, DynamicObject> curr2OriginalDataMap) {
            ArrayList groupIds = new ArrayList(curr2OriginalDataMap.size());
            curr2OriginalDataMap.values().forEach(e -> groupIds.add(e.getLong("id")));
            SqlBuilder builder = new SqlBuilder();
            builder.append("select fgroupid from t_bas_assistantdataentry where", new Object[0]).appendIn("fgroupid", groupIds.toArray()).append("group by fgroupid", new Object[0]);
            HashSet<Long> result = new HashSet<Long>(groupIds.size());
            try (DataSet ds = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)builder);){
                ds.forEach(row -> result.add(row.getLong("fgroupid")));
            }
            return result;
        }

        private DynamicObject localValidate(ExtendedDataEntity entity, DynamicObject saveData, List<DynamicObject> dbTypeList) {
            Object pkValue = saveData.getPkValue();
            DynamicObject originalData = null;
            boolean needVerifyAttribute = true;
            for (DynamicObject dbData : dbTypeList) {
                if (pkValue.equals(dbData.getLong("id"))) {
                    originalData = dbData;
                    continue;
                }
                if (!this.dataRepeatedValidate(entity, saveData, dbData)) continue;
                needVerifyAttribute = false;
                break;
            }
            if (!needVerifyAttribute || null == originalData) {
                return null;
            }
            DynamicObject currOrg = saveData.getDynamicObject("createorg");
            if (!Objects.equals(currOrg.getPkValue(), originalData.get("createorg"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4e0d\u80fd\u76f4\u63a5\u4fee\u6539\u8f85\u52a9\u8d44\u6599\u5206\u7c7b\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u8bf7\u5728\u5217\u8868\u754c\u9762\u901a\u8fc7\u201c\u7ba1\u7406\u6743\u8f6c\u8ba9\u201d\u53d8\u66f4\u3002", (String)"AssistantGroupValidator_11", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]));
                return null;
            }
            boolean updateStrategy = this.isUpdateStrategy(saveData, originalData);
            boolean setGroupCtrl = this.isSetGroupCtrl(saveData, originalData);
            boolean updateView = this.isUpdateView(saveData, originalData);
            if (updateStrategy || setGroupCtrl || updateView) {
                return originalData;
            }
            return null;
        }

        private boolean isUpdateStrategy(DynamicObject currData, DynamicObject originalData) {
            return !Objects.equals(currData.getString("ctrlstrategy"), originalData.getString("ctrlstrategy"));
        }

        private boolean isSetGroupCtrl(DynamicObject currData, DynamicObject originalData) {
            boolean istSetGroupCtrl = currData.getBoolean(AssistantGroupValidator.PROP_GROUP_CONTROL);
            return istSetGroupCtrl && !Objects.equals(currData.getString(AssistantGroupValidator.PROP_GROUP_CONTROL), originalData.getString(AssistantGroupValidator.PROP_GROUP_CONTROL));
        }

        private boolean isUpdateView(DynamicObject currData, DynamicObject originalData) {
            DynamicObject currView = currData.getDynamicObject(AssistantGroupValidator.PROP_CTRL_VIEW);
            return !Objects.equals(currView.getPkValue(), originalData.get(AssistantGroupValidator.PROP_CTRL_VIEW));
        }

        private void setGroupCtrlValidate(List<ExtendedDataEntity> entities) {
            ArrayList groupIds = new ArrayList(entities.size());
            entities.forEach(e -> groupIds.add(e.getDataEntity().getLong("id")));
            SqlBuilder builder = new SqlBuilder();
            builder.append("select fgroupid, fcreateorgid from t_bas_assistantdataentry where", new Object[0]).appendIn("fgroupid", groupIds.toArray()).append("group by fgroupid, fcreateorgid", new Object[0]);
            HashMap groupOrgMap = new HashMap(groupIds.size());
            try (DataSet ds = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)builder);){
                ds.forEach(e -> groupOrgMap.computeIfAbsent(e.getLong("fgroupid"), v -> new HashSet(16)).add(e.getLong("fcreateorgid")));
            }
            for (ExtendedDataEntity entity : entities) {
                DynamicObject currData = entity.getDataEntity();
                Long groupId = (Long)currData.getPkValue();
                Set createOrgIds = (Set)groupOrgMap.get(groupId);
                if (CollectionUtils.isEmpty((Collection)createOrgIds)) continue;
                Long createOrgId = (Long)currData.getDynamicObject("createorg").getPkValue();
                boolean disableSetGroupCtrl = createOrgIds.size() > 1 || createOrgIds.size() == 1 && !createOrgIds.contains(createOrgId);
                if (!disableSetGroupCtrl) continue;
                String number = currData.getString("number");
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5206\u7c7b\u4e0b\u6709\u975e\u96c6\u56e2\u521b\u5efa\u7684\u8f85\u52a9\u8d44\u6599\u660e\u7ec6\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u96c6\u56e2\u7ba1\u63a7\u3002", (String)"AssistantGroupValidator_14", (String)AssistantGroupValidator.BOS_BD_OPP, (Object[])new Object[0]), number));
            }
        }
    }
}

