/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class AssistantSaveValidator
extends AbstractValidator {
    private static final String SYSTEM_TYPE = "bos-bd-opplugin";
    private static final String ASSISTANT_ENTITY = "bos_assistantdata_detail";
    private static final String PROP_GROUP_ID = "group.id";
    private static final String PROP_CTRL_VIEW = "ctrlview";
    private static final String PROP_CREATE_ORG_ID = "createorg.id";
    public static final String PROP_GROUP_NUMBER = "group";
    private boolean noValidateName = false;
    private String dlm;

    public AssistantSaveValidator() {
        Object billParameter = SystemParamServiceHelper.getBillParameter((String)ASSISTANT_ENTITY, (String)"assistantnamevalidator");
        if (StringUtils.isNotBlank((Object)billParameter)) {
            this.noValidateName = (Boolean)billParameter;
        }
        this.dlm = AssistantSaveValidator.getLongNumberDLM(ASSISTANT_ENTITY);
    }

    public static String getLongNumberDLM(String entity) {
        return BaseDataCommonService.getLongNumberDLM((String)entity);
    }

    public void validate() {
        HashSet<Object> orgIds = new HashSet<Object>(16);
        HashSet<Object> viewIds = new HashSet<Object>(16);
        List<TypeItem> typeItems = this.preVerification(orgIds, viewIds);
        this.orgLegalVerification(typeItems, orgIds, viewIds);
        this.repeatedDataVerification(typeItems);
        this.parentCorrectnessVerification(typeItems);
    }

    private List<TypeItem> preVerification(Set<Object> orgIds, Set<Object> viewIds) {
        Map<Long, DisableModifyProp> propMap = this.getModifyProp();
        HashSet errorDataIndexes = this.getValidateContext().getValidateResults().getErrorDataIndexs();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        LinkedHashMap<Object, TypeItem> map = new LinkedHashMap<Object, TypeItem>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (errorDataIndexes.contains(dataEntity.getDataEntityIndex()) || !this.mustInputVerification(dataEntity) || !this.propEnableModifyVerification(dataEntity, propMap)) continue;
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject group = data.getDynamicObject(PROP_GROUP_NUMBER);
            map.computeIfAbsent(group.getPkValue(), k -> new TypeItem(group, dataEntity)).dataEntities.add(dataEntity);
            orgIds.add(data.getDynamicObject("createorg").getPkValue());
            viewIds.add(group.getDynamicObject(PROP_CTRL_VIEW).getPkValue());
        }
        return new ArrayList<TypeItem>(map.values());
    }

    private Map<Long, DisableModifyProp> getModifyProp() {
        HashSet errorDataIndexes = this.getValidateContext().getValidateResults().getErrorDataIndexs();
        List dataIds = Arrays.stream(this.getDataEntities()).filter(data -> !errorDataIndexes.contains(data.getDataEntityIndex()) && data.getDataEntity().getDataEntityState().getFromDatabase()).mapToLong(value -> value.getDataEntity().getLong("id")).boxed().collect(Collectors.toList());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        HashMap<Long, DisableModifyProp> propMap = new HashMap<Long, DisableModifyProp>(16);
        try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), ASSISTANT_ENTITY, "id, createorg, enable, group", filters);){
            ds.forEach(row -> {
                DisableModifyProp prop = new DisableModifyProp(row.getLong("createorg"), row.getBoolean("enable"), row.getLong(PROP_GROUP_NUMBER));
                propMap.put(row.getLong("id"), prop);
            });
        }
        return propMap;
    }

    private boolean propEnableModifyVerification(ExtendedDataEntity dataEntity, Map<Long, DisableModifyProp> propMap) {
        DynamicObject currData = dataEntity.getDataEntity();
        if (!currData.getDataEntityState().getFromDatabase()) {
            return true;
        }
        Long pk = (Long)currData.getPkValue();
        DisableModifyProp prop = propMap.get(pk);
        if (null == prop) {
            return true;
        }
        DynamicObject org = currData.getDynamicObject("createorg");
        Long orgId = 0L;
        if (null != org) {
            orgId = (Long)org.getPkValue();
        }
        if (!Objects.equals(orgId, prop.orgId)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u8f85\u52a9\u8d44\u6599\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u8bf7\u5728\u5217\u8868\u754c\u9762\u901a\u8fc7\u201c\u7ba1\u7406\u6743\u8f6c\u8ba9\u201d\u53d8\u66f4\u3002", (String)"AssistantSaveValidator_19", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject group = currData.getDynamicObject(PROP_GROUP_NUMBER);
        Long groupId = 0L;
        if (null != group) {
            groupId = (Long)group.getPkValue();
        }
        if (!Objects.equals(groupId, prop.groupId)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u8f85\u52a9\u8d44\u6599\u7c7b\u522b\u4fe1\u606f\u3002", (String)"AssistantSaveValidator_20", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (currData.getBoolean("enable") != prop.enable) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u8f85\u52a9\u8d44\u6599\u7684\u4f7f\u7528\u72b6\u6001\uff0c\u8bf7\u901a\u8fc7\u542f\u7528\u6216\u7981\u7528\u64cd\u4f5c\u66f4\u65b0\u6570\u636e\u4f7f\u7528\u72b6\u6001\u3002", (String)"AssistantSaveValidator_21", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean mustInputVerification(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        String number = data.getString("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201d\u7f16\u7801\u201c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssistantSaveValidator_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        String name = data.getString("name");
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201d\u540d\u79f0\u201c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssistantSaveValidator_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject createOrg = data.getDynamicObject("createorg");
        if (StringUtils.isBlank((Object)createOrg)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201d\u521b\u5efa\u7ec4\u7ec7\u201c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssistantSaveValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject group = data.getDynamicObject(PROP_GROUP_NUMBER);
        if (StringUtils.isBlank((Object)group)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201d\u7c7b\u522b\u201c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssistantSaveValidator_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject view = group.getDynamicObject(PROP_CTRL_VIEW);
        if (StringUtils.isBlank((Object)view)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201d\u7c7b\u522b\u89c6\u56fe\u201c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssistantSaveValidator_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject typeOrg = group.getDynamicObject("createorg");
        if (StringUtils.isBlank((Object)typeOrg)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201d\u7c7b\u522b\u521b\u5efa\u7ec4\u7ec7\u201c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssistantSaveValidator_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)this.dlm) && number.contains(this.dlm)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u201c%s\u201d\u3002", (String)"AssistantSaveValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), this.dlm));
            return false;
        }
        DynamicObject parent = data.getDynamicObject("parent");
        if (null != parent && !Objects.equals(parent.get(PROP_GROUP_ID), data.get(PROP_GROUP_ID))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u7684\u7c7b\u522b\u4e0e\u5176\u4e0a\u7ea7\u8f85\u52a9\u8d44\u6599\u7c7b\u522b\u4e0d\u4e00\u81f4\u3002", (String)"AssistantSaveValidator_22", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        boolean isUpdate = data.getDataEntityState().getFromDatabase();
        if (!isUpdate && null != parent && !parent.getBoolean("enable")) {
            String parentNumber = parent.getString("number");
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e0a\u7ea7\u8f85\u52a9\u8d44\u6599\u201d%s\u201c\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"AssistantSaveValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), parentNumber));
            return false;
        }
        return true;
    }

    private void orgLegalVerification(List<TypeItem> typeItems, Set<Object> orgIds, Set<Object> viewIds) {
        if (orgIds.isEmpty() || viewIds.isEmpty()) {
            return;
        }
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(16);
        Map viewMap = View.getView(orgIds, viewIds);
        Iterator<TypeItem> it = typeItems.iterator();
        while (it.hasNext()) {
            TypeItem item = it.next();
            View view = (View)viewMap.get(item.viewId);
            Iterator iterator = item.dataEntities.iterator();
            while (iterator.hasNext()) {
                boolean notRootOrg;
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)iterator.next();
                DynamicObject data = dataEntity.getDataEntity();
                Long orgId = (Long)data.getDynamicObject("createorg").getPkValue();
                if (null == view || !view.orgIds.contains(orgId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5728\u63a7\u5236\u89c6\u56fe\u5185\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AssistantSaveValidator_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    iterator.remove();
                    continue;
                }
                if (view.disableOrgIds.contains(orgId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u5df2\u7ecf\u88ab\u7981\u7528\u6216\u8005\u5c01\u5b58\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AssistantSaveValidator_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    iterator.remove();
                    continue;
                }
                boolean bl = notRootOrg = item.groupControl && (null == view.rootOrgId || !view.rootOrgId.equals(orgId));
                if (notRootOrg) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7c7b\u522b\u201d%1$s\u201c\u5f00\u542f\u4e86\u96c6\u56e2\u7ba1\u63a7\uff0c\u8be5\u7c7b\u522b\u4e0b\u7684\u8f85\u52a9\u8d44\u6599\u53ea\u80fd\u7531\u201c%2$s\u201d\u7ec4\u7ec7\u521b\u5efa\u3002", (String)"AssistantSaveValidator_16", (String)SYSTEM_TYPE, (Object[])new Object[0]), item.type.getString("number"), view.getRootName(item.viewId)));
                    iterator.remove();
                }
                if (item.createOrgId.equals(orgId)) continue;
                item.nextValidateEntities.add(dataEntity);
                viewOrgMap.computeIfAbsent(item.viewId, v -> new HashSet(16)).add(item.createOrgId);
            }
            if (!item.dataEntities.isEmpty()) continue;
            it.remove();
        }
        this.orgCompensateVerification(typeItems, viewOrgMap);
    }

    private void orgCompensateVerification(List<TypeItem> typeItems, Map<Long, Set<Long>> viewOrgMap) {
        if (viewOrgMap.isEmpty() || typeItems.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, Set<Long>> entry : viewOrgMap.entrySet()) {
            Long viewId = entry.getKey();
            Map subordinateOrgMap = OrgUnitServiceHelper.getAllSubordinateOrgMap((long)viewId, new ArrayList(entry.getValue()), (boolean)false);
            Iterator<TypeItem> it = typeItems.iterator();
            while (it.hasNext()) {
                TypeItem item = it.next();
                if (item.nextValidateEntities.isEmpty() || !item.viewId.equals(viewId)) continue;
                List subOrgIds = (List)subordinateOrgMap.get(item.createOrgId);
                boolean isEmpty = CollectionUtils.isEmpty((Collection)subOrgIds);
                Iterator iterator = item.nextValidateEntities.iterator();
                while (iterator.hasNext()) {
                    ExtendedDataEntity dataEntity = (ExtendedDataEntity)iterator.next();
                    iterator.remove();
                    DynamicObject data = dataEntity.getDataEntity();
                    Long orgId = (Long)data.getDynamicObject("createorg").getPkValue();
                    if (!isEmpty && subOrgIds.contains(orgId)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u7684\u521b\u5efa\u7ec4\u7ec7\u4e0e\u7c7b\u522b\u7684\u521b\u5efa\u7ec4\u7ec7\u4e0d\u76f8\u7b49\uff0c\u540c\u65f6\u4e5f\u4e0d\u662f\u7c7b\u522b\u521b\u5efa\u7ec4\u7ec7\u7684\u4e0b\u7ea7\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AssistantSaveValidator_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    item.dataEntities.remove(dataEntity);
                }
                if (!item.dataEntities.isEmpty()) continue;
                it.remove();
            }
        }
    }

    private void repeatedDataVerification(List<TypeItem> typeItems) {
        if (typeItems.isEmpty()) {
            return;
        }
        Iterator<TypeItem> iterator = typeItems.iterator();
        while (iterator.hasNext()) {
            TypeItem typeItem = iterator.next();
            if (typeItem.dataEntities.size() <= 1) continue;
            this.repeatedVerificationOnProp(typeItem, "number");
            if (!this.noValidateName) {
                this.repeatedVerificationOnProp(typeItem, "name");
            }
            if (!typeItem.dataEntities.isEmpty()) continue;
            iterator.remove();
        }
        if (!typeItems.isEmpty()) {
            this.repeatedVerificationFromDb(typeItems);
        }
    }

    private void repeatedVerificationFromDb(List<TypeItem> typeItems) {
        String selectFields = "id,number,name,enable,createorg.id,createorg.name,group.id,group.ctrlstrategy";
        QFilter[] filters = this.getAssistantFilter(typeItems);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ASSISTANT_ENTITY, (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        Map<Long, List<DynamicObject>> dbTypeAssistantMap = collection.stream().collect(Collectors.groupingBy(e -> e.getLong(PROP_GROUP_ID)));
        Iterator<TypeItem> iterator = typeItems.iterator();
        while (iterator.hasNext()) {
            TypeItem typeItem = iterator.next();
            List<DynamicObject> assistants = dbTypeAssistantMap.get(typeItem.type.getLong("id"));
            if (CollectionUtils.isEmpty(assistants)) continue;
            this.dataRepeatedValidate(typeItem, assistants, "number");
            if (!this.noValidateName && !typeItem.dataEntities.isEmpty()) {
                this.dataRepeatedValidate(typeItem, assistants, "name");
            }
            if (!typeItem.dataEntities.isEmpty()) continue;
            iterator.remove();
        }
    }

    private void dataRepeatedValidate(TypeItem typeItem, List<DynamicObject> assistants, String prop) {
        Map<String, List<DynamicObject>> propDataMap = assistants.stream().collect(Collectors.groupingBy(e -> e.getString(prop)));
        boolean isPrivateStrategy = "7".equals(typeItem.strategy);
        Iterator it = typeItem.dataEntities.iterator();
        while (it.hasNext()) {
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)it.next();
            DynamicObject currData = dataEntity.getDataEntity();
            String propValue = currData.getString(prop);
            List<DynamicObject> dbAssistants = propDataMap.get(propValue);
            if (CollectionUtils.isEmpty(dbAssistants)) continue;
            Object pkValue = currData.getPkValue();
            Long orgId = currData.getLong(PROP_CREATE_ORG_ID);
            if (!isPrivateStrategy) {
                if (dbAssistants.size() <= 1 && Objects.equals(pkValue, dbAssistants.get(0).getLong("id"))) continue;
                String orgName = dbAssistants.get(0).getString("createorg.name");
                this.addErrorMessage(dataEntity, String.format(this.getRepeatedTip(prop), propValue, orgName));
                it.remove();
                continue;
            }
            Map<Long, List<DynamicObject>> orgDataMap = dbAssistants.stream().collect(Collectors.groupingBy(e -> e.getLong(PROP_CREATE_ORG_ID)));
            List<DynamicObject> dataList = orgDataMap.get(orgId);
            if (CollectionUtils.isEmpty(dataList) || dataList.size() <= 1 && Objects.equals(pkValue, dataList.get(0).getLong("id"))) continue;
            String orgName = currData.getString("createorg.name");
            this.addErrorMessage(dataEntity, String.format(this.getRepeatedTip(prop), propValue, orgName));
            it.remove();
        }
    }

    private String getRepeatedTip(String prop) {
        if ("number".equals(prop)) {
            return ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u201c%2$s\u201d\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6570\u636e\u3002", (String)"AssistantSaveValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u201c%2$s\u201d\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u6570\u636e\uff0c\u5982\u9700\u65b0\u589e\u540c\u540d\u7684\u6570\u636e\uff0c\u8bf7\u5f00\u542f\u5355\u636e\u53c2\u6570\uff1a\u8f85\u52a9\u8d44\u6599\u540d\u79f0\u5141\u8bb8\u91cd\u590d\uff08\u201c\u5355\u636e\u53c2\u6570\u201d\u5de6\u6811\u9009\u62e9\u3010\u57fa\u7840\u670d\u52a1\u4e91\u3011-\u3010\u4f01\u4e1a\u5efa\u6a21\u3011-\u3010\u8f85\u52a9\u8d44\u6599\u3011\uff09\u3002", (String)"AssistantSaveValidator_23", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    private QFilter[] getAssistantFilter(List<TypeItem> typeItems) {
        ArrayList<Long> groupIds = new ArrayList<Long>(typeItems.size());
        ArrayList numbers = new ArrayList(10);
        ArrayList names = new ArrayList(10);
        for (TypeItem item : typeItems) {
            groupIds.add((Long)item.type.getPkValue());
            item.dataEntities.forEach(e -> {
                DynamicObject data = e.getDataEntity();
                numbers.add(data.getString("number"));
                if (!this.noValidateName) {
                    names.add(data.getString("name"));
                }
            });
        }
        QFilter propFilter = new QFilter("number", "in", numbers);
        if (!this.noValidateName) {
            propFilter.or("name", "in", names);
        }
        QFilter groupFilter = new QFilter(PROP_GROUP_ID, "in", groupIds);
        return new QFilter[]{groupFilter, propFilter};
    }

    private void repeatedVerificationOnProp(TypeItem typeItem, String prop) {
        Map<String, List<ExtendedDataEntity>> groupMapByProp = typeItem.dataEntities.stream().collect(Collectors.groupingBy(i -> i.getDataEntity().getString(prop)));
        for (Map.Entry<String, List<ExtendedDataEntity>> entry : groupMapByProp.entrySet()) {
            List<ExtendedDataEntity> values = entry.getValue();
            if (values.size() == 1) continue;
            if (!"7".equals(typeItem.strategy)) {
                String orgName = values.get(0).getDataEntity().getString("createorg.name");
                this.addRepeatErrorMsg(typeItem, prop, entry.getKey(), values, orgName);
                continue;
            }
            Map<Long, List<ExtendedDataEntity>> orgEntityMap = values.stream().collect(Collectors.groupingBy(i -> i.getDataEntity().getLong(PROP_CREATE_ORG_ID)));
            for (List<ExtendedDataEntity> repeatedValues : orgEntityMap.values()) {
                if (repeatedValues.size() <= 1) continue;
                String orgName = repeatedValues.get(0).getDataEntity().getString("createorg.name");
                this.addRepeatErrorMsg(typeItem, prop, entry.getKey(), repeatedValues, orgName);
            }
        }
    }

    private void addRepeatErrorMsg(TypeItem typeItem, String prop, String propValue, List<ExtendedDataEntity> values, String orgName) {
        Iterator<ExtendedDataEntity> iterator = values.iterator();
        iterator.next();
        iterator.remove();
        String tip = this.getRepeatedTip(prop);
        while (iterator.hasNext()) {
            ExtendedDataEntity dataEntity = iterator.next();
            this.addErrorMessage(dataEntity, String.format(tip, propValue, orgName));
            iterator.remove();
            typeItem.dataEntities.remove(dataEntity);
        }
    }

    private void parentCorrectnessVerification(List<TypeItem> typeItems) {
        HashSet<ExtendedDataEntity> modifyDataColl = new HashSet<ExtendedDataEntity>(16);
        ArrayList newDataList = new ArrayList(10);
        Iterator<TypeItem> iterator = typeItems.iterator();
        while (iterator.hasNext()) {
            TypeItem typeItem = iterator.next();
            List<TreeNode> treeNodes = this.getTreeNodes(typeItem, modifyDataColl);
            if (!"5".equals(typeItem.strategy)) {
                this.orgConsistencyVerification(treeNodes, typeItem);
            }
            if (!treeNodes.isEmpty()) {
                newDataList.addAll(treeNodes.stream().filter(node -> null != ((TreeNode)node).parent).collect(Collectors.toList()));
            }
            iterator.remove();
        }
        if (typeItems.isEmpty()) {
            return;
        }
        Map<Long, Map<String, Set<Long>>> parentDataMap = this.getParentInfoFromDb(typeItems);
        for (TreeNode node2 : newDataList) {
            if (null == node2.parent || this.parentCorrectnessVerification(node2.parent, node2.curr, parentDataMap)) continue;
            this.addErrorMessage(node2.children);
        }
        for (ExtendedDataEntity entity : modifyDataColl) {
            DynamicObject parent = entity.getDataEntity().getDynamicObject("parent");
            if (null == parent) continue;
            this.parentCorrectnessVerification(parent, entity, parentDataMap);
        }
    }

    private boolean parentCorrectnessVerification(DynamicObject parent, ExtendedDataEntity entity, Map<Long, Map<String, Set<Long>>> parentDataMap) {
        Long createOrgId;
        DynamicObject curr = entity.getDataEntity();
        DynamicObject group = curr.getDynamicObject(PROP_GROUP_NUMBER);
        DynamicObject createOrg = curr.getDynamicObject("createorg");
        Map<String, Set<Long>> num2OrgMap = parentDataMap.get((Long)group.getPkValue());
        String orgNumber = createOrg.getString("number");
        String parentNumber = parent.getString("number");
        if (CollectionUtils.isEmpty(num2OrgMap) || CollectionUtils.isEmpty((Collection)num2OrgMap.get(parentNumber))) {
            String tip = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7ec4\u7ec7\u201c%1$s\u201d\u6ca1\u6709\u4e0a\u7ea7\u8d44\u6599\u201c%2$s\u201d\u7684\u4f7f\u7528\u6743\uff0c\u6216\u8005\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"AssistantSaveValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.addErrorMessage(entity, String.format(tip, orgNumber, parentNumber));
            return false;
        }
        Set<Long> orgIds = num2OrgMap.get(parentNumber);
        if (orgIds.contains(createOrgId = (Long)createOrg.getPkValue())) {
            return true;
        }
        DynamicObject parentCreateOrg = parent.getDynamicObject("createorg");
        if (null == parentCreateOrg) {
            String tip = ResManager.loadKDString((String)"\u4e0a\u7ea7\u8f85\u52a9\u8d44\u6599\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"AssistantSaveValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.addErrorMessage(entity, String.format(tip, orgNumber, parentNumber));
            return false;
        }
        String strategy = group.getString("ctrlstrategy");
        if ("5".equals(strategy)) {
            return true;
        }
        Long parentCreateOrgId = (Long)parentCreateOrg.getPkValue();
        if (orgIds.contains(parentCreateOrgId) || "7".equals(strategy)) {
            String tip = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7ec4\u7ec7\u201c%1$s\u201d\u6ca1\u6709\u4e0a\u7ea7\u8d44\u6599\u201c%2$s\u201d\u7684\u4f7f\u7528\u6743\uff0c\u6216\u8005\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"AssistantSaveValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.addErrorMessage(entity, String.format(tip, orgNumber, parentNumber));
            return false;
        }
        if ("6".equals(strategy)) {
            String tip = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u662f\u4e0a\u7ea7\u8f85\u52a9\u8d44\u6599\u201d%2$s\u201c\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u8d44\u6599\u521b\u5efa\u7ec4\u7ec7\u8303\u56f4\u5185\u5171\u4eab\u4e0b\uff0c\u6240\u6709\u5c42\u7ea7\u8d44\u6599\u7684\u521b\u5efa\u7ec4\u7ec7\u9700\u8981\u4e00\u81f4\u3002", (String)"AssistantSaveValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.addErrorMessage(entity, String.format(tip, orgNumber, parentNumber));
            return false;
        }
        return true;
    }

    private Map<Long, Map<String, Set<Long>>> getParentInfoFromDb(List<TypeItem> typeItems) {
        HashSet parentNumbers = new HashSet(16);
        ArrayList groupIds = new ArrayList(typeItems.size());
        typeItems.forEach(e -> {
            groupIds.add(((TypeItem)e).type.getLong("id"));
            parentNumbers.addAll(((TypeItem)e).getParentNums());
        });
        QFilter[] filters = new QFilter[]{new QFilter(PROP_GROUP_NUMBER, "in", groupIds), new QFilter("number", "in", parentNumbers)};
        HashMap<Long, Map<String, Set<Long>>> parentDataMap = new HashMap<Long, Map<String, Set<Long>>>(16);
        try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), ASSISTANT_ENTITY, "group, number, createorg", filters);){
            ds.forEach(r -> parentDataMap.computeIfAbsent(r.getLong(PROP_GROUP_NUMBER), k -> new HashMap(16)).computeIfAbsent(r.getString("number"), k -> new HashSet(16)).add(r.getLong("createorg")));
        }
        return parentDataMap;
    }

    private void orgConsistencyVerification(List<TreeNode> treeNodes, TypeItem typeItem) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return;
        }
        Iterator<TreeNode> iterator = treeNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode top = iterator.next();
            DynamicObject orgConsistencyData = null == top.parent ? top.curr.getDataEntity() : top.parent;
            Long orgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)orgConsistencyData, (String)"createorg");
            this.orgConsistencyVerification(top, orgId, typeItem, iterator);
        }
    }

    private void orgConsistencyVerification(TreeNode node, Long orgId, TypeItem typeItem, Iterator<TreeNode> iterator) {
        Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)node.curr.getDataEntity(), (String)"createorg");
        if (!Objects.equals(orgId, createOrgId)) {
            this.addErrorMessage(node, typeItem);
            this.addErrorMessage(node.children, typeItem);
            iterator.remove();
            return;
        }
        if (CollectionUtils.isEmpty((Collection)node.children)) {
            return;
        }
        Iterator<TreeNode> it = node.children.iterator();
        while (it.hasNext()) {
            TreeNode child = (TreeNode)it.next();
            this.orgConsistencyVerification(child, orgId, typeItem, it);
        }
    }

    private void addErrorMessage(TreeNode node, TypeItem typeItem) {
        typeItem.dataEntities.remove(node.curr);
        DynamicObject curr = node.curr.getDataEntity();
        String orgNumber = curr.getDynamicObject("createorg").getString("number");
        String parentNumber = node.parent.getString("number");
        if ("6".equals(node.strategy)) {
            String tip = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u662f\u4e0a\u7ea7\u8f85\u52a9\u8d44\u6599\u201d%2$s\u201c\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u8d44\u6599\u521b\u5efa\u7ec4\u7ec7\u8303\u56f4\u5185\u5171\u4eab\u4e0b\uff0c\u6240\u6709\u5c42\u7ea7\u8d44\u6599\u7684\u521b\u5efa\u7ec4\u7ec7\u9700\u8981\u4e00\u81f4\u3002", (String)"AssistantSaveValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), orgNumber, parentNumber);
            this.addErrorMessage(node.curr, tip);
            return;
        }
        String tip = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u662f\u4e0a\u7ea7\u8f85\u52a9\u8d44\u6599\u201d%2$s\u201c\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u79c1\u6709\u7b56\u7565\u4e0b\uff0c\u6240\u6709\u5c42\u7ea7\u8d44\u6599\u7684\u521b\u5efa\u7ec4\u7ec7\u9700\u8981\u4e00\u81f4\u3002", (String)"AssistantSaveValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), orgNumber, parentNumber);
        this.addErrorMessage(node.curr, tip);
    }

    private void addErrorMessage(List<TreeNode> nodes, TypeItem typeItem) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        for (TreeNode node : nodes) {
            typeItem.dataEntities.remove(node.curr);
            this.addErrorMessage(node.curr, ResManager.loadKDString((String)"\u4e0a\u7ea7\u8d44\u6599\u65b0\u589e\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u4e0b\u7ea7\u8d44\u6599\u4e5f\u4e0d\u80fd\u65b0\u589e\u3002", (String)"AssistantSaveValidator_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            this.addErrorMessage(node.children, typeItem);
        }
    }

    private void addErrorMessage(List<TreeNode> nodes) {
        if (!CollectionUtils.isEmpty(nodes)) {
            for (TreeNode node : nodes) {
                this.addErrorMessage(node.curr, ResManager.loadKDString((String)"\u4e0a\u7ea7\u8d44\u6599\u65b0\u589e\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u4e0b\u7ea7\u8d44\u6599\u4e5f\u4e0d\u80fd\u65b0\u589e\u3002", (String)"AssistantSaveValidator_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.addErrorMessage(node.children);
            }
        }
    }

    private List<TreeNode> getTreeNodes(TypeItem typeItem, Set<ExtendedDataEntity> modifyDataColl) {
        HashMap<ExtendedDataEntity, TreeNode> nodeMap = new HashMap<ExtendedDataEntity, TreeNode>(16);
        HashMap entityMap = new HashMap(16);
        typeItem.dataEntities.forEach(e -> entityMap.put(e.getDataEntity(), e));
        Iterator iterator = typeItem.dataEntities.iterator();
        while (iterator.hasNext()) {
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)iterator.next();
            DynamicObject currData = dataEntity.getDataEntity();
            if (currData.getDataEntityState().getFromDatabase()) {
                modifyDataColl.add(dataEntity);
            } else {
                DynamicObject parent = currData.getDynamicObject("parent");
                nodeMap.put(dataEntity, new TreeNode(dataEntity, parent, typeItem.strategy));
            }
            iterator.remove();
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        for (TreeNode node : nodeMap.values()) {
            ExtendedDataEntity parent = (ExtendedDataEntity)entityMap.get(node.parent);
            TreeNode parentNode = (TreeNode)nodeMap.get(parent);
            if (null != parentNode) {
                parentNode.add(node);
                continue;
            }
            nodes.add(node);
        }
        return nodes;
    }

    private static class DisableModifyProp {
        private Long orgId;
        private boolean enable;
        private Long groupId;

        private DisableModifyProp(Long orgId, boolean enable, Long groupId) {
            this.orgId = orgId;
            this.enable = enable;
            this.groupId = groupId;
        }
    }

    private static class View {
        private Long rootOrgId;
        private String rootName;
        private Set<Long> orgIds = new HashSet<Long>(16);
        private Set<Long> disableOrgIds = new HashSet<Long>(16);

        private View() {
        }

        private static Map<Long, View> getView(Set<Object> orgIds, Set<Object> viewIds) {
            QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("view", "in", viewIds)};
            HashMap<Long, View> viewMap = new HashMap<Long, View>(16);
            try (DataSet ds = ORM.create().queryDataSet(View.class.getName(), "bos_org_structure", "view, parent, org, org.enable, isfreeze", filters);){
                for (Row row : ds) {
                    Long parentId;
                    View view = viewMap.computeIfAbsent(row.getLong("view"), v -> new View());
                    Long orgId = row.getLong("org");
                    view.orgIds.add(orgId);
                    if (row.getBoolean("isfreeze").booleanValue() || !row.getBoolean("org.enable").booleanValue()) {
                        view.disableOrgIds.add(orgId);
                    }
                    if (null != (parentId = row.getLong("parent")) && 0L != parentId) continue;
                    view.rootOrgId = orgId;
                }
            }
            return viewMap;
        }

        private String getRootName(Long viewId) {
            Map viewOrgMap;
            if (null != this.rootName) {
                return this.rootName;
            }
            if (null == this.rootOrgId && !CollectionUtils.isEmpty((Map)(viewOrgMap = OrgUnitServiceHelper.getRootOrgId(new ArrayList<Long>(Collections.singleton(viewId))))) && viewOrgMap.containsKey(viewId)) {
                this.rootOrgId = (Long)viewOrgMap.get(viewId);
            }
            if (null == this.rootOrgId) {
                this.rootName = "";
                return this.rootName;
            }
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)this.rootOrgId)};
            DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])filters);
            this.rootName = null != org ? org.getString("name") : "";
            return this.rootName;
        }
    }

    private static class TreeNode {
        private ExtendedDataEntity curr;
        private String strategy;
        private DynamicObject parent;
        private List<TreeNode> children;

        private TreeNode(ExtendedDataEntity curr, DynamicObject parent, String strategy) {
            this.curr = curr;
            this.parent = parent;
            this.strategy = strategy;
        }

        private void add(TreeNode node) {
            if (null == this.children) {
                this.children = new ArrayList<TreeNode>(10);
            }
            this.children.add(node);
        }
    }

    private static class TypeItem {
        private DynamicObject type;
        private Long viewId;
        private Long createOrgId;
        private String strategy;
        private boolean groupControl;
        private LinkedHashSet<ExtendedDataEntity> dataEntities = new LinkedHashSet(16);
        private List<ExtendedDataEntity> nextValidateEntities = new ArrayList<ExtendedDataEntity>(10);

        private TypeItem(DynamicObject type, ExtendedDataEntity dataEntity) {
            this.type = type;
            this.viewId = (Long)type.getDynamicObject(AssistantSaveValidator.PROP_CTRL_VIEW).getPkValue();
            this.groupControl = type.getBoolean("isgroupcontrol");
            this.createOrgId = (Long)type.getDynamicObject("createorg").getPkValue();
            this.strategy = type.getString("ctrlstrategy");
        }

        private Collection<String> getParentNums() {
            ArrayList<String> parentNums = new ArrayList<String>(this.dataEntities.size());
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject data = dataEntity.getDataEntity();
                DynamicObject parent = data.getDynamicObject("parent");
                if (null == parent) continue;
                parentNums.add(parent.getString("number"));
            }
            return parentNums;
        }
    }
}

