/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.bdctrl;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AutoAssignSavePlugin
extends AbstractOperationServicePlugIn {
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String ENTITY_ID = "entityId";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String baseDataEntityId;
        QFilter entityIdFilter;
        QFilter numberFilter;
        QFilter[] filters;
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<String> numbers = new ArrayList<String>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            numbers.add(dataEntity.getString(NUMBER));
        }
        String entityId = e.getDataEntities()[0].getDataEntityType().getName();
        DynamicObjectCollection autoAssignPlans = QueryServiceHelper.query((String)entityId, (String)"id,number", (QFilter[])(filters = new QFilter[]{numberFilter = new QFilter(NUMBER, "in", numbers), entityIdFilter = new QFilter(ENTITY_ID, "=", (Object)(baseDataEntityId = e.getDataEntities()[0].getString(ENTITY_ID)))}));
        if (autoAssignPlans.isEmpty()) {
            return;
        }
        HashMap numberIdMap = new HashMap(dataEntities.length);
        autoAssignPlans.forEach(autoAssignPlan -> numberIdMap.put(autoAssignPlan.getString(NUMBER), autoAssignPlan.getLong(ID)));
        for (DynamicObject dataEntity : dataEntities) {
            Long id = dataEntity.getLong(ID);
            String number = dataEntity.getString(NUMBER);
            boolean isUpdate = dataEntity.getDataEntityState().getFromDatabase();
            if ((!isUpdate || null == numberIdMap.get(number) || id.equals(numberIdMap.get(number))) && (isUpdate || null == numberIdMap.get(number))) continue;
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"AutoAssignSavePlugin_0", (String)"bos-bd-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

