/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AssistantValidator
extends AbstractValidator {
    private static final String SYSTEM = "bos-bd-opplugin";
    private static final String ASSISTANT_DATA_ENTITYID = "bos_assistantdata_detail";
    private static final String BOS_ORG_ENTITYID = "bos_org";
    private static final String PROP_CREATEORG_ID = "createorg.id";
    private static final String PROP_CREATEORG_NAME = "createorg.name";
    private static final String PROP_ID = "id";
    private static final String OPTION_USEORG = "useOrg";
    private static final String APP_BASEDATA = "basedata";
    private static final String OPERATE_ENABLE = "enable";
    private static final String OPERATE_DISABLE = "disable";
    private static final String OPERATE_DELETE = "delete";
    private List<Long> hasPermOrgIds = new ArrayList<Long>(10);
    private Map<Object, Boolean> matchDataRule = new HashMap<Object, Boolean>(16);
    protected Long useOrgId = 0L;
    protected String useOrgName = "";
    protected boolean isFormOperate = false;
    protected Map<Long, String> failedDetails = new HashMap<Long, String>(16);
    protected Map<Long, ExtendedDataEntity> dataMap = new HashMap<Long, ExtendedDataEntity>(16);
    protected Map<Long, List<DynamicObject>> parentChildrenMap = new HashMap<Long, List<DynamicObject>>(16);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        HashSet errorDataIndexs = this.getValidateContext().getValidateResults().getErrorDataIndexs();
        if (errorDataIndexs.size() == dataEntities.length) {
            return;
        }
        this.initValidateInfo();
        String operationName = this.getOperationName();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            Long dataId = (Long)obj.getPkValue();
            long createOrgId = obj.getLong(PROP_CREATEORG_ID);
            if (errorDataIndexs.contains(dataEntity.getDataEntityIndex())) continue;
            if (!this.isFormOperate && !this.hasPermOrgIds.contains(createOrgId)) {
                String createOrgName = obj.getString(PROP_CREATEORG_NAME);
                String msg = ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u521b\u5efa\u7ec4\u7ec7\u201d%1$s\u201c\u7684\u201d%2$s\u201c\u6743\u9650\u3002", (String)"AssistantValidator_0", (String)SYSTEM, (Object[])new Object[0]);
                this.failedDetails.put(dataId, String.format(msg, createOrgName, operationName));
            }
            if (!this.matchDataRule.containsKey(dataId) || this.matchDataRule.get(dataId).booleanValue()) continue;
            String msg = ResManager.loadKDString((String)"\u65e0\u8f85\u52a9\u8d44\u6599\u201d%s\u201c\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssistantValidator_1", (String)SYSTEM, (Object[])new Object[0]);
            this.failedDetails.put(dataId, String.format(msg, operationName));
        }
    }

    private void initValidateInfo() {
        String appId;
        this.dataMap = Arrays.stream(this.dataEntities).collect(Collectors.toMap(v -> Long.valueOf(v.getBillPkId().toString()), v -> v));
        DynamicObjectCollection children = QueryServiceHelper.query((String)ASSISTANT_DATA_ENTITYID, (String)"id,parent.id,enable", (QFilter[])new QFilter[]{new QFilter("parent.id", "in", this.dataMap.keySet())});
        for (DynamicObject child : children) {
            Long parentId = child.getLong("parent.id");
            this.parentChildrenMap.computeIfAbsent(parentId, v -> new ArrayList()).add(child);
        }
        OperateOption option = this.getOption();
        String string = appId = option.containsVariable("currbizappid") ? option.getVariableValue("currbizappid") : APP_BASEDATA;
        if (this.getOption().containsVariable(OPTION_USEORG)) {
            this.isFormOperate = true;
            this.useOrgId = Long.valueOf(this.getOption().getVariableValue(OPTION_USEORG));
            DynamicObject useOrg = QueryServiceHelper.queryOne((String)BOS_ORG_ENTITYID, (String)"id,name", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "=", (Object)this.useOrgId)});
            if (useOrg != null) {
                this.useOrgName = useOrg.getString("name");
            }
        } else {
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"15", (String)appId, (String)ASSISTANT_DATA_ENTITYID, (String)this.getPermId(), (boolean)true);
            this.hasPermOrgIds = hasPermOrgResult.getHasPermOrgs();
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        this.matchDataRule = permissionService.matchDataRule(RequestContext.get().getCurrUserId(), appId, ASSISTANT_DATA_ENTITYID, this.getPermId(), (Object[])this.dataMap.keySet().toArray(new Long[0]), new HashMap(16));
    }

    protected String getPermId() {
        return "";
    }
}

