/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.util.CollectionUtils;

public class MeasureUnitSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("precision");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MeasureUnitSaveValidator());
    }

    private static class MeasureUnitSaveValidator
    extends AbstractValidator {
        private static final String ENTITY_MEASURE_UNIT = "bd_measureunits";
        private static final String PROP_PRECISION = "precision";
        private static final String PROP_ID = "id";

        private MeasureUnitSaveValidator() {
        }

        public void validate() {
            if (this.dataEntities == null || this.dataEntities.length == 0) {
                return;
            }
            Set dataIds = Arrays.stream(this.dataEntities).map(v -> (Long)v.getBillPkId()).collect(Collectors.toSet());
            QFilter filter = new QFilter(PROP_ID, "in", dataIds);
            DynamicObjectCollection oldDataObjs = QueryServiceHelper.query((String)ENTITY_MEASURE_UNIT, (String)"id,precision", (QFilter[])new QFilter[]{filter});
            if (CollectionUtils.isEmpty((Collection)oldDataObjs)) {
                return;
            }
            Map<Long, Integer> precisionMap = oldDataObjs.stream().collect(Collectors.toMap(v -> v.getLong(PROP_ID), v -> v.getInt(PROP_PRECISION)));
            HashMap<Long, ExtendedDataEntity> needCheckRefDataMap = new HashMap<Long, ExtendedDataEntity>(16);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                Integer oldPrecision;
                int newPrecision;
                Long dataId = (Long)dataEntity.getBillPkId();
                boolean fromDatabase = dataEntity.getDataEntity().getDataEntityState().getFromDatabase();
                if (!fromDatabase || !precisionMap.containsKey(dataId) || (newPrecision = dataEntity.getDataEntity().getInt(PROP_PRECISION)) >= (oldPrecision = precisionMap.get(dataId))) continue;
                needCheckRefDataMap.put(dataId, dataEntity);
            }
            if (!needCheckRefDataMap.isEmpty()) {
                this.checkRefrence(needCheckRefDataMap);
            }
        }

        private void checkRefrence(Map<Long, ExtendedDataEntity> dataEntityMap) {
            Map refrenceResultMap = BaseDataRefrenceHelper.checkRefrenced((String)ENTITY_MEASURE_UNIT, (Object[])dataEntityMap.keySet().toArray(new Long[0]), Collections.singletonList(ENTITY_MEASURE_UNIT), null, (OperateOption)OperateOption.create());
            if (null == refrenceResultMap || refrenceResultMap.isEmpty()) {
                return;
            }
            String msg = ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\uff1a\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\uff0c\u5355\u4f4d\u7cbe\u5ea6\u503c\u4e0d\u80fd\u88ab\u6539\u5c0f\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MeasureUnitSaveOpPlugin_0", (String)"bos-bd-opplugin", (Object[])new Object[0]);
            for (Map.Entry entrySet : refrenceResultMap.entrySet()) {
                Object dataId;
                BaseDataCheckRefrenceResult result = (BaseDataCheckRefrenceResult)entrySet.getValue();
                if (!result.isRefence() || !dataEntityMap.containsKey(dataId = entrySet.getKey())) continue;
                String refEntityId = result.getRefenceKey().getRefEntityKey();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)refEntityId);
                String entityName = dataEntityType.getDisplayName().getLocaleValue();
                String fieldName = result.getRefenceKey().getRefCol();
                Map allFields = dataEntityType.getAllFields();
                for (IDataEntityProperty field : allFields.values()) {
                    String alias = field.getAlias();
                    if (!(field instanceof IFieldHandle) || !StringUtils.equalsIgnoreCase((CharSequence)alias, (CharSequence)fieldName)) continue;
                    fieldName = field.getDisplayName().getLocaleValue();
                    break;
                }
                this.addMessage(dataEntityMap.get(dataId), String.format(msg, entityName, fieldName));
            }
        }
    }
}

