/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.opplugin.bdctrl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.AssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BdCtrlBathImportAssignPlugin
extends BatchImportPlugin {
    private static final String BOS_BD_OP_PLUGIN = "bos-bd-opplugin";
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String ASSIGN_ORG = "assignorg";
    private static final String STATUS = "status";
    private static final String SPLIT_FLAG = "-";
    private int failCount = 0;
    private int totalCount = 0;
    private boolean isTreeType = false;
    private String masterIdFiledName;
    private Map<Integer, List<ImportLogger.ImportLog>> logCache = new HashMap<Integer, List<ImportLogger.ImportLog>>(10000);
    private Map<String, Set<Long>> subOrgs = new HashMap<String, Set<Long>>(10);
    private Map<String, Integer> assignPerms = new HashMap<String, Integer>(10);
    private Map<String, Set<Long>> ctrlViewIds = new HashMap<String, Set<Long>>(4);

    protected void importData() throws Throwable {
        super.importData();
        Map importLoggers = (Map)this.ctx.getUrlLoggers();
        for (Map.Entry entry : importLoggers.entrySet()) {
            ImportLogger logger = (ImportLogger)entry.getValue();
            logger.setTotal(this.totalCount);
            logger.setFailed(this.failCount);
            this.ctx.feedbackProgress(100, logger, null);
            Long logId = Long.parseLong((String)this.ctx.getLogId());
            DynamicObject logObj = BusinessDataServiceHelper.loadSingleFromCache((Object)logId, (String)"bos_importlog");
            logObj.set("failed", (Object)this.failCount);
            logObj.set("total", (Object)this.totalCount);
            SaveServiceHelper.update((DynamicObject)logObj);
        }
    }

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockKeys = new ArrayList<String>();
        lockKeys.add("radiofield1");
        lockKeys.add("radiofield2");
        return lockKeys;
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        String key;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("basedata", new DistributeCacheHAPolicy());
        String entityId = (String)cache.get(key = "bd_assign_import-" + RequestContext.get().getCurrUserId());
        if (BaseDataCommonService.isTreeType((String)entityId)) {
            this.isTreeType = true;
        }
        this.masterIdFiledName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        Map<String, DynamicObject> orgMap = this.findOrgId(billDatas);
        Map<String, DynamicObject> dataMap = this.findBaseDataId(billDatas, entityId, orgMap);
        HashMap<String, List<ImportBillData>> strategyGroupMap = new HashMap<String, List<ImportBillData>>(8);
        Set<Long> ctrlViewOrgIds = this.getCtrlViewCuOrgIds(entityId);
        Iterator<ImportBillData> it = billDatas.iterator();
        while (it.hasNext()) {
            ImportBillData bill = it.next();
            ++this.totalCount;
            it.remove();
            String msg = this.assignValidator(bill, dataMap, orgMap, ctrlViewOrgIds, entityId);
            if (StringUtils.isNotBlank((String)msg)) {
                int rowNum = bill.getDataIndex();
                if (bill.getData().get((Object)"rowNum") != null) {
                    rowNum = (Integer)bill.getData().get((Object)"rowNum");
                }
                ArrayList<ImportLogger.ImportLog> importLogs = new ArrayList<ImportLogger.ImportLog>(1);
                ImportLogger.ImportLog importLog = new ImportLogger.ImportLog(msg);
                importLogs.add(importLog);
                this.logCache.put(rowNum, importLogs);
                logger.setLogCache(this.logCache);
                logger.fail();
                ++this.failCount;
                continue;
            }
            String dataNumber = (String)bill.getData().get((Object)"data");
            DynamicObject dataObject = dataMap.get(dataNumber);
            String strategy = dataObject.getString(CTRLSTRATEGY);
            ArrayList<ImportBillData> strategyGroupList = (ArrayList<ImportBillData>)strategyGroupMap.get(strategy);
            if (CollectionUtils.isEmpty((Collection)strategyGroupList)) {
                strategyGroupList = new ArrayList<ImportBillData>(8);
            }
            strategyGroupList.add(bill);
            strategyGroupMap.put(strategy, strategyGroupList);
        }
        if (CollectionUtils.isEmpty(strategyGroupMap)) {
            return;
        }
        this.batchAssign(orgMap, dataMap, strategyGroupMap, entityId);
    }

    private String assignValidator(ImportBillData bill, Map<String, DynamicObject> dataMap, Map<String, DynamicObject> orgMap, Set<Long> ctrlViewOrgIds, String entityId) {
        Set<Long> subOrgIds;
        Boolean isLeaf;
        String msg = null;
        if (bill.getData().get((Object)"data") == null) {
            msg = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"BdCtrlBathImportAssignPlugin_1", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]);
            return msg;
        }
        Object assignOrg = bill.getData().get((Object)ASSIGN_ORG);
        if (assignOrg == null) {
            msg = ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"BdCtrlBathImportAssignPlugin_4", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]);
            return msg;
        }
        Object useOrg = bill.getData().get((Object)"useorg");
        if (useOrg == null) {
            msg = ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"BdCtrlBathImportAssignPlugin_6", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]);
            return msg;
        }
        String dataNumber = (String)bill.getData().get((Object)"data");
        DynamicObject dataObject = dataMap.get(dataNumber);
        if (dataObject == null) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u57fa\u7840\u8d44\u6599\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u8005\u5206\u914d\u7ec4\u7ec7\u6ca1\u6709\u6570\u636e\u7684\u4f7f\u7528\u6743\u9650\u3002", (String)"BdCtrlBathImportAssignPlugin_2", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]), dataNumber);
            return msg;
        }
        String status = dataObject.getString(STATUS);
        if (!"C".equals(status)) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u672a\u5ba1\u6838\u7684\u6570\u636e\u4e0d\u80fd\u5206\u914d\u3002", (String)"BdCtrlBathImportAssignPlugin_11", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]), dataNumber);
            return msg;
        }
        String strategy = dataObject.getString(CTRLSTRATEGY);
        if (StringUtils.isNotBlank((String)strategy) && !"1".equals(strategy) && !"2".equals(strategy)) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u63a7\u5236\u7b56\u7565\u201d\u4e3a\u201c\u5206\u914d\u201d\u7c7b\u578b\u7684\u6570\u636e\u624d\u80fd\u5206\u914d\u3002", (String)"BdCtrlBathImportAssignPlugin_3", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]), dataNumber);
            return msg;
        }
        if (this.isTreeType && Boolean.FALSE.equals(isLeaf = Boolean.valueOf(dataObject.getBoolean("isleaf")))) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u6811\u5f62\u57fa\u7840\u8d44\u6599\u8bf7\u5206\u914d\u53f6\u5b50\u8282\u70b9\u3002", (String)"BdCtrlBathImportAssignPlugin_13", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]), dataNumber);
            return msg;
        }
        String assignOrgNumber = ((JSONObject)assignOrg).getString("number");
        if (!orgMap.containsKey(assignOrgNumber)) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5206\u914d\u7ec4\u7ec7\u9519\u8bef\u3002", (String)"BdCtrlBathImportAssignPlugin_5", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]), dataNumber);
            return msg;
        }
        String useOrgNumber = ((JSONObject)useOrg).getString("number");
        if (!orgMap.containsKey(useOrgNumber)) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u4f7f\u7528\u7ec4\u7ec7\u9519\u8bef\u3002", (String)"BdCtrlBathImportAssignPlugin_7", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]), dataNumber);
            return msg;
        }
        DynamicObject assignOrgObject = orgMap.get(assignOrgNumber);
        Long assignOrgId = assignOrgObject.getLong("id");
        if (!this.assignPermValidate(BdCtrlBathImportAssignPlugin.getAppId(entityId), entityId, assignOrgId)) {
            msg = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%s\u7684\u201c\u5206\u914d\u201d\u64cd\u4f5c\u529f\u80fd\u6743\u9650\u3002", (String)"BdCtrlBathImportAssignPlugin_15", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]), assignOrgNumber);
            return msg;
        }
        Long createOrgId = dataObject.getLong("createOrg.id");
        DynamicObject useOrgObject = orgMap.get(useOrgNumber);
        Long useOrgId = useOrgObject.getLong("id");
        long masterId = dataObject.getLong(this.masterIdFiledName);
        Long dataId = dataObject.getLong("id");
        if (!dataId.equals(masterId) && "2".equals(strategy)) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u4e2a\u6027\u5316\u7684\u201c\u81ea\u7531\u5206\u914d\u201d\u7c7b\u578b\u6570\u636e\u4e0d\u80fd\u5206\u914d\u3002", (String)"BdCtrlBathImportAssignPlugin_14", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]), dataNumber);
            return msg;
        }
        if (assignOrgId.equals(useOrgId)) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u80fd\u5c06\u81ea\u5df1\u521b\u5efa\u7684\u6570\u636e\u5206\u914d\u7ed9\u81ea\u5df1\u3002", (String)"BdCtrlBathImportAssignPlugin_10", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]), dataNumber);
            return msg;
        }
        if (!assignOrgId.equals(createOrgId) && !"1".equals(strategy)) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5206\u914d\u7ec4\u7ec7\u4e0d\u662f\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5206\u914d\u3002", (String)"BdCtrlBathImportAssignPlugin_8", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]), dataNumber);
            return msg;
        }
        if (!ctrlViewOrgIds.contains(assignOrgId) || !ctrlViewOrgIds.contains(useOrgId)) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5206\u914d\u7ec4\u7ec7\u548c\u4f7f\u7528\u7ec4\u7ec7\u5fc5\u987b\u662f\u57fa\u7840\u6570\u636e\u63a7\u5236\u89c6\u56fe\u91cc\u7684\u7ba1\u63a7\u5355\u5143\u3002", (String)"BdCtrlBathImportAssignPlugin_9", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]), dataNumber);
            return msg;
        }
        if ("1".equals(strategy) && !(subOrgIds = this.getAllSubordinateOrgs(entityId, assignOrgId)).contains(useOrgId)) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u4f7f\u7528\u7ec4\u7ec7\u4e0d\u662f\u5206\u914d\u7ec4\u7ec7\u7684\u4e0b\u7ea7\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u3002", (String)"BdCtrlBathImportAssignPlugin_12", (String)BOS_BD_OP_PLUGIN, (Object[])new Object[0]), dataNumber);
            return msg;
        }
        return msg;
    }

    private Set<Long> getAllSubordinateOrgs(String entityId, Long assignOrgId) {
        Set<Long> subOrgIds = this.subOrgs.get(assignOrgId + "_" + entityId);
        if (!CollectionUtils.isEmpty(subOrgIds)) {
            return subOrgIds;
        }
        DynamicObject orgView = BaseDataServiceHelper.getCtrlview((String)entityId);
        Long orgIdViewId = (Long)orgView.getPkValue();
        List ids = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)orgIdViewId, Collections.singletonList(assignOrgId), (boolean)true);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return new HashSet<Long>(1);
        }
        subOrgIds = new HashSet<Long>(ids);
        this.subOrgs.put(assignOrgId + "_" + entityId, subOrgIds);
        return subOrgIds;
    }

    private Set<Long> getCtrlViewCuOrgIds(String entityId) {
        Set<Long> ctrlViewOrgIds = this.ctrlViewIds.get(entityId);
        if (!CollectionUtils.isEmpty(ctrlViewOrgIds)) {
            return ctrlViewOrgIds;
        }
        List ids = BaseDataCommonService.getCtrlViewCuOrgs((String)entityId);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return new HashSet<Long>(1);
        }
        ctrlViewOrgIds = new HashSet<Long>(ids);
        this.ctrlViewIds.put(entityId, ctrlViewOrgIds);
        return ctrlViewOrgIds;
    }

    private void batchAssign(Map<String, DynamicObject> orgMap, Map<String, DynamicObject> dataMap, Map<String, List<ImportBillData>> strategyGroupMap, String entityId) {
        for (Map.Entry<String, List<ImportBillData>> groupEntry : strategyGroupMap.entrySet()) {
            HashMap<String, HashSet<Long>> orgGroupDataMap = new HashMap<String, HashSet<Long>>(8);
            List<ImportBillData> billDataList = groupEntry.getValue();
            for (ImportBillData importBillData : billDataList) {
                String dataNumber = (String)importBillData.getData().get((Object)"data");
                DynamicObject dataObject = dataMap.get(dataNumber);
                Long dataId = dataObject.getLong("id");
                Object assignOrg = importBillData.getData().get((Object)ASSIGN_ORG);
                String assignOrgNumber = ((JSONObject)assignOrg).getString("number");
                DynamicObject assignOrgObject = orgMap.get(assignOrgNumber);
                Long assignOrgId = assignOrgObject.getLong("id");
                Object useOrg = importBillData.getData().get((Object)"useorg");
                String useOrgNumber = ((JSONObject)useOrg).getString("number");
                DynamicObject useOrgObject = orgMap.get(useOrgNumber);
                Long useOrgId = useOrgObject.getLong("id");
                HashSet<Long> orgDataList = (HashSet<Long>)orgGroupDataMap.get(assignOrgId + SPLIT_FLAG + useOrgId);
                if (CollectionUtils.isEmpty((Collection)orgDataList)) {
                    orgDataList = new HashSet<Long>(8);
                }
                orgDataList.add(dataId);
                orgGroupDataMap.put(assignOrgId + SPLIT_FLAG + useOrgId, orgDataList);
            }
            if (CollectionUtils.isEmpty(orgGroupDataMap)) continue;
            for (Map.Entry entry : orgGroupDataMap.entrySet()) {
                String groupEntryKey = (String)entry.getKey();
                Long assignOrgId = Long.parseLong(groupEntryKey.split(SPLIT_FLAG)[0]);
                Long useOrgId = Long.parseLong(groupEntryKey.split(SPLIT_FLAG)[1]);
                Set dataIds = (Set)entry.getValue();
                HashSet<Long> userOrgIds = new HashSet<Long>(1);
                userOrgIds.add(useOrgId);
                BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.EXCEL_IMPORT);
                AssignService assignService = new AssignService(entityId);
                assignService.assign(assignOrgId, BdCtrlBathImportAssignPlugin.getAppId(entityId), dataIds, userOrgIds, false);
            }
        }
    }

    private Map<String, DynamicObject> findOrgId(List<ImportBillData> billDatas) {
        HashMap<String, String> orgNumMap = new HashMap<String, String>(8);
        for (ImportBillData bill : billDatas) {
            Object useOrg;
            Object assignOrg = bill.getData().get((Object)ASSIGN_ORG);
            if (assignOrg != null) {
                String assignOrgNumber = ((JSONObject)assignOrg).getString("number");
                orgNumMap.put(assignOrgNumber.trim(), assignOrgNumber.trim());
            }
            if ((useOrg = bill.getData().get((Object)"useorg")) == null) continue;
            String useOrgNumber = ((JSONObject)useOrg).getString("number");
            orgNumMap.put(useOrgNumber.trim(), useOrgNumber.trim());
        }
        HashMap<String, DynamicObject> billOrgMap = new HashMap<String, DynamicObject>(orgNumMap.size());
        if (CollectionUtils.isEmpty(orgNumMap)) {
            return billOrgMap;
        }
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", orgNumMap.values())};
        Map orgMapResult = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,number", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)orgMapResult)) {
            return billOrgMap;
        }
        for (Map.Entry entry : orgMapResult.entrySet()) {
            DynamicObject org = (DynamicObject)entry.getValue();
            String number = org.getString("number");
            billOrgMap.put(number, org);
        }
        return billOrgMap;
    }

    private Map<String, DynamicObject> findBaseDataId(List<ImportBillData> billDatas, String entityId, Map<String, DynamicObject> orgMap) {
        HashMap<Long, List<String>> orgGroupDataMap = new HashMap<Long, List<String>>(8);
        for (ImportBillData bill : billDatas) {
            String assignOrgNumber;
            DynamicObject assignOrgObject;
            Object assignOrg = bill.getData().get((Object)ASSIGN_ORG);
            if (assignOrg == null || (assignOrgObject = orgMap.get(assignOrgNumber = ((JSONObject)assignOrg).getString("number"))) == null) continue;
            Long assignOrgId = assignOrgObject.getLong("id");
            if (bill.getData().get((Object)"data") == null) continue;
            String dataNumber = (String)bill.getData().get((Object)"data");
            ArrayList<String> orgDataList = (ArrayList<String>)orgGroupDataMap.get(assignOrgId);
            if (CollectionUtils.isEmpty((Collection)orgDataList)) {
                orgDataList = new ArrayList<String>(8);
            }
            orgDataList.add(dataNumber);
            orgGroupDataMap.put(assignOrgId, orgDataList);
        }
        return this.queryBaseDataDetail(entityId, orgGroupDataMap);
    }

    private Map<String, DynamicObject> queryBaseDataDetail(String entityId, Map<Long, List<String>> orgGroupDataMap) {
        HashMap<String, DynamicObject> baseDataMap = new HashMap<String, DynamicObject>(8);
        if (CollectionUtils.isEmpty(orgGroupDataMap)) {
            return baseDataMap;
        }
        for (Map.Entry<Long, List<String>> orgGroupEntry : orgGroupDataMap.entrySet()) {
            Map dataMapResult;
            Long assignOrgId = orgGroupEntry.getKey();
            List<String> dataNumList = orgGroupEntry.getValue();
            QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)assignOrgId);
            QFilter[] filters = new QFilter[]{filter, new QFilter("number", "in", (Object)dataNumList.toArray())};
            String selectProperties = "id,number,status,ctrlstrategy,createOrg.id," + this.masterIdFiledName;
            if (this.isTreeType) {
                selectProperties = "id,number,status,ctrlstrategy,isleaf,createOrg.id," + this.masterIdFiledName;
            }
            if (CollectionUtils.isEmpty((Map)(dataMapResult = BusinessDataServiceHelper.loadFromCache((String)entityId, (String)selectProperties, (QFilter[])filters)))) continue;
            for (Map.Entry entry : dataMapResult.entrySet()) {
                DynamicObject obj = (DynamicObject)entry.getValue();
                String number = obj.getString("number");
                baseDataMap.put(number, obj);
            }
        }
        return baseDataMap;
    }

    private static String getAppId(String entityType) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityType);
        if (met == null || met.getAppId() == null) {
            return null;
        }
        return met.getAppId();
    }

    private boolean assignPermValidate(String appId, String entityId, Long orgId) {
        long userId = RequestContext.get().getCurrUserId();
        String key = userId + "_" + appId + "_" + entityId + "_" + orgId;
        int permRes = 0;
        if (this.assignPerms.containsKey(key)) {
            permRes = this.assignPerms.get(key);
        } else {
            permRes = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)appId, (String)entityId, (String)"80513208000000ac");
            this.assignPerms.put(key, permRes);
        }
        return 1 == permRes;
    }
}

