/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.common.thread;

import java.util.concurrent.Callable;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ArchiveDropBakTableCallable
implements Callable<Boolean> {
    private static Log logger = LogFactory.getLog((String)"ArchiveDropBakTableCallable");
    private static final String dropSql = "IF EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') DROP TABLE %s";
    private static final String updateSql = "update %s set fcleanstatus = ? where fid = ?";
    private final DBRoute dbRoute;
    private final String queryTable;
    private final long primaryKeyValue;
    private final String mapTableName;

    public ArchiveDropBakTableCallable(DBRoute dbRoute, String queryTable, long primaryKeyValue, String mapTableName) {
        this.dbRoute = dbRoute;
        this.queryTable = queryTable;
        this.primaryKeyValue = primaryKeyValue;
        this.mapTableName = mapTableName;
    }

    @Override
    public Boolean call() {
        try {
            DB.execute((DBRoute)this.dbRoute, (String)String.format(dropSql, this.mapTableName, this.mapTableName));
            int update = DB.update((DBRoute)this.dbRoute, (String)String.format(updateSql, this.queryTable), (Object[])new Object[]{"2", this.primaryKeyValue});
            if (update > 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Archive drop table fail:" + e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

