/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.common.util;

import java.util.List;
import java.util.Objects;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.list.query.impl.BaseData;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ArchiveBillConfigUtils
implements ArchiveConstant {
    private ArchiveBillConfigUtils() {
    }

    public static boolean existsArchiveConfig(String entityNumber) {
        QFilter numberFilter = new QFilter("number", "=", (Object)entityNumber);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_cbs_archi_config", (String)"id", (QFilter[])new QFilter[]{numberFilter});
        return dynamicObjects != null && dynamicObjects.length > 0;
    }

    public static boolean existsAndEnableArchiveConfig(String entityNumber) {
        QFilter numberFilter = new QFilter("number", "=", (Object)entityNumber);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_cbs_archi_config", (String)"id", (QFilter[])new QFilter[]{numberFilter, enableFilter});
        return dynamicObjects != null && dynamicObjects.length > 0;
    }

    public static DynamicObject getCascadeRootBill(Long parentPkValue) {
        DynamicObject parentBill = BusinessDataServiceHelper.loadSingle((Object)parentPkValue, (String)"bos_cbs_archi_cascade");
        DynamicObject parentParentBill = parentBill.getDynamicObject("parent");
        if (Objects.isNull(parentParentBill)) {
            return parentBill;
        }
        return ArchiveBillConfigUtils.getCascadeRootBill((Long)parentParentBill.getPkValue());
    }

    public static boolean existsApkTable(String entityNumber) {
        IDataEntityType dataEntityType = ORM.create().getDataEntityType(entityNumber);
        String dbRouteKey = dataEntityType.getDBRouteKey();
        return DB.exitsTable((DBRoute)DBRoute.of((String)dbRouteKey), (String)(dataEntityType.getAlias() + "$apk"));
    }

    public static BaseData getBaseData(IDataModel model, String fieldName) {
        DynamicObject baseData = (DynamicObject)model.getValue(fieldName);
        if (Objects.nonNull(baseData)) {
            BasedataEntityType rdType = (BasedataEntityType)baseData.getDataEntityType();
            Object id = baseData.getPkValue();
            String number = baseData.getString(rdType.getNumberProperty());
            String name = baseData.getLocaleString(rdType.getNameProperty()).getLocaleValue();
            return new BaseData(id, number, name);
        }
        return null;
    }

    public static boolean isCascadeChildBill(String number) {
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_archi_cascade", (String)"parent", (QFilter[])new QFilter[]{numberFilter});
        return Objects.nonNull(dynamicObject) && Objects.nonNull(dynamicObject.getDynamicObject("parent"));
    }

    public static boolean isCascadeRootBill(String number) {
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        DynamicObject dynamicObject = ORM.create().queryOne("bos_cbs_archi_cascade", new QFilter[]{numberFilter});
        return Objects.nonNull(dynamicObject) && Objects.isNull(dynamicObject.getDynamicObject("parent"));
    }

    public static boolean existCascadeConfig(String number) {
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        return QueryServiceHelper.exists((String)"bos_cbs_archi_cascade", (QFilter[])new QFilter[]{numberFilter});
    }

    public static boolean existIndexConfig(String number) {
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        return QueryServiceHelper.exists((String)"bos_cbs_archi_index", (QFilter[])new QFilter[]{numberFilter});
    }

    public static void collectDataEntityType(String entityNumber, List<IDataEntityType> dataEntityTypes) {
        DynamicObject[] dynamicObjects;
        QFilter numberFilter = new QFilter("longnumber", "like", (Object)(entityNumber + "%"));
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"bos_cbs_archi_cascade", (String)"number", (QFilter[])new QFilter[]{numberFilter})) {
            IDataEntityType dt = ORM.create().getDataEntityType((String)dynamicObject.get("number"));
            dataEntityTypes.add(dt);
        }
    }
}

