/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.common.util;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.OpFieldValueReader;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.bos.util.NetAddressUtils;

public class ArchiveOperateLog
implements ArchiveConstant {
    private static String ip = NetAddressUtils.getLocalIpAddress();

    public static void insertOperateLog(AfterDoOperationEventArgs afterDoOperationEventArgs, String formNumber, String formName, String opDesc, IFormView view, boolean fromList) {
        boolean insert = false;
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) || "enable".equals(operateKey) || "disable".equals(operateKey) || "delete".equals(operateKey)) {
            insert = true;
        }
        if (fromList ? insert : insert && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            opDesc = "The form '" + formName + "' has been operated by " + RequestContext.get().getUserName() + " on machine:" + ip + ".\nDetail:\n" + opDesc;
            ArchiveOperateLog.writeLog(afterDoOperationEventArgs, view, formNumber, opDesc);
        }
    }

    private static void writeLog(AfterDoOperationEventArgs afterDoOperationEventArgs, IFormView view, String formNumber, String msg) {
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        OpFieldValueReader fieldValueReader = OpFieldValueReader.get((IFormView)view);
        ArrayList<OpLogAppInfo> appLogInfoList = new ArrayList<OpLogAppInfo>(10);
        for (Object pkValue : opResult.getSuccessPkIds()) {
            OpLogAppInfo logInfo = ArchiveOperateLog.buildLogInfo(msg, fieldValueReader.getMainOrg(pkValue), formOperate.getOperateKey(), formNumber, view);
            appLogInfoList.add(logInfo);
        }
        if (!appLogInfoList.isEmpty()) {
            logService.addBatchLog(appLogInfoList);
        }
    }

    private static OpLogAppInfo buildLogInfo(String msg, Long orgId, String opKey, String formNumber, IFormView view) {
        AppInfo appInfo;
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String appNumber = view.getFormShowParameter().getAppId();
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            ListShowParameter param;
            BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
            String billFormId = null;
            if (view.getFormShowParameter() instanceof ListShowParameter) {
                param = (ListShowParameter)view.getFormShowParameter();
                billFormId = param.getBillFormId();
            } else if (view.getFormShowParameter() instanceof BillShowParameter) {
                param = (BillShowParameter)view.getFormShowParameter();
                billFormId = param.getFormId();
            }
            if (StringUtils.isNotBlank(billFormId)) {
                appId = bizAppService.getAppIdByFormNum(billFormId);
            }
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(formNumber);
        logInfo.setModifyBillNo(formNumber);
        if (orgId != null && 0L != orgId) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        String opName = null;
        try {
            Map dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)view.getEntityId(), (String)opKey);
            opName = (String)((Map)dataEntityOperate.get("name")).get("zh_CN");
        }
        catch (Exception exception) {
            // empty catch block
        }
        logInfo.setOpName(opKey, opName);
        logInfo.setOpDescription(msg);
        return logInfo;
    }
}

