/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class BasedataRefValidator
implements ArchiveConstant {
    private BasedataRefValidator() {
    }

    public static List<String> validate(String baseEntityTypeKey, Object[] objIds, Collection<String> ignoreRefEntityIds, Collection<String> checkRefEntityIds) {
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        if (!CollectionUtils.isEmpty(ignoreRefEntityIds)) {
            checker.getIgnoreRefEntityIds().addAll(ignoreRefEntityIds);
        }
        if (!CollectionUtils.isEmpty(checkRefEntityIds)) {
            checker.getCheckRefEntityIds().addAll(checkRefEntityIds);
        }
        BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)baseEntityTypeKey, Arrays.asList("number", "name"));
        Map resultMap = checker.checkRef(entityType, objIds);
        ArrayList<String> errMsgList = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Map)resultMap)) {
            return errMsgList;
        }
        resultMap.forEach((key, value) -> {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)baseEntityTypeKey, (String)"number", (QFilter[])new QFilter("id", "=", key).toArray());
            errMsgList.add(dynamicObject.getString("number") + ": " + BasedataRefValidator.buildRefMessage(value));
        });
        return errMsgList;
    }

    private static String buildRefMessage(BaseDataCheckRefrenceResult refrenceResult) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
        String billName = refMainType.getDisplayName().toString();
        String tableName = refrenceResult.getRefenceKey().getRefTable();
        String fieldName = refrenceResult.getRefenceKey().getRefCol();
        for (IDataEntityProperty property : refMainType.getAllFields().values()) {
            if (!BasedataRefValidator.equalsFieldname(property, tableName, fieldName) && !BasedataRefValidator.equalsMulBasedataFieldname(property, tableName, fieldName)) continue;
            fieldName = property.getDisplayName().toString();
            break;
        }
        return String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u201c%1s\u201d\u7684\u5b57\u6bb5\u201c%2s\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"BasedataRefValidator_0", (String)"bos-cbs-plugin", (Object[])new Object[0]), billName, fieldName);
    }

    private static boolean equalsFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (property instanceof IFieldHandle && property.getParent() != null && property.getParent().getAlias() != null) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)fieldName)) {
                return false;
            }
            String propTableName = property.getParent().getAlias();
            if (StringUtils.isNotBlank((CharSequence)property.getTableGroup())) {
                propTableName = propTableName + "_" + property.getTableGroup();
            }
            return StringUtils.equalsIgnoreCase((CharSequence)propTableName, (CharSequence)tableName);
        }
        return false;
    }

    private static boolean equalsMulBasedataFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (!(property instanceof MulBasedataProp)) {
            return false;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
        if (mulBasedataProp.getItemType() != null && mulBasedataProp.getItemType().getAlias() != null) {
            return StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"fbasedataid") && StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)mulBasedataProp.getItemType().getAlias());
        }
        return false;
    }
}

