/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.archive.ArchiveManager;
import kd.bos.archive.enums.ArchiveConfigFilterTypeEnum;
import kd.bos.archive.service.ArchiveService;
import kd.bos.archive.task.service.elasticsearch.LogEntityQFilterUtil;
import kd.bos.archive.task.service.elasticsearch.config.ESConfig;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveFormUtils;
import kd.bos.cbs.plugin.archive.common.util.ArchiveOperateLog;
import kd.bos.cbs.plugin.archive.common.util.ConditionParseUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class ArchiveCleanEditPlugin
extends AbstractFormPlugin
implements ArchiveConstant {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{"conditiondesc"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("movingtype", (Object)"1");
    }

    public void beforeBindData(EventObject e) {
        DynamicObject entityNumber = this.getModel().getDataEntity().getDynamicObject("billset");
        if (entityNumber != null) {
            String number = entityNumber.getString("number");
            this.setFilterType(number);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String filterType = dataEntity.getString("filtertype");
            String condition = dataEntity.getString("condition");
            JSONObject jsonObject = JSONObject.parseObject((String)condition);
            if (filterType.equalsIgnoreCase("bill") && null != jsonObject) {
                QFilter qFilter = ConditionParseUtil.parse2QFilter(number, jsonObject.getString(filterType));
                this.getModel().setValue("conditiondesc", (Object)qFilter.toString());
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IFormView view = this.getView();
        if ("conditiondesc".equals(key)) {
            Map<String, String> entityInfoInMap = this.getSelectedEntityInfoInMap();
            if (entityInfoInMap.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e05\u9664\u5b9e\u4f53\u3002", (String)"ArchiveCleanEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String filterType = (String)this.getModel().getValue("filtertype");
            if (StringUtils.isEmpty((String)filterType)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6761\u4ef6\u7c7b\u578b\u3002", (String)"ArchiveCleanEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_cbs_archi_condition");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCaption(ResManager.loadKDString((String)"\u6e05\u9664\u6761\u4ef6", (String)"ArchiveCleanEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            fsp.getCustomParams().put("conditionParams", entityInfoInMap);
            fsp.getCustomParams().put("condition", this.getModel().getValue("condition"));
            fsp.getCustomParams().put("filtertype", this.getModel().getValue("filtertype"));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CONDITION_FORM_CALL_BACK"));
            view.showForm(fsp);
        }
    }

    private Map<String, String> getSelectedEntityInfoInMap() {
        HashMap<String, String> ret = new HashMap<String, String>(2);
        DynamicObject curBill = (DynamicObject)this.getModel().getValue("billset");
        if (curBill != null) {
            RefEntityType rdType = (RefEntityType)curBill.getDataEntityType();
            ret.put("number", (String)curBill.get(rdType.getNumberProperty()));
            ret.put("name", ((ILocaleString)curBill.get(rdType.getNameProperty())).getLocaleValue());
        }
        return ret;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        IDataModel model = this.getModel();
        if ("billset".equals(property)) {
            DynamicObject archiveBillSet = model.getDataEntity().getDynamicObject("billset");
            if (archiveBillSet == null) {
                return;
            }
            String number = archiveBillSet.getString("number");
            String name = archiveBillSet.getString("name");
            model.setValue("number", (Object)number);
            model.setValue("entitynumber", (Object)number);
            model.setValue("name", (Object)name);
            model.setValue("condition", null);
            model.setValue("conditiondesc", null);
            model.setValue("movingtype", (Object)"1");
            this.setFilterType(number);
        }
    }

    private void setFilterType(String number) {
        boolean isESForm = ArchiveService.isLogEntity((String)number);
        boolean isESServer = ESConfig.getDcESServer().isEslogEnable();
        if (isESForm && isESServer) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"filtertype"});
            this.getModel().setValue("filtertype", (Object)ArchiveConfigFilterTypeEnum.ELASTICSEARCH.getKey());
        } else if (isESForm) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"filtertype"});
            this.getModel().setValue("filtertype", (Object)ArchiveConfigFilterTypeEnum.BILL.getKey());
        } else {
            ComboEdit comboEdit = (ComboEdit)this.getControl("filtertype");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
            ComboItem bill = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e", (String)"ArchiveCleanEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0])), "bill");
            ComboItem custom = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49", (String)"ArchiveCleanEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0])), "custom");
            comboItems.add(bill);
            comboItems.add(custom);
            comboEdit.setComboItems(comboItems);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"filtertype"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        String actionId = closedCallBackEvent.getActionId();
        String retData = (String)closedCallBackEvent.getReturnData();
        if (retData == null) {
            return;
        }
        switch (actionId) {
            case "CONDITION_FORM_CALL_BACK": {
                String filterType = (String)model.getValue("filtertype");
                JSONObject jsonObject = JSONObject.parseObject((String)retData);
                if (jsonObject.isEmpty()) break;
                if (jsonObject.getString("custom") != null) {
                    model.setValue("conditiondesc", (Object)("customClass:" + jsonObject.getString("custom")));
                } else {
                    String condition = jsonObject.getString(filterType);
                    if (StringUtils.isEmpty((String)condition)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6761\u4ef6\u6216\u6761\u4ef6\u503c\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u6e05\u9664\u6761\u4ef6\u3002", (String)"ArchiveCleanEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                        model.setValue("condition", null);
                        return;
                    }
                    model.setValue("conditiondesc", (Object)ConditionParseUtil.parse2QFilter((String)model.getValue("number"), condition).toString());
                }
                model.setValue("condition", (Object)retData);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        DynamicObject entityNumber;
        String number;
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("disable".equals(operateKey) || "delete".equals(operateKey)) {
            Long id = (Long)model.getDataEntity().getPkValue();
            if (!ArchiveManager.get().checkConfigEnd(id.longValue())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\u8be5\u914d\u7f6e\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"ArchiveConfigEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("enable".equals(operateKey)) {
            if (!ORM.create().exists("bos_cbs_archi_config", model.getDataEntity().getPkValue())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u914d\u7f6e\u3002", (String)"ArchiveConfigEditPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("save".equals(operateKey) && ArchiveService.isLogEntity((String)(number = (entityNumber = model.getDataEntity().getDynamicObject("billset")).getString("number"))).booleanValue()) {
            String codition = (String)model.getValue("condition");
            String filterType = (String)model.getValue("filtertype");
            JSONObject jsonObject = JSONObject.parseObject((String)codition);
            QFilter qFilter = ConditionParseUtil.parse2QFilter(number, jsonObject.getString(filterType));
            if (!LogEntityQFilterUtil.verify((QFilter)qFilter)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u8868\u5355\u5f52\u6863\u89c4\u5219\u6821\u9a8c\u5931\u8d25\uff0c\u9700\u6839\u636e\u64cd\u4f5c\u65f6\u95f4\u6309\u533a\u95f4\u5f52\u6863\uff0c\u5982opdate<=\u622a\u6b62\u65f6\u95f4\u6216\u5f00\u59cb\u65f6\u95f4<opdate<\u622a\u6b62\u65f6\u95f4\u7b49\u3002", (String)"ArchiveConfigEditPlugin_18", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IDataModel model = this.getModel();
        String number = (String)model.getValue("number");
        String condition = (String)model.getValue("condition");
        HashMap<String, String> map = ArchiveFormUtils.parseCondition(condition);
        String filterType = (String)model.getValue("filtertype");
        String conditionValue = map.get(filterType);
        String value = model.getValue("billset") != null ? ("custom".equals(filterType) ? "customClass:" + conditionValue : ConditionParseUtil.parse2QFilter((String)model.getValue("number"), conditionValue).toString()) : (String)model.getValue("number");
        String opDesc = "CleanNumber:" + number + "\nCleanCondition:" + value;
        ArchiveOperateLog.insertOperateLog(afterDoOperationEventArgs, this.getModel().getDataEntityType().getName(), this.getModel().getDataEntityType().getDisplayName().getLocaleValue(), opDesc, this.getView(), false);
    }
}

