/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveManager;
import kd.bos.archive.enums.ArchiveConfigFilterTypeEnum;
import kd.bos.archive.enums.ArchiveConfigMovingTypeEnum;
import kd.bos.archive.service.ArchiveService;
import kd.bos.archive.task.service.elasticsearch.LogEntityQFilterUtil;
import kd.bos.archive.task.service.elasticsearch.config.ESConfig;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveBillConfigUtils;
import kd.bos.cbs.plugin.archive.common.util.ArchiveOperateLog;
import kd.bos.cbs.plugin.archive.common.util.ConditionParseUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveInfo;
import kd.bos.db.archive.ArchiveRouteType;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.db.archive.MCArchive;
import kd.bos.db.archive.RouteInfo;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.query.impl.BaseData;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class ArchiveConfigEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ArchiveConstant,
RowClickEventListener {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{"conditiondesc"});
        this.addClickListeners(new String[]{"timeattr"});
        BasedataEdit groupEdit = (BasedataEdit)this.getControl("group");
        groupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bd = (BasedataEdit)this.getControl("bd");
        bd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("syncbasedata", (Object)true);
        this.getModel().setValue("movingtype", (Object)"0");
    }

    public void beforeBindData(EventObject e) {
        String number;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String movingType = (String)model.getValue("movingtype");
        if (StringUtils.isNotEmpty((String)movingType)) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("group");
            if (ArchiveConfigMovingTypeEnum.ARCHIVE.getKey().equals(movingType)) {
                view.setVisible(Boolean.valueOf(true), new String[]{"group"});
                basedataEdit.setMustInput(true);
            } else {
                view.setVisible(Boolean.valueOf(false), new String[]{"group"});
                basedataEdit.setMustInput(false);
            }
        }
        if (StringUtils.isNotEmpty((String)(number = (String)model.getValue("number")))) {
            this.setFilterType(number);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String filterType = dataEntity.getString("filtertype");
            String condition = dataEntity.getString("condition");
            JSONObject jsonObject = JSONObject.parseObject((String)condition);
            if (filterType.equalsIgnoreCase("bill") && null != jsonObject) {
                QFilter qFilter = ConditionParseUtil.parse2QFilter(number, jsonObject.getString(filterType));
                this.getModel().setValue("conditiondesc", (Object)qFilter.toString());
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IFormView view = this.getView();
        if ("conditiondesc".equals(key)) {
            Map<String, String> entityInfoInMap = this.getSelectedEntityInfoInMap();
            if (entityInfoInMap.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f52\u6863\u5b9e\u4f53\u3002", (String)"ArchiveConfigEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String filterType = (String)this.getModel().getValue("filtertype");
            if (StringUtils.isEmpty((String)filterType)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6761\u4ef6\u7c7b\u578b\u3002", (String)"ArchiveConfigEditPlugin_13", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_cbs_archi_condition");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.getCustomParams().put("conditionParams", entityInfoInMap);
            fsp.getCustomParams().put("condition", this.getModel().getValue("condition"));
            fsp.getCustomParams().put("filtertype", this.getModel().getValue("filtertype"));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CONDITION_FORM_CALL_BACK"));
            if ("custom".equals(this.getModel().getValue("filtertype"))) {
                this.configCssStyle(fsp);
            }
            view.showForm(fsp);
        } else if ("timeattr".equals(key)) {
            String rowIndex = this.getPageCache().get("rowIndex");
            if (StringUtils.isEmpty((String)rowIndex)) {
                return;
            }
            this.showFieldChooseView(Integer.parseInt(rowIndex));
        }
    }

    private void configCssStyle(FormShowParameter fsp) {
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("460");
        styleCss.setHeight("310");
        fsp.getOpenStyle().setInlineStyleCss(styleCss);
    }

    private Map<String, String> getSelectedEntityInfoInMap() {
        HashMap<String, String> ret = new HashMap<String, String>(2);
        DynamicObject curBill = (DynamicObject)this.getModel().getValue("billset");
        if (curBill != null) {
            RefEntityType rdType = (RefEntityType)curBill.getDataEntityType();
            ret.put("number", (String)curBill.get(rdType.getNumberProperty()));
            ret.put("name", ((ILocaleString)curBill.get(rdType.getNameProperty())).getLocaleValue());
        }
        return ret;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String value;
        String property = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("billset".equals(property)) {
            DynamicObject archiveBillSet = model.getDataEntity().getDynamicObject("billset");
            if (archiveBillSet == null) {
                this.getModel().deleteEntryData("entryentity");
                return;
            }
            String number = archiveBillSet.getString("number");
            if (ArchiveBillConfigUtils.isCascadeChildBill(number)) {
                view.showMessage(ResManager.loadKDString((String)"\u5355\u636e[%s]\u662f\u7ea7\u8054\u914d\u7f6e\u5b50\u5355\u636e\uff0c\u7ea7\u8054\u5b50\u5355\u636e\u5f52\u6863\u4f9d\u8d56\u4e8e\u6839\u5355\u636e\uff0c\u4e0d\u80fd\u5355\u72ec\u914d\u7f6e\u5f52\u6863\u89c4\u5219\u3002", (String)"ArchiveConfigEditPlugin_19", (String)"bos-cbs-plugin", (Object[])new Object[]{number}));
                model.setValue("billset", null);
                return;
            }
            String name = archiveBillSet.getString("name");
            model.setValue("number", (Object)number);
            model.setValue("entitynumber", (Object)number);
            model.setValue("name", (Object)name);
            model.setValue("group", null);
            model.setValue("condition", null);
            model.setValue("conditiondesc", null);
            boolean isSync = (Boolean)model.getValue("syncbasedata");
            if (isSync) {
                this.buildBDEntry4Select();
            }
            this.setFilterType(number);
        } else if ("syncbasedata".equals(property)) {
            boolean syncBd = (Boolean)model.getValue("syncbasedata");
            Map<String, String> entityInfoInMap = this.getSelectedEntityInfoInMap();
            if (syncBd) {
                if (entityInfoInMap.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f52\u6863\u5b9e\u4f53\u3002", (String)"ArchiveConfigEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    model.setValue("syncbasedata", (Object)false);
                    return;
                }
                view.setVisible(Boolean.TRUE, new String[]{"advconap"});
                this.buildBDEntry4Select();
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"advconap"});
            }
        } else if ("movingtype".equals(property)) {
            String movingType = (String)model.getValue("movingtype");
            DynamicObject archiveBillSet = model.getDataEntity().getDynamicObject("billset");
            if (archiveBillSet == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f52\u6863\u5b9e\u4f53\u3002", (String)"ArchiveConfigEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String number = archiveBillSet.getString("number");
            this.setFilterType(number);
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("group");
            if (ArchiveConfigMovingTypeEnum.ARCHIVE.getKey().equals(movingType)) {
                view.setVisible(Boolean.valueOf(true), new String[]{"group"});
                basedataEdit.setMustInput(true);
            } else {
                view.setVisible(Boolean.valueOf(false), new String[]{"group"});
                basedataEdit.setMustInput(false);
                this.getModel().setValue("group", null);
            }
        } else if ("filtertype".equals(property)) {
            this.getModel().setValue("condition", null);
            this.getModel().setValue("conditiondesc", null);
        } else if ("bdnumber".equals(property)) {
            DynamicObject billSet = model.getDataEntity().getDynamicObject("billset");
            String rowIndexStr = this.getPageCache().get("rowIndex");
            if (StringUtils.isEmpty((String)rowIndexStr) || Objects.isNull(billSet)) {
                return;
            }
            int rowIndex = Integer.parseInt(rowIndexStr);
            String bdNumber = (String)this.getModel().getValue("bdnumber", rowIndex);
            if (StringUtils.isEmpty((String)bdNumber)) {
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Map numberCountMap = entryEntity.stream().map(entry -> entry.getString("bdnumber")).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            if (numberCountMap.get(bdNumber) > 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ArchiveConfigEditPlugin_23", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                this.getModel().setValue("bd", null, rowIndex);
                return;
            }
            IDataEntityType bdNumberDt = ORMConfiguration.innerGetDataEntityType((String)bdNumber, null);
            String number = billSet.getString("number");
            IDataEntityType numberDt = ORMConfiguration.innerGetDataEntityType((String)number, null);
            if (!Objects.equals(numberDt.getDBRouteKey(), bdNumberDt.getDBRouteKey())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u5e94\u7528\u5e93\u4e0b\u7684\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ArchiveConfigEditPlugin_24", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                this.getModel().setValue("bd", null, rowIndex);
            }
        } else if ("conditiondesc".equals(property) && StringUtils.isEmpty((String)(value = (String)model.getValue("conditiondesc")))) {
            model.setValue("condition", null);
        }
    }

    private void setFilterType(String number) {
        boolean isESForm = ArchiveService.isLogEntity((String)number);
        boolean isESServer = ESConfig.getDcESServer().isEslogEnable();
        ComboEdit comboEdit = (ComboEdit)this.getControl("filtertype");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(4);
        if (isESForm && isESServer) {
            ComboItem es = new ComboItem(new LocaleString("ElasticSearch"), "es");
            comboItems.add(es);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"filtertype"});
            this.getModel().setValue("filtertype", (Object)ArchiveConfigFilterTypeEnum.ELASTICSEARCH.getKey());
        } else if (isESForm) {
            ComboItem bill = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e", (String)"ArchiveConfigEditPlugin_25", (String)"bos-cbs-plugin", (Object[])new Object[0])), "bill");
            comboItems.add(bill);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"filtertype"});
            this.getModel().setValue("filtertype", (Object)ArchiveConfigFilterTypeEnum.BILL.getKey());
        } else {
            ComboItem bill = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e", (String)"ArchiveConfigEditPlugin_25", (String)"bos-cbs-plugin", (Object[])new Object[0])), "bill");
            ComboItem custom = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49", (String)"ArchiveConfigEditPlugin_26", (String)"bos-cbs-plugin", (Object[])new Object[0])), "custom");
            comboItems.add(bill);
            comboItems.add(custom);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"filtertype"});
        }
        comboEdit.setComboItems(comboItems);
    }

    private void buildBDEntry4Select() {
        Map<String, String> selectedEntityInfoInMap = this.getSelectedEntityInfoInMap();
        if (selectedEntityInfoInMap.isEmpty()) {
            return;
        }
        String entityNumber = selectedEntityInfoInMap.get("number");
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        if (ArchiveBillConfigUtils.isCascadeRootBill(entityNumber)) {
            ArchiveBillConfigUtils.collectDataEntityType(entityNumber, dataEntityTypes);
        } else {
            IDataEntityType dt2 = ORM.create().getDataEntityType(selectedEntityInfoInMap.get("number"));
            dataEntityTypes.add(dt2);
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        HashSet baseSet = new HashSet();
        dataEntityTypes.forEach(dt -> {
            String dbRouteKey = dt.getDBRouteKey();
            DBRoute entityDB = DBRoute.of((String)dbRouteKey);
            DBRoute sysDB = DBRoute.of((String)"sys");
            this.collectBaseDataName((IDataEntityType)dt, baseSet, entityDB, sysDB);
        });
        baseSet.forEach(number -> {
            int rowIndex = model.createNewEntryRow("entryentity");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
            model.setValue("bd", number, rowIndex);
            model.setValue("bdnumber", number, rowIndex);
            model.setValue("bdname", (Object)dataEntityType.getDisplayName(), rowIndex);
            model.setValue("custom", (Object)false, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"bd"});
        });
    }

    private void collectBaseDataName(IDataEntityType dt, Set<String> baseSet, DBRoute entityDB, DBRoute sysDB) {
        DataEntityPropertyCollection properties = dt.getProperties();
        for (IDataEntityProperty dp : properties) {
            if (dp instanceof BasedataProp && !(dp instanceof FlexProp)) {
                DBRoute baseDataDB = DBRoute.of((String)((BasedataProp)dp).getComplexType().getDBRouteKey());
                if (!baseDataDB.equals(entityDB) || baseDataDB.equals(sysDB)) continue;
                String baseName = ((BasedataProp)dp).getComplexType().getName();
                baseSet.add(baseName);
                continue;
            }
            if (dp instanceof ItemClassTypeProp) {
                Map itemTypes = ((ItemClassTypeProp)dp).getItemTypes();
                itemTypes.forEach((key, dynamicObjectType) -> {
                    String itemDBKey = dynamicObjectType.getDBRouteKey();
                    if (entityDB.getRouteKey().equals(itemDBKey) && !"sys".equals(itemDBKey)) {
                        baseSet.add((String)key);
                    }
                });
                continue;
            }
            if (!(dp instanceof ICollectionProperty) || dp instanceof DynamicLocaleProperty) continue;
            IDataEntityType itemType = ((ICollectionProperty)dp).getItemType();
            this.collectBaseDataName(itemType, baseSet, entityDB, sysDB);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        String actionId = closedCallBackEvent.getActionId();
        String retData = (String)closedCallBackEvent.getReturnData();
        if (retData == null) {
            return;
        }
        switch (actionId) {
            case "CONDITION_FORM_CALL_BACK": {
                String filterType = (String)model.getValue("filtertype");
                JSONObject jsonObject = JSONObject.parseObject((String)retData);
                if (jsonObject.isEmpty()) break;
                if (jsonObject.getString("custom") != null) {
                    model.setValue("conditiondesc", (Object)("customClass:" + jsonObject.getString("custom")));
                } else {
                    String condition = jsonObject.getString(filterType);
                    if (StringUtils.isEmpty((String)condition)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6761\u4ef6\u6216\u6761\u4ef6\u503c\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u5f52\u6863\u6761\u4ef6\u3002", (String)"ArchiveConfigEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                        model.setValue("condition", null);
                        return;
                    }
                    model.setValue("conditiondesc", (Object)ConditionParseUtil.parse2QFilter((String)model.getValue("number"), condition).toString());
                }
                model.setValue("condition", (Object)retData);
                break;
            }
            case "timeattr": {
                String rowIndexStr = this.getPageCache().get("rowIndex");
                if (StringUtils.isEmpty((String)rowIndexStr)) {
                    return;
                }
                int rowIndex = Integer.parseInt(rowIndexStr);
                model.setValue("timeattr", (Object)retData, rowIndex);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("disable".equals(operateKey) || "delete".equals(operateKey)) {
            Long id = (Long)model.getDataEntity().getPkValue();
            if (!ArchiveManager.get().checkConfigEnd(id.longValue())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\u8be5\u914d\u7f6e\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"ArchiveConfigEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("enable".equals(operateKey)) {
            if (!ORM.create().exists("bos_cbs_archi_config", model.getDataEntity().getPkValue())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u914d\u7f6e\u3002", (String)"ArchiveConfigEditPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else if (Objects.isNull(model.getValue("group"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5173\u8054\u5f52\u6863\u5e93\uff0c\u518d\u542f\u7528\u5f52\u6863\u89c4\u5219\u3002", (String)"ArchiveConfigEditPlugin_27", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("save".equals(operateKey)) {
            DynamicObject archiveBillSet = model.getDataEntity().getDynamicObject("billset");
            String number = archiveBillSet.getString("number");
            String movingType = (String)model.getValue("movingtype");
            if (ArchiveConfigMovingTypeEnum.ARCHIVE.getKey().equals(movingType)) {
                DynamicObject group = model.getDataEntity().getDynamicObject("group");
                String archiveRoute = group.getString("database");
                LogicArchiveRoute logicArchiveRoute = LogicArchiveRoute.of((String)archiveRoute);
                String databaseType = (String)group.get("database_type");
                if (ArchiveRouteType.ES.getKey().equals(databaseType)) {
                    ESConfig dcESConfig = ESConfig.getDcESServer();
                    if (!dcESConfig.isEslogEnable()) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d26\u5957\u672a\u5f00\u542fES\u65e5\u5fd7\u5b58\u50a8\uff0c\u8bf7\u5728MC\u4e2d\u914d\u7f6e\u65e5\u5fd7ES\u5b58\u50a8\u3002", (String)"ArchiveConfigEditPlugin_14", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    boolean isFind = false;
                    for (String archive : dcESConfig.getEsServerUriMap().keySet()) {
                        if (dcESConfig.getAccountNumber().equals(archive) || !archive.equals(logicArchiveRoute.getRealArchiveKey())) continue;
                        isFind = true;
                        break;
                    }
                    if (!isFind) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u5e93\u4e0d\u5339\u914d\uff0c\u8bf7\u9009\u62e9\u672c\u8d26\u5957\u4e0b\u7684\u7684ES\u5f52\u6863\u5e93\u3002", (String)"ArchiveConfigEditPlugin_15", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                } else if (!logicArchiveRoute.getRealArchiveKey().equals("cur_database")) {
                    IDataEntityType dt = ORMConfiguration.innerGetDataEntityType((String)number, null);
                    String routeKey = dt.getDBRouteKey();
                    RouteInfo routeInfo = MCArchive.get((String)routeKey);
                    List archiveInfo = routeInfo.getArchiveInfo();
                    boolean isFind = false;
                    for (ArchiveInfo archive : archiveInfo) {
                        if (routeKey.equals(archive.getKey()) || !archive.getKey().equals(logicArchiveRoute.getRealArchiveKey())) continue;
                        isFind = true;
                        break;
                    }
                    if (!isFind) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u5e93\u4e0d\u5339\u914d\uff0c\u8bf7\u9009\u62e9\u6539\u8868\u5355\u6240\u5c5e\u5e94\u7528\u5f52\u6863\u5e93\u3002", (String)"ArchiveConfigEditPlugin_17", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                }
                if (ArchiveRouteType.ES.getKey().equals(databaseType) || ArchiveService.isLogEntity((String)number).booleanValue()) {
                    String codition = (String)model.getValue("condition");
                    String filterType = (String)model.getValue("filtertype");
                    JSONObject jsonObject = JSONObject.parseObject((String)codition);
                    QFilter qFilter = ConditionParseUtil.parse2QFilter(number, jsonObject.getString(filterType));
                    if (!LogEntityQFilterUtil.verify((QFilter)qFilter)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u8868\u5355\u5f52\u6863\u89c4\u5219\u6821\u9a8c\u5931\u8d25\uff0c\u9700\u6839\u636e\u64cd\u4f5c\u65f6\u95f4\u6309\u533a\u95f4\u5f52\u6863\uff0c\u5982opdate<=\u622a\u6b62\u65f6\u95f4\u6216\u5f00\u59cb\u65f6\u95f4<opdate<\u622a\u6b62\u65f6\u95f4\u7b49\u3002", (String)"ArchiveConfigEditPlugin_18", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                }
            }
        } else if ("newentry".equalsIgnoreCase(operateKey)) {
            DynamicObject billSet = model.getDataEntity().getDynamicObject("billset");
            if (Objects.isNull(billSet)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f52\u6863\u5b9e\u4f53\u3002", (String)"ArchiveConfigEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("deleteentry".equalsIgnoreCase(operateKey)) {
            int[] selectedRowIndex;
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            for (int rowIndex : selectedRowIndex = entryGrid.getSelectRows()) {
                DynamicObject delObj = model.getEntryRowEntity("entryentity", rowIndex);
                if (delObj.getBoolean("custom")) continue;
                view.showTipNotification(ResManager.loadKDString((String)"\u975e\u81ea\u5b9a\u4e49\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u80fd\u5220\u9664\u3002", (String)"ArchiveConfigEditPlugin_20", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        String name = property.getName();
        if ("group".equals(name)) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            DynamicObject archiveBillSet = model.getDataEntity().getDynamicObject("billset");
            if (archiveBillSet == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f52\u6863\u5b9e\u4f53\u3002", (String)"ArchiveConfigEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            String number = archiveBillSet.getString("number");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            boolean isESForm = ArchiveService.isLogEntity((String)number);
            boolean isESServer = ESConfig.getDcESServer().isEslogEnable();
            if (isESForm && isESServer) {
                listFilterParameter.getQFilters().add(new QFilter("database_type", "=", (Object)ArchiveRouteType.ES.getKey()));
            } else {
                IDataEntityType dt = ORMConfiguration.innerGetDataEntityType((String)number, null);
                String routeKey = dt.getDBRouteKey();
                RouteInfo routeInfo = MCArchive.get((String)routeKey);
                List archiveInfo = routeInfo.getArchiveInfo();
                ArrayList<String> params = new ArrayList<String>(16);
                for (ArchiveInfo archive : archiveInfo) {
                    if (routeKey.equals(archive.getKey())) continue;
                    params.add(archive.getKey());
                }
                params.add("cur_database");
                listFilterParameter.getQFilters().add(new QFilter("database", "in", params));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (!Arrays.asList("save", "enable", "disable").contains(operateKey)) {
            return;
        }
        IDataModel model = this.getModel();
        String number = (String)model.getValue("number");
        DynamicObject group = (DynamicObject)model.getValue("group");
        String archivePlan = group != null ? group.get("name").toString() : "NoPlan";
        String condition = (String)model.getValue("condition");
        String filterType = (String)model.getValue("filtertype");
        JSONObject jsonObject = JSONObject.parseObject((String)condition);
        String conditionValue = jsonObject.getString(filterType);
        String value = model.getValue("billset") != null ? ("custom".equals(filterType) ? "customClass:" + conditionValue : ConditionParseUtil.parse2QFilter((String)model.getValue("number"), conditionValue).toString()) : (String)model.getValue("number");
        String opDesc = "ArchivePlan:" + archivePlan + "\nArchiveConfigNumber:" + number + "\nArchiveCondition:" + value;
        ArchiveOperateLog.insertOperateLog(args, this.getModel().getDataEntityType().getName(), this.getModel().getDataEntityType().getDisplayName().getLocaleValue(), opDesc, this.getView(), false);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.getPageCache().put("rowIndex", String.valueOf(row));
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.entryRowClick(evt);
    }

    private void showFieldChooseView(int row) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BaseData billInfo = this.getEntryRowBD(model, row);
        if (Objects.isNull(billInfo)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u7840\u8d44\u6599\u3002", (String)"ArchiveConfigEditPlugin_21", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject rowEntry = model.getEntryRowEntity("entryentity", row);
        String modifyTimeField = rowEntry.getString("timeattr");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bos_cbs_archi_fields");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.getCustomParams().put("ismulti", Boolean.FALSE.toString());
        fsp.getCustomParams().put("entitynumber", billInfo.getNumber());
        fsp.getCustomParams().put("fields", modifyTimeField);
        fsp.getCustomParams().put("is_only_date", Boolean.TRUE.toString());
        fsp.setCaption(ResManager.loadKDString((String)"\u65f6\u95f4\u5c5e\u6027", (String)"ArchiveConfigEditPlugin_22", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "timeattr"));
        this.getView().showForm(fsp);
    }

    public BaseData getEntryRowBD(IDataModel model, int rowIndex) {
        DynamicObject rowEntry = model.getEntryRowEntity("entryentity", rowIndex);
        DynamicObject baseData = rowEntry.getDynamicObject("bd");
        if (Objects.nonNull(baseData)) {
            BasedataEntityType rdType = (BasedataEntityType)baseData.getDataEntityType();
            Object id = baseData.getPkValue();
            String number = baseData.getString(rdType.getNumberProperty());
            String name = baseData.getLocaleString(rdType.getNameProperty()).getLocaleValue();
            return new BaseData(id, number, name);
        }
        return null;
    }
}

