/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveFormUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.bos.xdb.service.ActionUtil;

public class ArchiveFieldsEditPlugin
extends AbstractFormPlugin
implements ArchiveConstant,
RowClickEventListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        eg.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        String isMulti = (String)view.getFormShowParameter().getCustomParam("ismulti");
        String entityNumber = (String)view.getFormShowParameter().getCustomParam("entitynumber");
        String selectedFields = (String)view.getFormShowParameter().getCustomParam("fields");
        String isOnlyDate = (String)view.getFormShowParameter().getCustomParam("is_only_date");
        this.getPageCache().put("ismulti", isMulti);
        this.getPageCache().put("entitynumber", entityNumber);
        this.getPageCache().put("fields", selectedFields);
        this.getPageCache().put("is_only_date", isOnlyDate);
        this.listShardingFields();
        this.showSelectedField();
    }

    private void showSelectedField() {
        String selectedFields = this.getPageCache().get("fields");
        if (StringUtils.isNotEmpty((String)selectedFields)) {
            String[] fields = selectedFields.split(",");
            IDataModel model = this.getModel();
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                for (String field : fields) {
                    if (!field.equals(((DynamicObject)entryEntity.get(i)).getString("fieldnumber"))) continue;
                    model.setValue("fieldchoose", (Object)true, i);
                }
            }
        }
    }

    private void listShardingFields() {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        String formId = this.getPageCache().get("entitynumber");
        String isOnlyDate = this.getPageCache().get("is_only_date");
        if (StringUtils.isNotEmpty((String)formId)) {
            List<Object> dps = ArchiveFormUtils.getEntityPropertiesForChoose(formId, false);
            if (Boolean.TRUE.toString().equalsIgnoreCase(isOnlyDate)) {
                dps = dps.stream().filter(DateTimeProp.class::isInstance).collect(Collectors.toList());
            }
            for (IDataEntityProperty dp : dps) {
                int rowIndex = model.createNewEntryRow("entryentity");
                model.setValue("fieldnumber", (Object)dp.getName(), rowIndex);
                model.setValue("fieldname", (Object)Optional.ofNullable(dp.getDisplayName()).orElseGet(() -> new LocaleString(dp.getName().toUpperCase())), rowIndex);
                model.setValue("fieldchoose", (Object)false, rowIndex);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        IDataModel model = this.getModel();
        int rowIndex = evt.getRow();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        String selectFieldName = ((DynamicObject)entryEntity.get(rowIndex)).getString("fieldnumber");
        boolean selected = (Boolean)model.getValue("fieldchoose");
        IPageCache pageCache = this.getPageCache();
        if (Boolean.FALSE.toString().equals(pageCache.get("ismulti"))) {
            pageCache.put("fields", "");
            this.cancelAllRow(entryEntity);
        }
        if (selected) {
            model.setValue("fieldchoose", (Object)false, rowIndex);
            this.buildFields(selectFieldName, false);
        } else {
            model.setValue("fieldchoose", (Object)true, rowIndex);
            this.buildFields(selectFieldName, true);
        }
    }

    private void cancelAllRow(DynamicObjectCollection entryEntity) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.getModel().setValue("fieldchoose", (Object)false, i);
        }
    }

    private void buildFields(String selectFieldName, boolean toSelected) {
        IPageCache pageCache = this.getPageCache();
        String cacheFields = pageCache.get("fields");
        if (StringUtils.isEmpty((String)cacheFields)) {
            cacheFields = "";
        }
        StringBuilder fields = new StringBuilder(cacheFields);
        if (toSelected) {
            if (fields.length() > 0) {
                fields.append(",");
            }
            fields.append(selectFieldName);
        } else {
            String[] afterFieldArray = (String[])Arrays.stream(cacheFields.split(",")).filter(field -> !selectFieldName.equals(field)).toArray(String[]::new);
            fields.setLength(0);
            fields.append(ActionUtil.joinArray((String[])afterFieldArray, (String)","));
        }
        pageCache.put("fields", fields.toString());
    }

    public void click(EventObject evt) {
        DynamicObjectCollection entryEntity;
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        String retData = null;
        if ("btnok".equals(key) && (entryEntity = this.getModel().getEntryEntity("entryentity")).size() > 0) {
            List dynamicObjectList = entryEntity.stream().filter(dy -> dy.getBoolean("fieldchoose")).collect(Collectors.toList());
            if (dynamicObjectList.size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u5c5e\u6027\u3002", (String)"ArchiveChooseFieldsEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (dynamicObjectList.size() > 3) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e9\u4e09\u4e2a\u5c5e\u6027\u3002", (String)"ArchiveChooseFieldsEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            IPageCache pageCache = this.getPageCache();
            retData = pageCache.get("fields");
        }
        this.getView().returnDataToParent(retData);
        this.getView().close();
    }
}

