/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveBillConfigUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.query.impl.BaseData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ArchiveIndexEditPlugin
extends AbstractFormPlugin
implements ArchiveConstant,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"indicesfields"});
        BasedataEdit billSet = (BasedataEdit)this.getView().getControl("billset");
        billSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BaseData billInfo = ArchiveBillConfigUtils.getBaseData(this.getModel(), "billset");
        if (Objects.isNull(billInfo)) {
            return;
        }
        if (ArchiveBillConfigUtils.existsApkTable(billInfo.getNumber())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"indicesfields"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control formControl = (Control)evt.getSource();
        String key = formControl.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BaseData billInfo = ArchiveBillConfigUtils.getBaseData(this.getModel(), "billset");
        if (billInfo == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f52\u6863\u5355\u636e\u3002", (String)"ArchiveIndexEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return;
        }
        if ("indicesfields".equals(key)) {
            this.showFieldChooseView(billInfo.getNumber(), model.getValue("indicesfields"));
        }
    }

    private void showFieldChooseView(String entityNumber, Object selectedFields) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bos_cbs_archi_fields");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.getCustomParams().put("ismulti", Boolean.TRUE.toString());
        fsp.getCustomParams().put("entitynumber", entityNumber);
        fsp.getCustomParams().put("fields", selectedFields);
        fsp.setCaption(ResManager.loadKDString((String)"\u5f52\u6863\u7d22\u5f15", (String)"ArchiveIndexEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "indicesfields"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String actionId = closedCallBackEvent.getActionId();
        Object retData = closedCallBackEvent.getReturnData();
        if (retData == null) {
            return;
        }
        if ("indicesfields".equals(actionId)) {
            model.setValue("indicesfields", retData);
        } else if ("billset".equals(actionId)) {
            ListSelectedRow row = ((ListSelectedRowCollection)retData).get(0);
            String entityNumber = row.getNumber();
            if (this.isDuplicate(entityNumber)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e[%s]\u5df2\u5b58\u5728\u5f52\u6863\u7d22\u5f15\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0\u3002", (String)"ArchiveIndexEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber}));
            } else {
                model.setValue("billset", row.getPrimaryKeyValue());
            }
        }
    }

    private boolean isDuplicate(String entityNumber) {
        QFilter qFilter = new QFilter("entitynumber", "=", (Object)entityNumber);
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_archi_index", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return Objects.nonNull(object);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldName = e.getProperty().getName();
        if (Objects.equals(fieldName, "billset")) {
            FormShowParameter formShowParameter = e.getFormShowParameter();
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "billset"));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object entityObj;
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (("save".equalsIgnoreCase(operateKey) || "saveandnew".equalsIgnoreCase(operateKey)) && (entityObj = this.getModel().getValue("billset")) == null) {
            args.setCancel(true);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5b9e\u4f53\u3002", (String)"ArchiveBillSetEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
    }
}

