/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.TwoSymbolSequence;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveInfo;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.db.archive.MCArchive;
import kd.bos.db.archive.RouteInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class ArchivePlanEditPlugin
extends AbstractFormPlugin
implements ArchiveConstant {
    private static Set<String> noSuffixes = new HashSet<String>(2);
    private static final Pattern regex = Pattern.compile("[A-Za-z][A-Za-z\\d]");

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
        Button btnCancel = (Button)this.getView().getControl("btn_cancel");
        btnCancel.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.buildCombo();
        this.parserLogicArchiveKey();
    }

    public void beforeBindData(EventObject e) {
        this.buildCombo();
        this.parserLogicArchiveKey();
        this.lockArchiveRoute();
    }

    private void lockArchiveRoute() {
        IDataModel model = this.getModel();
        Object pkValue = model.getDataEntity().getPkValue();
        QFilter qf = new QFilter("group", "=", pkValue);
        int count = ORM.create().count("ArchivePlanEditPlugin", "bos_cbs_archi_config", qf.toArray());
        if (count > 0) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"archiveroute"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String logicSuffix;
        String property = e.getProperty().getName();
        if ("archiveroute".equals(property) && StringUtils.isEmpty((String)(logicSuffix = (String)this.getModel().getValue("logicsuffix")))) {
            this.initLogicArchiveKey();
        }
    }

    private void initLogicArchiveKey() {
        IDataModel model = this.getModel();
        String archiveRoute = (String)model.getValue("archiveroute");
        if (StringUtils.isNotEmpty((String)archiveRoute)) {
            LogicArchiveRoute logicArchiveRoute = LogicArchiveRoute.of((String)archiveRoute);
            String realArchiveKey = logicArchiveRoute.getRealArchiveKey();
            QFilter qf = new QFilter("archiveroute", "like", (Object)(realArchiveKey + "%"));
            int count = ORM.create().count("ArchivePlanEditPluginAlgoKey", "bos_cbs_archi_plan", qf.and("isleaf", "=", (Object)true).toArray());
            if (count > 0) {
                model.setValue("logicsuffix", (Object)TwoSymbolSequence.toString(count - 1));
            }
        }
    }

    private void parserLogicArchiveKey() {
        LogicArchiveRoute logicArchiveRoute;
        IDataModel model = this.getModel();
        String archiveRoute = (String)model.getValue("archiveroute");
        if (StringUtils.isNotEmpty((String)archiveRoute) && (logicArchiveRoute = LogicArchiveRoute.of((String)archiveRoute)).isLogicArchiveRoute()) {
            model.setValue("archiveroute", (Object)logicArchiveRoute.getRealArchiveKey());
        }
    }

    private void buildCombo() {
        ComboEdit archiveRoute = (ComboEdit)this.getControl("archiveroute");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        Set<ArchiveInfo> archiveInfoSet = this.getAllArchiveInfoSet();
        for (ArchiveInfo archiveInfo : archiveInfoSet) {
            ComboItem comboItem = new ComboItem(new LocaleString(archiveInfo.getDesc()), archiveInfo.getKey());
            comboItems.add(comboItem);
        }
        archiveRoute.setComboItems(comboItems);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String logicSuffix;
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        MainEntityType dataEntityType = model.getDataEntityType();
        if ("save".equals(operateKey)) {
            String tableName = dataEntityType.getAlias();
            String dbRouteKey = dataEntityType.getDBRouteKey();
            DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
            List query = (List)DB.query((DBRoute)dbRoute, (String)("select fsuffix from " + tableName + " order by fsuffix asc"), rs -> {
                ArrayList<Long> ret = new ArrayList<Long>(16);
                while (rs.next()) {
                    ret.add(rs.getLong(1));
                }
                return ret;
            });
            if (query.isEmpty()) {
                model.setValue("suffix", (Object)1);
            } else {
                int size = query.size();
                long max = (Long)query.get(size - 1);
                if (max != (long)size) {
                    for (long i = 1L; i <= max; ++i) {
                        if (query.contains(i)) continue;
                        model.setValue("suffix", (Object)i);
                        break;
                    }
                } else {
                    model.setValue("suffix", (Object)(++max));
                }
            }
        }
        if (("save".equals(operateKey) || "submit".equals(operateKey) || "audit".equals(operateKey)) && StringUtils.isNotEmpty((String)(logicSuffix = (String)model.getValue("logicsuffix")))) {
            Matcher matcher = regex.matcher(logicSuffix = logicSuffix.toLowerCase());
            if (!matcher.matches()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u903b\u8f91\u5e93\u540e\u7f00\u662f\u4ee5\u5b57\u6bcd\u5f00\u5934\u7684\u4e24\u4e2a\u5b57\u7b26\u7ec4\u5408\u3002", (String)"ArchivePlanEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                model.setValue("logicsuffix", null);
                e.setCancel(true);
                return;
            }
            if (noSuffixes.contains('$' + logicSuffix)) {
                model.setValue("logicsuffix", (Object)TwoSymbolSequence.next(logicSuffix));
                view.invokeOperation("save");
                e.setCancel(true);
                return;
            }
            String archiveRoute = (String)model.getValue("archiveroute");
            if (StringUtils.isNotEmpty((String)archiveRoute)) {
                String archiveKey = archiveRoute + '$' + logicSuffix;
                if (ORM.create().exists("bos_cbs_archi_plan", new QFilter("archiveroute", "=", (Object)archiveKey).and(dataEntityType.getPrimaryKey().getName(), "!=", model.getDataEntity().getPkValue()).toArray())) {
                    model.setValue("logicsuffix", (Object)TwoSymbolSequence.next(logicSuffix));
                    view.invokeOperation("save");
                    e.setCancel(true);
                    return;
                }
                model.setValue("archiveroute", (Object)archiveKey);
                model.setValue("status", (Object)"C");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs ae) {
        String operateKey = ae.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey) || "audit".equals(operateKey)) {
            this.parserLogicArchiveKey();
            this.getModel().setDataChanged(false);
            this.getView().invokeOperation("close");
        }
    }

    private Set<ArchiveInfo> getAllArchiveInfoSet() {
        List routeInfoList = MCArchive.get();
        TreeSet<ArchiveInfo> archiveInfoSet = new TreeSet<ArchiveInfo>(Comparator.comparing(ArchiveInfo::getKey));
        for (RouteInfo routeInfo : routeInfoList) {
            String routeKey = routeInfo.getRouteKey();
            List archiveInfo = routeInfo.getArchiveInfo();
            for (ArchiveInfo archive : archiveInfo) {
                if (routeKey.equals(archive.getKey())) continue;
                archiveInfoSet.add(archive);
            }
        }
        return archiveInfoSet;
    }

    public void click(EventObject evt) {
        Control evtSource = (Control)evt.getSource();
        String key = evtSource.getKey();
        if ("btn_cancel".equals(key)) {
            this.getModel().setDataChanged(false);
            this.getView().invokeOperation("close");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getModel().setDataChanged(false);
    }

    static {
        noSuffixes.add("$ai");
        noSuffixes.add("$am");
        noSuffixes.addAll(Arrays.asList("$a0,$a1,$a2,$a3,$a4,$a5,$a6,$a7,$a8,$a9,$pk".split(",")));
    }
}

