/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import java.util.EventObject;
import kd.bos.archive.ArchiveManager;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.archive.DBArchiveRuntime;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class ArchiveSchDetailEditPlugin
extends AbstractFormPlugin
implements SetFilterListener,
ArchiveConstant {
    Log logger = LogFactory.getLog(ArchiveSchDetailEditPlugin.class);

    public void beforeBindData(EventObject e) {
        BillList taskList = (BillList)this.getView().getControl("billlistap");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        taskList.setFilter(new QFilter("entitynumber", "=", formShowParameter.getCustomParam("entityNumber")).and(new QFilter("archiveroute", "=", formShowParameter.getCustomParam("archiveRoute")).and(new QFilter("reversestatus", "=", (Object)"0").and(new QFilter("tasktype", "=", (Object)ArchiveTaskTypeEnum.ARCHIVE.getKey())))));
    }

    public void registerListener(EventObject e) {
        IFormView view = this.getView();
        BillList taskList = (BillList)view.getControl("billlistap");
        taskList.addSetFilterListener((SetFilterListener)this);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        setFilterEvent.getCustomQFilters().add(new QFilter("entitynumber", "=", formShowParameter.getCustomParam("entityNumber")).and(new QFilter("archiveroute", "=", formShowParameter.getCustomParam("archiveRoute")).and(new QFilter("reversestatus", "=", (Object)"0").and(new QFilter("tasktype", "=", (Object)ArchiveTaskTypeEnum.ARCHIVE.getKey())))));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if ("anti_archive".equals(operateKey)) {
            if (DBArchiveRuntime.get().getArchiveAccountEnable()) {
                String confirmTip = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u53cd\u5f52\u6863\u3002", (String)"ArchiveSchDetailEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("ensure_anti_archive");
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u6570\u636e\u5f52\u6863\u914d\u7f6e\u3002", (String)"ArchiveSchDetailEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && messageBoxClosedEvent.getCallBackId().equals("ensure_anti_archive")) {
            this.getView().invokeOperation("ensure_anti_archive");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs ae) {
        String operateKey = ae.getOperateKey();
        if ("ensure_anti_archive".equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            Object primaryKeyValue = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            try {
                ArchiveManager.get().addArchiveReverseTaskByBatchNo(((Long)primaryKeyValue).longValue());
            }
            catch (Exception e) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef:%s\u3002", (String)"ArchiveSchDetailEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]), e.getMessage()));
                this.logger.error("Anti-Archive error:" + e.getMessage(), (Throwable)e);
            }
        }
    }
}

