/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.cbs.plugin.archive.common.util.ArchiveOperateLog;
import kd.bos.cbs.plugin.archive.edit.ArchiveSchemaBaseEditPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ArchiveSchemaCleanEditPlugin
extends ArchiveSchemaBaseEditPlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IBillModel billModel = (IBillModel)this.getModel();
        long id = DB.genGlobalLongId();
        billModel.setPKValue((Object)id);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        IDataModel model;
        DynamicObjectCollection entryEntity;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IFormView view = this.getView();
        if ("save".equals(operateKey) && !(entryEntity = (model = this.getModel()).getEntryEntity("entryentity")).isEmpty()) {
            HashMap<Object, String> pkAndNumberMap = new HashMap<Object, String>(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                DynamicObject config = entry.getDynamicObject("config");
                if (config == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6e05\u9664\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArchiveSchemaCleanEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                pkAndNumberMap.put(config.getPkValue(), config.getString("number"));
            }
            Object pkValue = model.getDataEntity().getPkValue();
            QFilter qFilter = new QFilter("id", "!=", pkValue);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)model.getDataEntityType().getName(), (String)"entryentity.config", (QFilter[])qFilter.and("movingtype", "=", (Object)"1").toArray());
            HashSet<Object> loadEntryPkSet = new HashSet<Object>(load.length * 2);
            for (DynamicObject dynamicObject : load) {
                DynamicObjectCollection entryLoad = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject object : entryLoad) {
                    loadEntryPkSet.add(object.getDynamicObject("config").getPkValue());
                }
            }
            ArrayList containPk = new ArrayList();
            pkAndNumberMap.forEach((k, v) -> {
                if (loadEntryPkSet.contains(k)) {
                    containPk.add(k);
                }
            });
            if (!containPk.isEmpty()) {
                StringBuilder tips = new StringBuilder(50 * containPk.size());
                for (int i = 0; i < containPk.size(); ++i) {
                    if (i > 0) {
                        tips.append(',');
                    }
                    tips.append((String)pkAndNumberMap.get(containPk.get(i)));
                }
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u88ab\u5176\u4ed6\u8c03\u5ea6\u8c03\u7528\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"ArchiveDispatcherEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]), tips));
                e.setCancel(true);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IDataModel model = this.getModel();
        String operateKey = args.getOperateKey();
        StringBuilder opDesc = new StringBuilder(512);
        opDesc.append("CleanSchemaNumber:").append(model.getValue("number"));
        if ("save".equals(operateKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            opDesc.append("\nEntryEntity:\nCleanConfig:");
            entryEntity.forEach(dynamicObject -> {
                opDesc.append('\n');
                DynamicObject archiveConfig = dynamicObject.getDynamicObject("config");
                opDesc.append(archiveConfig.get("number"));
            });
        }
        ArchiveOperateLog.insertOperateLog(args, this.getModel().getDataEntityType().getName(), this.getModel().getDataEntityType().getDisplayName().getLocaleValue(), opDesc.toString(), this.getView(), false);
    }
}

