/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.list;

import java.util.EventObject;
import java.util.LinkedList;
import kd.bos.archive.config.AccountEnable;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveBillConfigUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class ArchiveBillSetListPlugin
extends AbstractListPlugin
implements ArchiveConstant {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("id desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        IFormView view = this.getView();
        String operateKey = formOperate.getOperateKey();
        if (("modify".equals(operateKey) || "new".equals(operateKey) || "disable".equals(operateKey) || "enable".equals(operateKey) || "execute".equals(operateKey)) && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("delete".equalsIgnoreCase(formOperate.getOperateKey())) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            LinkedList<String> errorMsgList = new LinkedList<String>();
            for (ListSelectedRow selectedRow : listSelectedData) {
                DynamicObject billSet = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"bos_cbs_archi_billset");
                String errorMsg = this.getErrorMsg(billSet);
                if (StringUtils.isEmpty((String)errorMsg)) continue;
                errorMsgList.add(errorMsg);
            }
            if (!CollectionUtils.isEmpty(errorMsgList)) {
                int size = listSelectedData.size();
                String title = String.format(ResManager.loadKDString((String)"\u5171%1s\u6761\u5355\u636e\uff0c\u5220\u9664\u6210\u529f0\u6761\uff0c\u5931\u8d25%2s\u6761\u3002", (String)"ArchiveBillSetListPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]), size, size);
                view.showMessage(title, String.join((CharSequence)"\n", errorMsgList), MessageTypes.Default);
                args.setCancel(true);
            }
        }
    }

    private String getErrorMsg(DynamicObject billSet) {
        boolean isStore = billSet.getBoolean("is_store");
        String entityNumber = billSet.getString("number");
        String errMsg = "";
        if (ArchiveBillConfigUtils.existIndexConfig(entityNumber)) {
            errMsg = ResManager.loadKDString((String)"%s\uff1a\u5df2\u5b58\u5728\u5f52\u6863\u7d22\u5f15\u914d\u7f6e\uff0c\u8bf7\u5148\u5220\u9664\u5f52\u6863\u7d22\u5f15\u914d\u7f6e\u518d\u64cd\u4f5c\u3002", (String)"ArchiveBillSetListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber});
        } else if (ArchiveBillConfigUtils.existCascadeConfig(entityNumber)) {
            errMsg = ResManager.loadKDString((String)"%s\uff1a\u5df2\u5b58\u5728\u5f52\u6863\u7ea7\u8054\u914d\u7f6e\uff0c\u8bf7\u5148\u5220\u9664\u5f52\u6863\u7ea7\u8054\u914d\u7f6e\u518d\u64cd\u4f5c\u3002", (String)"ArchiveBillSetListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber});
        } else if (ArchiveBillConfigUtils.existsArchiveConfig(entityNumber) && isStore) {
            errMsg = ResManager.loadKDString((String)"%s\uff1a\u5df2\u5b58\u5728\u5f52\u6863\u89c4\u5219\uff0c\u8bf7\u5148\u5220\u9664\u5f52\u6863\u89c4\u5219\u518d\u64cd\u4f5c\u3002", (String)"ArchiveBillSetListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber});
        } else if (ArchiveBillConfigUtils.existsArchiveConfig(entityNumber) && !isStore) {
            errMsg = ResManager.loadKDString((String)"%s\uff1a\u5df2\u5b58\u5728\u6e05\u9664\u89c4\u5219\uff0c\u8bf7\u5148\u5220\u9664\u6e05\u9664\u89c4\u5219\u518d\u64cd\u4f5c\u3002", (String)"ArchiveBillSetListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber});
        }
        return errMsg;
    }
}

