/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveManager;
import kd.bos.archive.config.AccountEnable;
import kd.bos.archive.enums.ArchiveConfigMovingTypeEnum;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveOperateLog;
import kd.bos.cbs.plugin.archive.common.util.BasedataRefValidator;
import kd.bos.cbs.plugin.tools.LicenseUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.service.ActionUtil;

public class ArchiveConfigListPlugin
extends AbstractListPlugin
implements ArchiveConstant {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseUtils.checkPerformGroup(e, "CBS_ARCHIVE");
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("movingtype", "=", (Object)ArchiveConfigMovingTypeEnum.ARCHIVE.getKey()));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        Long id;
        ListSelectedRowCollection listSelectedData;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if (("modify".equals(operateKey) || "new".equals(operateKey) || "disable".equals(operateKey) || "enable".equals(operateKey) || "execute".equals(operateKey)) && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if ("disable".equals(operateKey) || "delete".equals(operateKey)) {
            listSelectedData = e.getListSelectedData();
            ArrayList<String> runningNumberList = new ArrayList<String>(listSelectedData.size());
            for (ListSelectedRow selectedRow : listSelectedData) {
                Long id2 = (Long)selectedRow.getPrimaryKeyValue();
                if (ArchiveManager.get().checkConfigEnd(id2.longValue())) continue;
                runningNumberList.add(selectedRow.getNumber());
            }
            if (!runningNumberList.isEmpty()) {
                String runningNumbers = ActionUtil.joinArray((String[])runningNumberList.toArray(new String[0]), (String)",");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u914d\u7f6e\u6b63\u5728\u540e\u53f0\u8c03\u5ea6\u4efb\u52a1\u4e2d\u8fd0\u884c\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"ArchiveConfigListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]), runningNumbers));
                e.setCancel(true);
                return;
            }
        }
        if ("delete".equalsIgnoreCase(operateKey)) {
            listSelectedData = e.getListSelectedData();
            for (ListSelectedRow selectedRow : listSelectedData) {
                id = (Long)selectedRow.getPrimaryKeyValue();
                List<String> errMsgList = BasedataRefValidator.validate("bos_cbs_archi_config", new Object[]{id}, Arrays.asList("bos_cbs_archi_schema_clr", "bos_cbs_archi_schedule"), null);
                if (CollectionUtils.isEmpty(errMsgList)) continue;
                this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u51fa\u9519\u3002", (String)"ArchiveConfigListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]), String.join((CharSequence)"\n", errMsgList), MessageTypes.Default);
                e.setCancel(true);
                return;
            }
        }
        if ("enable".equals(operateKey)) {
            listSelectedData = e.getListSelectedData();
            for (ListSelectedRow selectedRow : listSelectedData) {
                id = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject queryObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_cbs_archi_config");
                String number = queryObj.getString("number");
                DynamicObject database = queryObj.getDynamicObject("group");
                if (!Objects.isNull(database)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u8bf7\u5148\u5173\u8054\u5f52\u6863\u5e93\uff0c\u518d\u542f\u7528\u5f52\u6863\u89c4\u5219\u3002", (String)"ArchiveConfigListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]), number));
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null) {
            Map billNos = afterDoOperationEventArgs.getOperationResult().getBillNos();
            List successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().stream().map(id -> Long.parseLong(id.toString())).collect(Collectors.toList());
            StringBuilder opDesc = new StringBuilder(successPkIds.size() * 128);
            if (!successPkIds.isEmpty()) {
                opDesc.append("ArchiveId:\tArchiveConfigNumber:\n");
                billNos.forEach((k, v) -> {
                    if (successPkIds.contains(Long.parseLong(k.toString()))) {
                        opDesc.append(k).append('\t').append((String)v).append('\n');
                    }
                });
            }
            if (opDesc.length() > 0) {
                ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
                ArchiveOperateLog.insertOperateLog(afterDoOperationEventArgs, showParameter.getBillFormId(), showParameter.getCaption(), opDesc.toString(), this.getView(), true);
            }
        }
    }
}

