/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.list;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.archive.config.AccountEnable;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.tools.LicenseUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.xdb.tablemanager.meta.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveEntityRecordListPlugin
extends AbstractListPlugin
implements ArchiveConstant {
    private static Logger log = LoggerFactory.getLogger(ArchiveEntityRecordListPlugin.class);
    private static Class<?> linkEntryType;
    private static Class<?> mulBasedataPropType;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseUtils.checkPerformGroup(e, "CBS_ARCHIVE");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs hyperLinkClickArgs) {
        String fieldName = hyperLinkClickArgs.getFieldName();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        if ("archivecount".equals(fieldName)) {
            if (!AccountEnable.isEnable()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                hyperLinkClickArgs.setCancel(true);
                return;
            }
            if (Objects.nonNull(currentSelectedRowInfo)) {
                Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_cbs_archi_entity", (String)"entitynumber,archiveroute", (QFilter[])new QFilter("id", "=", primaryKeyValue).toArray());
                String entityNumber = dynamicObject.getString("entitynumber");
                String archiveRoute = dynamicObject.getString("archiveroute");
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                FormShowParameter fps = new FormShowParameter();
                fps.setFormId("bos_cbs_archi_reverse");
                fps.setCaption(dataEntityType.getDisplayName().toString());
                fps.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                Map customParams = fps.getCustomParams();
                customParams.put("id", primaryKeyValue);
                customParams.put("entityNumber", entityNumber);
                customParams.put("route", dataEntityType.getDBRouteKey());
                customParams.put("archiveRoute", archiveRoute);
                this.getView().showForm(fps);
            }
        } else if ("entitynumber_name".equals(fieldName) && Objects.nonNull(currentSelectedRowInfo)) {
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_cbs_archi_entity", (String)"entitynumber,archiveroute", (QFilter[])new QFilter("id", "=", primaryKeyValue).toArray());
            String entityNumber = dynamicObject.getString("entitynumber");
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId(entityNumber);
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)lsp);
        }
        hyperLinkClickArgs.setCancel(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate op = (FormOperate)args.getSource();
        String operateKey = op.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        if ("column_sync".equals(operateKey) && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("column_sync".equals(operateKey)) {
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_cbs_archi_entity", (String)"entitynumber,archiveroute,database_type", (QFilter[])new QFilter("id", "=", primaryKeyValue).toArray());
            String dataBaseType = dynamicObject.getString("database_type");
            if (StringUtils.isEmpty((String)dataBaseType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u5e93\u7c7b\u578b\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u66f4\u65b0\u5b57\u6bb5\u7ed3\u6784\u3002", (String)"ArchiveConfigEditPlugin_28", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (!"db".equals(dataBaseType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5bf9\u975e\u6570\u636e\u5e93\u7c7b\u578b\u7684\u8868\u8fdb\u884c\u66f4\u65b0\u3002", (String)"ArchiveConfigEditPlugin_29", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String entityNumber = dynamicObject.getString("entitynumber");
            IDataEntityType dt = ORM.create().getDataEntityType(entityNumber);
            DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
            String archiveRouteStr = dynamicObject.getString("archiveroute");
            LogicArchiveRoute logicArchiveRoute = LogicArchiveRoute.of((String)archiveRouteStr);
            String logicSuffix = logicArchiveRoute.getLogicSuffix();
            String realArchiveKey = logicArchiveRoute.getRealArchiveKey();
            DBRoute archiveRoute = logicArchiveRoute.isCurrentArchive() ? dbRoute : DBRoute.of((String)realArchiveKey);
            ArrayList<String> updatedFields = new ArrayList<String>();
            StringBuilder checkResult = new StringBuilder(ResManager.loadKDString((String)"\u5b57\u6bb5\u66f4\u65b0\u6210\u529f\u3002", (String)"ArchiveConfigEditPlugin_30", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            try {
                this.checkCloumnSame(dt, logicSuffix, dbRoute, archiveRoute, updatedFields);
                this.travesalAndSyncColumn(dt, dbRoute, archiveRoute, logicSuffix, updatedFields);
                if (!updatedFields.isEmpty()) {
                    String updatedFieldDetailMsg = ResManager.loadKDString((String)"\u66f4\u65b0\u7684\u5b57\u6bb5\uff1a", (String)"ArchiveConfigEditPlugin_31", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    checkResult.append(String.format("%s %s", updatedFieldDetailMsg, JSONUtils.toString(updatedFields)));
                }
            }
            catch (IOException | SQLException e) {
                log.error("update field failed: " + e.getMessage(), (Throwable)e);
                this.getView().showErrMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u5b57\u6bb5\u5931\u8d25\uff0ccolumn_sync error\u3002", (String)"ArchiveConfigEditPlugin_32", (String)"bos-cbs-plugin", (Object[])new Object[0]), e.getMessage());
                return;
            }
            this.getView().showSuccessNotification(checkResult.toString());
        }
        super.beforeDoOperation(args);
    }

    private void travesalAndSyncColumn(IDataEntityType dt, DBRoute dbRoute, DBRoute archiveRoute, String logicSuffix, List<String> updatedFields) throws SQLException, IOException {
        DataEntityPropertyCollection dps = dt.getProperties();
        int n = dps.size();
        for (int i = 0; i < n; ++i) {
            Class<?> cls;
            IDataEntityProperty dp = (IDataEntityProperty)dps.get(i);
            if (!(dp instanceof ICollectionProperty)) continue;
            IDataEntityType itemDT = ((ICollectionProperty)dp).getItemType();
            if (IEntryType.class.isAssignableFrom(itemDT.getClass()) && itemDT.getAlias() != null && itemDT.getAlias().trim().length() > 0 && !linkEntryType.isAssignableFrom(cls = itemDT.getClass())) {
                String oriTableName = itemDT.getAlias();
                String logicTableName = oriTableName + logicSuffix;
                this.checkCloumnSame(itemDT, logicSuffix, dbRoute, archiveRoute, updatedFields);
                this.travesalAndSyncColumn(itemDT, dbRoute, archiveRoute, logicSuffix, updatedFields);
            }
            if (!mulBasedataPropType.isAssignableFrom(dp.getClass()) || itemDT.getAlias() == null || itemDT.getAlias().trim().length() <= 0) continue;
            this.checkCloumnSame(itemDT, logicSuffix, dbRoute, archiveRoute, updatedFields);
        }
    }

    private void checkCloumnSame(IDataEntityType dt, String logicSuffix, DBRoute route, DBRoute archiveRoute, List<String> updatedField) throws SQLException, IOException {
        String oriTable = dt.getAlias();
        String logicTable = oriTable + logicSuffix;
        boolean logicTableExist = TableManager.get().existTable(archiveRoute, logicTable);
        if (!logicTableExist) {
            return;
        }
        List oriColumns = TableManager.get().getColumns(route, oriTable);
        List archiColumns = TableManager.get().getColumns(archiveRoute, logicTable);
        List lackerColumn = TableManager.get().findLackedColumn(oriColumns, archiColumns);
        if (lackerColumn.size() > 0) {
            for (Column column : lackerColumn) {
                TableManager.get().addColumn(archiveRoute, logicTable, column);
            }
        }
        lackerColumn.forEach(item -> updatedField.add(item.getColumnName()));
    }

    static {
        try {
            linkEntryType = Class.forName("kd.bos.entity.LinkEntryType");
            mulBasedataPropType = Class.forName("kd.bos.entity.property.MulBasedataProp");
        }
        catch (ClassNotFoundException e) {
            log.error("class forname error: " + e.getMessage(), (Throwable)e);
        }
    }
}

