/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.list;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveManager;
import kd.bos.archive.config.AccountEnable;
import kd.bos.archive.service.ArchiveService;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveOperateLog;
import kd.bos.cbs.plugin.archive.common.util.ArchiveScheduleUtils;
import kd.bos.cbs.plugin.tools.OperateLogUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.service.ActionUtil;

public class ArchiveSchemaBaseListPlugin
extends AbstractListPlugin
implements ArchiveConstant {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        ListSelectedRowCollection listSelectedData;
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IFormView view = this.getView();
        if (("modify".equals(operateKey) || "new".equals(operateKey) || "disable".equals(operateKey) || "enable".equals(operateKey) || "execute".equals(operateKey)) && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if ("enable".equals(operateKey) || "disable".equals(operateKey)) {
            if (!this.validateArchiveEnable(e)) {
                return;
            }
            if ("disable".equals(operateKey)) {
                return;
            }
            listSelectedData = e.getListSelectedData();
            for (Iterator selectedRow : listSelectedData) {
                DynamicObject queryObj = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"bos_cbs_archi_schema");
                PlanInfo planInfo = ArchiveScheduleUtils.getPlanInfo(queryObj.getString("scheduleplanid"));
                if (!Objects.nonNull(planInfo) || planInfo.getRepeatMode() != RepeatModeEnum.NONE) continue;
                ArchiveScheduleUtils.execute(selectedRow.getPrimaryKeyValue());
            }
        }
        if ("delete".equals(operateKey)) {
            listSelectedData = e.getListSelectedData();
            ArrayList<Long> runningPKList = new ArrayList<Long>(listSelectedData.size());
            for (ListSelectedRow selectedRow : listSelectedData) {
                long fid = (Long)selectedRow.getPrimaryKeyValue();
                if (ArchiveManager.get().checkScheduleEnd(fid)) continue;
                runningPKList.add(fid);
            }
            if (!runningPKList.isEmpty()) {
                DynamicObject[] load;
                ArrayList<String> runningScheduleList = new ArrayList<String>(runningPKList.size());
                for (DynamicObject o : load = BusinessDataServiceHelper.load((String)"bos_cbs_archi_schema", (String)"number", (QFilter[])new QFilter("id", "in", runningPKList).toArray())) {
                    runningScheduleList.add(o.getString("number"));
                }
                String running = ActionUtil.joinArray((String[])runningScheduleList.toArray(new String[0]), (String)",");
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u8c03\u5ea6\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ArchiveDispatcherEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), running));
                e.setCancel(true);
            }
        } else if ("execute".equalsIgnoreCase(operateKey)) {
            ArchiveService.get().submitChangeTask(operateKey);
            listSelectedData = e.getListSelectedData();
            for (ListSelectedRow row : listSelectedData) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_archi_schema", (String)"number,enable,entryentity.id, entryentity.config, entryentity.config.enable", (QFilter[])new QFilter("id", "=", row.getPrimaryKeyValue()).toArray());
                String enable = dynamicObject.getString("enable");
                String number = dynamicObject.getString("number");
                DynamicObjectCollection entryentity = (DynamicObjectCollection)dynamicObject.get("entryentity");
                if (!entryentity.isEmpty()) {
                    boolean hasEnable = false;
                    for (DynamicObject entryitem : entryentity) {
                        String configEnable = ((DynamicObject)entryitem.get("config")).getString("enable");
                        if (!Objects.equals("1", configEnable)) continue;
                        hasEnable = true;
                    }
                    if (!hasEnable) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u672a\u542f\u7528\u3002", (String)"ArchiveDispatcherEditPlugin_15", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                }
                if (!Objects.equals("0", enable)) continue;
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u8c03\u5ea6\u8ba1\u5212\u672a\u542f\u7528\u3002", (String)"ArchiveDispatcherEditPlugin_11", (String)"bos-cbs-plugin", (Object[])new Object[0]), number));
                e.setCancel(true);
                return;
            }
            listSelectedData.stream().map(ListSelectedRow::getPrimaryKeyValue).forEach(ArchiveScheduleUtils::execute);
            this.recordLog(listSelectedData);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u5df2\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u8fd0\u884c\u65e5\u5fd7\u5217\u8868\u3002", (String)"ArchiveDispatcherEditPlugin_10", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
    }

    public void recordLog(ListSelectedRowCollection listSelectedData) {
        String entityNumber = ((ListView)this.getView()).getBillFormId();
        String opName = ResManager.loadKDString((String)"\u624b\u5de5\u6267\u884c", (String)"ArchiveSchemaBaseListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]);
        for (ListSelectedRow selectedDatum : listSelectedData) {
            String entityDisplayName = ((ListView)this.getView()).getFormShowParameter().getCaption();
            String opDesc = ResManager.loadKDString((String)"\u7f16\u7801\uff1a%1$s\uff0c%2$s\u624b\u5de5\u6267\u884c\u6210\u529f\u3002", (String)"ArchiveSchemaBaseListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            opDesc = String.format(opDesc, selectedDatum.getNumber(), entityDisplayName);
            MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u7f16\u7801\uff1a%1$s\uff0c%2$s\u624b\u5de5\u6267\u884c\u6210\u529f\u3002", "ArchiveSchemaBaseListPlugin_2", "bos-cbs-plugin");
            OperateLogUtil.insertSimpleOperateLog(this.getView(), entityNumber, "execute", opDesc, RequestContext.get().getOrgId(), selectedDatum.getNumber(), langEnumBridge, selectedDatum.getNumber(), entityDisplayName);
        }
    }

    private boolean validateArchiveEnable(BeforeDoOperationEventArgs e) {
        if (!AccountEnable.isAccountEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u6570\u636e\u5f52\u6863\u914d\u7f6e\u3002", (String)"ArchiveDispatcherEditPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            e.setCancel(true);
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null) {
            ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            List successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().stream().map(id -> Long.parseLong(id.toString())).collect(Collectors.toList());
            StringBuilder opDesc = new StringBuilder(successPkIds.size() * 128);
            if (!successPkIds.isEmpty()) {
                opDesc.append("ArchiveScheduleId:\tArchiveScheduleNumber:\n");
                selectedRows.forEach(selectRow -> {
                    long id = Long.parseLong(selectRow.getPrimaryKeyValue().toString());
                    if (successPkIds.contains(id)) {
                        if ("delete".equals(afterDoOperationEventArgs.getOperateKey())) {
                            opDesc.append(selectRow.getPrimaryKeyValue()).append('\t').append("null").append('\n');
                        } else {
                            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)showParameter.getBillFormId());
                            opDesc.append(selectRow.getPrimaryKeyValue()).append('\t').append(dynamicObject.getString("number")).append('\n');
                        }
                    }
                });
            }
            if (opDesc.length() > 0) {
                ArchiveOperateLog.insertOperateLog(afterDoOperationEventArgs, showParameter.getBillFormId(), showParameter.getCaption(), opDesc.toString(), this.getView(), true);
            }
        }
    }
}

