/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.list;

import java.sql.SQLException;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.archive.config.AccountEnable;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskStatusEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.repository.ArchiveSubTaskRepository;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.service.ArchiveService;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.BaseConfiguration;
import kd.bos.archive.task.config.ConfigurationFactory;
import kd.bos.archive.task.service.elasticsearch.config.ESConfig;
import kd.bos.cbs.plugin.archive.common.util.ArchiveFormUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.archive.ArchiveName;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ArchiveTaskListPlugin
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    /*
     * Enabled aggressive block sorting
     */
    public void itemClick(ItemClickEvent evt) {
        IFormView view = this.getView();
        String itemKey = evt.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        if (("bar_retry".equals(itemKey) || "bar_terminate".equals(itemKey)) && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return;
        }
        if (!Objects.nonNull(currentSelectedRowInfo)) return;
        long primaryKeyValue = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_cbs_archi_task", (String)"entitynumber,taskstatus,tasknode,tasktype", (QFilter[])new QFilter("id", "=", (Object)primaryKeyValue).toArray());
        String taskStatus = dynamicObject.getString("taskstatus");
        String entityNumber = dynamicObject.getString("entitynumber");
        String tasknode = dynamicObject.getString("tasknode");
        String tasktype = dynamicObject.getString("tasktype");
        if (itemKey.equals("bar_retry")) {
            ArchiveService.get().submitChangeTask(entityNumber);
            if (!taskStatus.equals(ArchiveTaskStatusEnum.EXECUTING.getKey()) && !taskStatus.equals(ArchiveTaskStatusEnum.FAILED.getKey())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5931\u8d25\u6216\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u53ef\u91cd\u8bd5\uff0c\u5176\u5b83\u72b6\u6001\u64cd\u4f5c\u65e0\u6548\u3002", (String)"ArchiveTaskListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            Boolean lockValid = ArchiveFormUtils.taskLock(entityNumber);
            if (lockValid == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"ZK\u66fe\u4e2d\u65ad\uff0c\u672a\u6b63\u786e\u91ca\u653e\u9501\uff0c\u8bf7\u7b49\u5f85\u91ca\u653e\u6216\u8bf7\u8fdbmonitor\u89e3\u9501\u3002", (String)"ShardingTaskEditPlugin_9", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (!lockValid.booleanValue()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5e38\u6267\u884c\u4e2d\uff0c\u64cd\u4f5c\u65e0\u6548\u3002", (String)"ShardingTaskEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            ArchiveSplitTaskRepository.get().setSplitTaskUnexecuted(primaryKeyValue);
            List splitTaskEntityList = ArchiveSplitTaskRepository.get().loadSplitTaskList(primaryKeyValue);
            List idList = splitTaskEntityList.stream().map(ArchiveSplitTaskEntity::getId).collect(Collectors.toList());
            idList.add(primaryKeyValue);
            ArchiveSubTaskRepository.get().setSubTaskUnexecuted(idList);
            int ret = ArchiveTaskRepository.get().setTaskUnexecuted(primaryKeyValue);
            if (ret > 0) {
                ArchiveTaskRepository.get().updateTaskRetryInfo(0, primaryKeyValue);
                view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u6267\u884c\u91cd\u8bd5\u64cd\u4f5c\uff0c\u6b63\u5728\u901a\u77e5\u4efb\u52a1\u91cd\u542f\u3002", (String)"ShardingTaskEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
            ArchiveFormUtils.releaseTaskLock();
            view.invokeOperation("refresh");
            return;
        }
        if (!"bar_terminate".equals(itemKey)) return;
        if (this.isCanTerminate(entityNumber, taskStatus, tasktype, tasknode)) {
            String confirmTip = ResManager.loadKDString((String)"\u7ec8\u6b62\u64cd\u4f5c\u540e\u5f52\u6863\u8fc7\u7a0b\u6240\u6709\u4e2d\u95f4\u8868\u90fd\u4f1a\u88ab\u5220\u9664\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ArchiveTaskListPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("terminateArchive");
            view.showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
            return;
        }
        view.showTipNotification(ResManager.loadKDString((String)"\u5931\u8d25\u4e14\u672a\u53d1\u751f\u6570\u636e\u8fc1\u79fb\u7684\u4efb\u52a1\u53ef\u7ec8\u6b62\uff0c\u5176\u5b83\u72b6\u6001\u64cd\u4f5c\u65e0\u6548\u3002", (String)"ArchiveTaskListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        BillList billList;
        ListSelectedRow currentSelectedRowInfo;
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && messageBoxClosedEvent.getCallBackId().equals("terminateArchive") && Objects.nonNull(currentSelectedRowInfo = (billList = (BillList)this.getControl("billlistap")).getCurrentSelectedRowInfo())) {
            long pkValue = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
            ArchiveTaskEntity archiveTaskEntity = ArchiveTaskRepository.get().loadTask(pkValue);
            if (this.isCanTerminate(archiveTaskEntity.getEntitynumber(), archiveTaskEntity.getTaskstatus().getKey(), archiveTaskEntity.getTasktype().getKey(), archiveTaskEntity.getTasknode().getKey())) {
                ArchiveSplitTaskRepository.get().deleteSplitTask(pkValue);
                int success = ArchiveTaskRepository.get().setTaskTerminated(pkValue);
                if (success > 0) {
                    if (archiveTaskEntity.getParentid() != 0L) {
                        ArchiveTaskRepository.get().decrBarriercount(archiveTaskEntity.getParentid());
                    }
                    ArchiveTaskEntity taskEntity = ArchiveTaskRepository.get().loadTask(pkValue);
                    BaseConfiguration configuration = ConfigurationFactory.createConfig((ArchiveTaskEntity)taskEntity);
                    String mainMvTable = ArchiveName.of((String)configuration.getMainTable()).getArchivePkmTable((long)configuration.getConfigEntity().getSuffix());
                    try {
                        TableManager.get().dropTable(configuration.getFromRoute(), mainMvTable);
                    }
                    catch (SQLException e) {
                        ArchiveTaskRepository.get().setNextTaskstatus(taskEntity.getId(), ArchiveTaskStatusEnum.TERMINATED, ArchiveTaskStatusEnum.FAILED);
                        throw new KDException(BosErrorCode.bOS, new Object[]{e});
                    }
                    ArchiveLogPublish.get().publishLog(taskEntity.getId(), taskEntity.getEntitynumber(), ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u6b62\u6210\u529f\u3002", (String)"ArchiveTaskListPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]), "ArchiveTerminal");
                    this.getView().invokeOperation("refresh");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u6b62\u6210\u529f\u3002", (String)"ArchiveTaskListPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e0\u6548\uff0c\u4efb\u52a1\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ArchiveTaskListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e0\u6548\uff0c\u4efb\u52a1\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ArchiveTaskListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean isCanTerminate(String entityNumber, String taskStatus, String tasktype, String tasknode) {
        boolean isCanTerm = false;
        if (!(ArchiveService.isLogEntity((String)entityNumber).booleanValue() && ESConfig.getDcESServer().isEslogEnable() || !taskStatus.equals(ArchiveTaskStatusEnum.FAILED.getKey()))) {
            if (tasktype.equals(ArchiveTaskTypeEnum.ARCHIVE.getKey()) || tasktype.equals(ArchiveTaskTypeEnum.UNARCHIVE.getKey())) {
                if (tasknode.equals(ArchiveTaskNodeEnum.TASKSTART.getKey()) || tasknode.equals(ArchiveTaskNodeEnum.PKINSERT.getKey()) || tasknode.equals(ArchiveTaskNodeEnum.TBSTRUCTCHK.getKey())) {
                    isCanTerm = true;
                }
            } else if (tasktype.equals(ArchiveTaskTypeEnum.DATASYNC.getKey()) || tasktype.equals(ArchiveTaskTypeEnum.ARCHIVESYNC.getKey())) {
                if (tasknode.equals(ArchiveTaskNodeEnum.TASKSTART.getKey()) || tasknode.equals(ArchiveTaskNodeEnum.PKINSERT.getKey()) || tasknode.equals(ArchiveTaskNodeEnum.TBSTRUCTCHK.getKey())) {
                    isCanTerm = true;
                }
            } else if (tasktype.equals(ArchiveTaskTypeEnum.DATACLEAN.getKey()) && (tasknode.equals(ArchiveTaskNodeEnum.TASKSTART.getKey()) || tasknode.equals(ArchiveTaskNodeEnum.PKINSERT.getKey()))) {
                isCanTerm = true;
            }
        }
        return isCanTerm;
    }
}

