/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.bdsync;

import java.util.EventObject;
import kd.bos.bdsync.BDSyncCheckMsg;
import kd.bos.bdsync.BDSyncImpl;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BdsyncCheckPlugin
extends AbstractFormPlugin {
    private static final String ENTITY = "cbs_bdsync_config";
    private static final String ERROR_MESSAGE = "errormessages";
    private static final String CHECK_REPAIR_BTN = "checkrepair";
    private static final String CHECK_REPAIR_OP = "donothing";
    private static final String CHECK_ERROR = "CHECK_ERROR";
    private static final String SYNC_STATUS_ERROR = "SYNC_STATUS_ERROR";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{CHECK_REPAIR_BTN});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView formView = this.getView();
        IDataModel dataModel = this.getModel();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String checkError = (String)formShowParameter.getCustomParam(CHECK_ERROR);
        String syncStatusError = (String)formShowParameter.getCustomParam(SYNC_STATUS_ERROR);
        String errorMessage = "";
        if (checkError != null) {
            errorMessage = checkError;
        }
        if (syncStatusError != null) {
            errorMessage = syncStatusError;
            formView.setVisible(Boolean.valueOf(false), new String[]{CHECK_REPAIR_BTN});
        }
        dataModel.setValue(ERROR_MESSAGE, (Object)errorMessage);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IFormView formView = this.getView();
        IListView parentListView = (IListView)formView.getParentView();
        FormOperate form = (FormOperate)args.getSource();
        String operateKey = form.getOperateKey();
        if (CHECK_REPAIR_OP.equals(operateKey)) {
            DBRoute targetRoute;
            BDSyncImpl bdSync = new BDSyncImpl();
            Object fid = parentListView.getSelectedRows().get(0).getPrimaryKeyValue();
            String entityNumber = this.getEntityNumber(fid);
            BDSyncCheckMsg bdSyncCheckMsg = bdSync.check(entityNumber, targetRoute = this.getTargetRoute(fid));
            if (!bdSyncCheckMsg.getErrorInfos().isEmpty()) {
                bdSync.repairErrorRow(entityNumber, targetRoute, bdSyncCheckMsg.getErrorInfos());
            }
            formView.showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f\u3002", (String)"BdsyncCheckPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
    }

    private String getEntityNumber(Object fid) {
        QFilter filter = new QFilter("id", "=", fid);
        return (String)QueryServiceHelper.queryOne((String)ENTITY, (String)"entitynumber", (QFilter[])new QFilter[]{filter}).get("entitynumber");
    }

    private DBRoute getTargetRoute(Object fid) {
        return DBRoute.of((String)this.getTargetRouteField(fid));
    }

    private String getTargetRouteField(Object fid) {
        QFilter filter = new QFilter("id", "=", fid);
        return (String)QueryServiceHelper.queryOne((String)ENTITY, (String)"targetroute", (QFilter[])new QFilter[]{filter}).get("targetroute");
    }
}

